/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.module;

import io.activej.inject.InstanceInjector;
import io.activej.inject.InstanceProvider;
import io.activej.inject.Key;
import io.activej.inject.KeyPattern;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingGenerator;
import io.activej.inject.binding.BindingTransformer;
import io.activej.inject.binding.Multibinder;
import io.activej.inject.binding.Multibinders;
import io.activej.inject.binding.OptionalDependency;
import io.activej.inject.module.Module;
import io.activej.inject.module.ModuleBuilder0;
import io.activej.inject.module.ModuleBuilderImpl;
import io.activej.types.Types;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ModuleBuilder {
    public static ModuleBuilder create() {
        return new ModuleBuilderImpl();
    }

    public ModuleBuilder install(Collection<Module> var1);

    default public ModuleBuilder install(Module ... modules) {
        return this.install(Arrays.asList(modules));
    }

    public ModuleBuilder scan(@NotNull Class<?> var1, @Nullable Object var2);

    default public ModuleBuilder scan(Object container) {
        return this.scan(container.getClass(), container);
    }

    default public ModuleBuilder scan(Class<?> container) {
        return this.scan(container, null);
    }

    default public <T> ModuleBuilder0<T> bind(Class<T> cls) {
        return this.bind(Key.of(cls));
    }

    default public <T> ModuleBuilder0<T> bind(Class<T> cls, Object qualifier) {
        return this.bind(Key.of(cls, qualifier));
    }

    public <T> ModuleBuilder0<T> bind(@NotNull Key<T> var1);

    default public <T> ModuleBuilder bindInstanceProvider(Class<T> type) {
        return this.bindInstanceProvider(Key.of(type));
    }

    default public <T> ModuleBuilder bindInstanceProvider(Key<T> key) {
        return this.bind(Key.ofType(Types.parameterizedType(InstanceProvider.class, (Type[])new Type[]{key.getType()}), key.getQualifier()));
    }

    default public <T> ModuleBuilder bindInstanceInjector(Class<T> type) {
        return this.bindInstanceInjector(Key.of(type));
    }

    default public <T> ModuleBuilder bindInstanceInjector(Key<T> key) {
        return this.bind(Key.ofType(Types.parameterizedType(InstanceInjector.class, (Type[])new Type[]{key.getType()}), key.getQualifier()));
    }

    default public <T> ModuleBuilder bindOptionalDependency(Class<T> type) {
        return this.bindOptionalDependency(Key.of(type));
    }

    default public <T> ModuleBuilder bindOptionalDependency(Key<T> key) {
        return this.bind(Key.ofType(Types.parameterizedType(OptionalDependency.class, (Type[])new Type[]{key.getType()}), key.getQualifier()));
    }

    public <S, T extends S> ModuleBuilder bindIntoSet(Key<S> var1, Binding<T> var2);

    default public <S, T extends S> ModuleBuilder bindIntoSet(Key<S> setOf, Key<T> item) {
        return this.bindIntoSet(setOf, Binding.to(item));
    }

    public <T> ModuleBuilder generate(KeyPattern<T> var1, BindingGenerator<T> var2);

    default public <T> ModuleBuilder generate(Class<T> pattern, BindingGenerator<T> bindingGenerator) {
        return this.generate(KeyPattern.of(pattern), bindingGenerator);
    }

    public <T> ModuleBuilder transform(KeyPattern<T> var1, BindingTransformer<T> var2);

    default public <T> ModuleBuilder transform(Class<T> pattern, BindingTransformer<T> bindingTransformer) {
        return this.transform(KeyPattern.of(pattern), bindingTransformer);
    }

    public <T> ModuleBuilder multibind(Key<T> var1, Multibinder<T> var2);

    default public <V> ModuleBuilder multibindToSet(Class<V> type) {
        return this.multibindToSet(Key.of(type));
    }

    default public <V> ModuleBuilder multibindToSet(Class<V> type, Object qualifier) {
        return this.multibindToSet(Key.of(type, qualifier));
    }

    default public <V> ModuleBuilder multibindToSet(Key<V> key) {
        return this.multibind(Key.ofType(Types.parameterizedType(Set.class, (Type[])new Type[]{key.getType()}), key.getQualifier()), Multibinders.toSet());
    }

    default public <K, V> ModuleBuilder multibindToMap(Class<K> keyType, Class<V> valueType) {
        return this.multibindToMap(keyType, valueType, null);
    }

    default public <K, V> ModuleBuilder multibindToMap(Class<K> keyType, Class<V> valueType, Object qualifier) {
        return this.multibind(Key.ofType(Types.parameterizedType(Map.class, (Type[])new Type[]{keyType, valueType}), qualifier), Multibinders.toMap());
    }

    public Module build();
}

