/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.module;

import io.activej.inject.Key;
import io.activej.inject.KeyPattern;
import io.activej.inject.Scope;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingGenerator;
import io.activej.inject.binding.BindingTransformer;
import io.activej.inject.binding.BindingType;
import io.activej.inject.binding.Multibinder;
import io.activej.inject.binding.Multibinders;
import io.activej.inject.module.Module;
import io.activej.inject.module.ModuleBuilder;
import io.activej.inject.module.ModuleBuilder0;
import io.activej.inject.module.ModuleBuilder1;
import io.activej.inject.util.LocationInfo;
import io.activej.inject.util.ReflectionUtils;
import io.activej.inject.util.Trie;
import io.activej.inject.util.Utils;
import io.activej.types.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ModuleBuilderImpl<T>
implements ModuleBuilder1<T> {
    private final Trie<Scope, Map<Key<?>, Set<Binding<?>>>> bindings = Trie.leaf(new HashMap());
    private final Map<KeyPattern<?>, Set<BindingGenerator<?>>> bindingGenerators = new HashMap();
    private final Map<KeyPattern<?>, Set<BindingTransformer<?>>> bindingTransformers = new HashMap();
    private final Map<Key<?>, Multibinder<?>> multibinders = new HashMap();
    @Nullable
    private BindingDesc current = null;
    private final String name;
    @Nullable
    private final StackTraceElement location;

    ModuleBuilderImpl() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        this.location = trace.length >= 3 ? trace[3] : null;
        this.name = this.getClass().getName();
    }

    ModuleBuilderImpl(String name, @Nullable StackTraceElement location) {
        this.name = name;
        this.location = location;
    }

    private void completePreviousStep() {
        if (this.current != null) {
            this.addBinding(this.current);
            this.current = null;
        }
    }

    private void addBinding(BindingDesc desc) {
        Set bindingSet = this.bindings.computeIfAbsent((Scope[])desc.scope, $ -> new HashMap()).get().computeIfAbsent(desc.key, $ -> new HashSet());
        if (desc.binding != null) {
            bindingSet.add(desc.type == null ? desc.binding : desc.binding.as(desc.type));
        }
    }

    public <U> ModuleBuilder0<U> bind(@NotNull Key<U> key) {
        this.completePreviousStep();
        this.current = new BindingDesc(key, null);
        return this;
    }

    private BindingDesc ensureCurrent() {
        BindingDesc desc = this.current;
        Utils.checkState(desc != null, "Cannot configure binding before bind(...) call");
        return desc;
    }

    @Override
    public ModuleBuilder1<T> in(Scope[] scope) {
        BindingDesc desc = this.ensureCurrent();
        if (desc.scope.length != 0) {
            throw new IllegalStateException("Already bound to scope " + Utils.getScopeDisplayString(desc.scope));
        }
        BindingDesc.access$102(desc, scope);
        return this;
    }

    @Override
    public ModuleBuilder1<T> in(@NotNull Scope scope, Scope ... scopes) {
        Scope[] joined = new Scope[scopes.length + 1];
        joined[0] = scope;
        System.arraycopy(scopes, 0, joined, 1, scopes.length);
        return this.in(joined);
    }

    @Override
    public ModuleBuilder1<T> in(@NotNull Class<? extends Annotation> annotationClass, Class<?> ... annotationClasses) {
        return this.in((Scope[])Stream.concat(Stream.of(annotationClass), Arrays.stream(annotationClasses)).map(Scope::of).toArray(Scope[]::new));
    }

    @Override
    public ModuleBuilder1<T> to(@NotNull Binding<? extends T> binding) {
        BindingDesc desc = this.ensureCurrent();
        Utils.checkState(desc.binding == null, "Already mapped to a binding");
        if (binding.getLocation() == null) {
            binding.at(LocationInfo.from(this));
        }
        desc.binding = binding;
        return this;
    }

    @Override
    public ModuleBuilder1<T> as(BindingType type) {
        BindingDesc current = this.ensureCurrent();
        Utils.checkState(current.type == null, "Binding was already set to eager or transient");
        current.type = type;
        return this;
    }

    @Override
    public ModuleBuilder scan(@NotNull Class<?> moduleClass, @Nullable Object module) {
        return this.install(ReflectionUtils.scanClassHierarchy(moduleClass, module).values());
    }

    @Override
    public ModuleBuilder install(Collection<Module> modules) {
        this.completePreviousStep();
        for (Module module : modules) {
            this.bindings.addAll(module.getBindings(), Utils.bindingMultimapMerger());
            Utils.combineMultimap(this.bindingGenerators, module.getBindingGenerators());
            Utils.combineMultimap(this.bindingTransformers, module.getBindingTransformers());
            Utils.mergeMultibinders(this.multibinders, module.getMultibinders());
        }
        return this;
    }

    public <S, E extends S> ModuleBuilder bindIntoSet(Key<S> setOf, Binding<E> binding) {
        this.completePreviousStep();
        Key set = Key.ofType(Types.parameterizedType(Set.class, (Type[])new Type[]{setOf.getType()}), setOf.getQualifier());
        this.addBinding(new BindingDesc(set, binding.mapInstance(Collections::singleton)));
        this.multibinders.put(set, Multibinders.toSet());
        return this;
    }

    public <E> ModuleBuilder generate(KeyPattern<E> pattern, BindingGenerator<E> bindingGenerator) {
        this.completePreviousStep();
        this.bindingGenerators.computeIfAbsent(pattern, $ -> new HashSet()).add((bindings, scope, key) -> {
            Binding generated = bindingGenerator.generate(bindings, scope, key);
            if (generated != null && generated.getLocation() == null) {
                generated.at(LocationInfo.from(this));
            }
            return generated;
        });
        return this;
    }

    public <E> ModuleBuilder transform(KeyPattern<E> pattern, BindingTransformer<E> bindingTransformer) {
        this.completePreviousStep();
        this.bindingTransformers.computeIfAbsent(pattern, $ -> new HashSet()).add((bindings, scope, key, binding) -> {
            Binding transformed = bindingTransformer.transform(bindings, scope, key, binding);
            if (!binding.equals(transformed) && transformed.getLocation() == null) {
                transformed.at(LocationInfo.from(this));
            }
            return transformed;
        });
        return this;
    }

    public <E> ModuleBuilder multibind(Key<E> key, Multibinder<E> multibinder) {
        this.completePreviousStep();
        this.multibinders.put(key, multibinder);
        return this;
    }

    @Override
    public Module build() {
        this.completePreviousStep();
        return new Module(){

            @Override
            public Trie<Scope, Map<Key<?>, Set<Binding<?>>>> getBindings() {
                return ModuleBuilderImpl.this.bindings;
            }

            @Override
            public Map<KeyPattern<?>, Set<BindingGenerator<?>>> getBindingGenerators() {
                return ModuleBuilderImpl.this.bindingGenerators;
            }

            @Override
            public Map<KeyPattern<?>, Set<BindingTransformer<?>>> getBindingTransformers() {
                return ModuleBuilderImpl.this.bindingTransformers;
            }

            @Override
            public Map<Key<?>, Multibinder<?>> getMultibinders() {
                return ModuleBuilderImpl.this.multibinders;
            }
        };
    }

    public String toString() {
        return this.name + "(at " + (this.location != null ? this.location : "<unknown module location>") + ')';
    }

    private static final class BindingDesc {
        private final Key<?> key;
        private Binding<?> binding;
        private Scope[] scope;
        private BindingType type;

        BindingDesc(Key<?> key, Binding<?> binding) {
            this.key = key;
            this.binding = binding;
            this.scope = Scope.UNSCOPED;
        }

        static /* synthetic */ Scope[] access$102(BindingDesc x0, Scope[] x1) {
            x0.scope = x1;
            return x1;
        }
    }
}

