/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.util;

import io.activej.inject.util.ReflectionUtils;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocationInfo {
    private final Object module;
    @Nullable
    private final Method provider;

    private LocationInfo(Object module, @Nullable Method provider) {
        this.module = module;
        this.provider = provider;
    }

    public static LocationInfo from(@NotNull Object module, @NotNull Method provider) {
        return new LocationInfo(module, provider);
    }

    public static LocationInfo from(@NotNull Object module) {
        return new LocationInfo(module, null);
    }

    @NotNull
    public Object getModule() {
        return this.module;
    }

    @Nullable
    public Method getProvider() {
        return this.provider;
    }

    public String toString() {
        if (this.provider == null) {
            return "module " + this.module;
        }
        String shortName = ReflectionUtils.getShortName(this.provider.getDeclaringClass());
        return "object " + this.module + ", provider method " + shortName + "." + this.provider.getName() + "(" + shortName + ".java:0)";
    }
}

