/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.util;

import io.activej.inject.Key;
import io.activej.inject.KeyPattern;
import io.activej.inject.Qualifiers;
import io.activej.inject.Scope;
import io.activej.inject.annotation.Eager;
import io.activej.inject.annotation.Inject;
import io.activej.inject.annotation.Named;
import io.activej.inject.annotation.Provides;
import io.activej.inject.annotation.ProvidesIntoSet;
import io.activej.inject.annotation.QualifierAnnotation;
import io.activej.inject.annotation.ScopeAnnotation;
import io.activej.inject.annotation.Scopes;
import io.activej.inject.annotation.ShortTypeName;
import io.activej.inject.annotation.Transient;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingGenerator;
import io.activej.inject.binding.BindingType;
import io.activej.inject.binding.DIException;
import io.activej.inject.binding.Multibinders;
import io.activej.inject.impl.BindingInitializer;
import io.activej.inject.impl.BindingLocator;
import io.activej.inject.impl.CompiledBinding;
import io.activej.inject.impl.CompiledBindingInitializer;
import io.activej.inject.impl.CompiledBindingLocator;
import io.activej.inject.module.Module;
import io.activej.inject.module.ModuleBuilder;
import io.activej.inject.module.ModuleBuilder1;
import io.activej.inject.util.LocationInfo;
import io.activej.inject.util.TypeUtils;
import io.activej.inject.util.Utils;
import io.activej.types.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtils {
    private static final String IDENT = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern PACKAGE = Pattern.compile("(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*");
    private static final Pattern PACKAGE_AND_PARENT = Pattern.compile(PACKAGE.pattern() + "(?:" + "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*" + "\\$\\d*)?");
    private static final Pattern ARRAY_SIGNATURE = Pattern.compile("\\[L(.*?);");
    private static final Pattern RAW_PART = Pattern.compile("^\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");

    public static String getDisplayName(Type type) {
        String typeName;
        Class raw = Types.getRawType((Type)type);
        if (raw.isAnonymousClass()) {
            Type superclass = raw.getGenericSuperclass();
            typeName = "? extends " + superclass.getTypeName();
        } else {
            typeName = type.getTypeName();
        }
        String defaultName = PACKAGE_AND_PARENT.matcher(ARRAY_SIGNATURE.matcher(typeName).replaceAll("$1[]")).replaceAll("");
        ShortTypeName override = raw.getDeclaredAnnotation(ShortTypeName.class);
        return override != null ? RAW_PART.matcher(defaultName).replaceFirst(override.value()) : defaultName;
    }

    public static String getShortName(Type type) {
        return PACKAGE.matcher(ARRAY_SIGNATURE.matcher(type.getTypeName()).replaceAll("$1[]")).replaceAll("");
    }

    @Nullable
    public static Object getOuterClassInstance(Object innerClassInstance) {
        if (innerClassInstance == null) {
            return null;
        }
        Class<?> cls = innerClassInstance.getClass();
        Class<?> enclosingClass = cls.getEnclosingClass();
        if (enclosingClass == null) {
            return null;
        }
        for (Field field : cls.getDeclaredFields()) {
            if (!field.isSynthetic() || !field.getName().startsWith("this$") || field.getType() != enclosingClass) continue;
            field.setAccessible(true);
            try {
                return field.get(innerClassInstance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    public static Object qualifierOf(AnnotatedElement annotatedElement) {
        ArrayList<Annotation> names = new ArrayList<Annotation>();
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(QualifierAnnotation.class)) continue;
            names.add(annotation);
        }
        switch (names.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Annotation annotation = (Annotation)names.iterator().next();
                if (annotation instanceof Named) {
                    return ((Named)annotation).value();
                }
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (Utils.isMarker(annotationType)) {
                    return annotationType;
                }
                return annotation;
            }
        }
        throw new DIException("More than one name annotation on " + annotatedElement);
    }

    public static <T> Key<T> keyOf(@Nullable Type container, Type type, AnnotatedElement annotatedElement) {
        return Key.ofType(container != null ? Types.bind((Type)type, (Map)Types.getAllTypeBindings((Type)container)) : type, ReflectionUtils.qualifierOf(annotatedElement));
    }

    public static Scope[] getScope(AnnotatedElement annotatedElement) {
        Annotation[] annotations = annotatedElement.getDeclaredAnnotations();
        Set scopes = Arrays.stream(annotations).filter(annotation -> annotation.annotationType().isAnnotationPresent(ScopeAnnotation.class)).collect(Collectors.toSet());
        Scopes nested = Arrays.stream(annotations).filter(annotation -> annotation.annotationType() == Scopes.class).findAny().orElse(null);
        if (nested != null) {
            if (scopes.isEmpty()) {
                return (Scope[])Arrays.stream(nested.value()).map(Scope::of).toArray(Scope[]::new);
            }
            throw new DIException("Cannot have both @Scoped and a scope annotation on " + annotatedElement);
        }
        switch (scopes.size()) {
            case 0: {
                return Scope.UNSCOPED;
            }
            case 1: {
                return new Scope[]{Scope.of((Annotation)scopes.iterator().next())};
            }
        }
        throw new DIException("More than one scope annotation on " + annotatedElement);
    }

    public static <T extends AnnotatedElement & Member> List<T> getAnnotatedElements(Class<?> cls, Class<? extends Annotation> annotationType, Function<Class<?>, T[]> extractor, boolean allowStatic) {
        ArrayList<AnnotatedElement> result = new ArrayList<AnnotatedElement>();
        while (cls != null) {
            for (AnnotatedElement element : (AnnotatedElement[])extractor.apply(cls)) {
                if (!element.isAnnotationPresent(annotationType)) continue;
                if (!allowStatic && Modifier.isStatic(((Member)((Object)element)).getModifiers())) {
                    throw new DIException("@" + annotationType.getSimpleName() + " annotation is not allowed on " + element);
                }
                result.add(element);
            }
            cls = cls.getSuperclass();
        }
        return result;
    }

    public static <T> Binding<T> generateImplicitBinding(Key<T> key) {
        Binding<T> binding = ReflectionUtils.generateConstructorBinding(key);
        return binding != null ? binding.initializeWith(ReflectionUtils.generateInjectingInitializer(key)).as(BindingType.SYNTHETIC) : null;
    }

    @Nullable
    public static <T> Binding<T> generateConstructorBinding(Key<T> key) {
        Class cls = key.getRawType();
        Inject classInjectAnnotation = cls.getAnnotation(Inject.class);
        Set injectConstructors = Arrays.stream(cls.getDeclaredConstructors()).filter(c -> c.isAnnotationPresent(Inject.class)).collect(Collectors.toSet());
        Set factoryMethods = Arrays.stream(cls.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Inject.class) && method.getReturnType() == cls && Modifier.isStatic(method.getModifiers())).collect(Collectors.toSet());
        if (classInjectAnnotation != null) {
            if (!injectConstructors.isEmpty()) {
                throw ReflectionUtils.failedImplicitBinding(key, "inject annotation on class with inject constructor");
            }
            if (!factoryMethods.isEmpty()) {
                throw ReflectionUtils.failedImplicitBinding(key, "inject annotation on class with inject factory method");
            }
            Class<?> enclosingClass = cls.getEnclosingClass();
            if (enclosingClass != null && !Modifier.isStatic(cls.getModifiers())) {
                try {
                    return ReflectionUtils.bindingFromConstructor(key, cls.getDeclaredConstructor(enclosingClass));
                }
                catch (NoSuchMethodException e) {
                    throw ReflectionUtils.failedImplicitBinding(key, "inject annotation on local class that closes over outside variables and/or has no default constructor");
                }
            }
            try {
                return ReflectionUtils.bindingFromConstructor(key, cls.getDeclaredConstructor(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw ReflectionUtils.failedImplicitBinding(key, "inject annotation on class with no default constructor");
            }
        }
        if (injectConstructors.size() > 1) {
            throw ReflectionUtils.failedImplicitBinding(key, "more than one inject constructor");
        }
        if (!injectConstructors.isEmpty()) {
            if (!factoryMethods.isEmpty()) {
                throw ReflectionUtils.failedImplicitBinding(key, "both inject constructor and inject factory method are present");
            }
            return ReflectionUtils.bindingFromConstructor(key, (Constructor)injectConstructors.iterator().next());
        }
        if (factoryMethods.size() > 1) {
            throw ReflectionUtils.failedImplicitBinding(key, "more than one inject factory method");
        }
        if (!factoryMethods.isEmpty()) {
            return ReflectionUtils.bindingFromMethod(null, (Method)factoryMethods.iterator().next());
        }
        return null;
    }

    private static DIException failedImplicitBinding(Key<?> requestedKey, String message) {
        return new DIException("Failed to generate implicit binding for " + requestedKey.getDisplayString() + ", " + message);
    }

    public static <T> BindingInitializer<T> generateInjectingInitializer(Key<T> container) {
        Class<T> rawType = container.getRawType();
        List initializers = Stream.concat(ReflectionUtils.getAnnotatedElements(rawType, Inject.class, Class::getDeclaredFields, false).stream().map(field -> ReflectionUtils.fieldInjector(container, field)), ReflectionUtils.getAnnotatedElements(rawType, Inject.class, Class::getDeclaredMethods, true).stream().filter(method -> !Modifier.isStatic(method.getModifiers())).map(method -> ReflectionUtils.methodInjector(container, method))).collect(Collectors.toList());
        return BindingInitializer.combine(initializers);
    }

    public static <T> BindingInitializer<T> fieldInjector(Key<T> container, final Field field) {
        field.setAccessible(true);
        final Key<T> key = ReflectionUtils.keyOf(container.getType(), field.getGenericType(), field);
        return new BindingInitializer<T>(Collections.singleton(key)){

            @Override
            public CompiledBindingInitializer<T> compile(CompiledBindingLocator compiledBindings) {
                final CompiledBinding binding = compiledBindings.get(key);
                return new CompiledBindingInitializer<T>(){

                    @Override
                    public void initInstance(T instance, AtomicReferenceArray[] instances, int synchronizedScope) {
                        Object arg = binding.getInstance(instances, synchronizedScope);
                        try {
                            field.set(instance, arg);
                        }
                        catch (IllegalAccessException e) {
                            throw new DIException("Not allowed to set injectable field " + field, e);
                        }
                    }
                };
            }
        };
    }

    public static <T> BindingInitializer<T> methodInjector(Key<T> container, final Method method) {
        method.setAccessible(true);
        final Key[] dependencies = ReflectionUtils.toDependencies(container.getType(), method);
        return new BindingInitializer<T>(new HashSet(Arrays.asList(dependencies))){

            @Override
            public CompiledBindingInitializer<T> compile(CompiledBindingLocator compiledBindings) {
                final CompiledBinding[] argBindings = (CompiledBinding[])Stream.of(dependencies).map(compiledBindings::get).toArray(CompiledBinding[]::new);
                return new CompiledBindingInitializer<T>(){

                    @Override
                    public void initInstance(T instance, AtomicReferenceArray[] instances, int synchronizedScope) {
                        Object[] args = new Object[argBindings.length];
                        for (int i = 0; i < argBindings.length; ++i) {
                            args[i] = argBindings[i].getInstance(instances, synchronizedScope);
                        }
                        try {
                            method.invoke(instance, args);
                        }
                        catch (IllegalAccessException e) {
                            throw new DIException("Not allowed to call injectable method " + method, e);
                        }
                        catch (InvocationTargetException e) {
                            throw new DIException("Failed to call injectable method " + method, e.getCause());
                        }
                    }
                };
            }
        };
    }

    public static Key<?>[] toDependencies(@Nullable Type container, Executable executable) {
        Parameter[] parameters = executable.getParameters();
        Key[] dependencies = new Key[parameters.length];
        if (parameters.length == 0) {
            return dependencies;
        }
        Type type = parameters[0].getParameterizedType();
        Parameter parameter = parameters[0];
        dependencies[0] = ReflectionUtils.keyOf(container, type, parameter);
        Type[] genericParameterTypes = executable.getGenericParameterTypes();
        boolean hasImplicitDependency = genericParameterTypes.length != parameters.length;
        boolean workaround = parameters[0].getDeclaringExecutable().getParameterAnnotations().length != parameters.length;
        for (int i = 1; i < dependencies.length; ++i) {
            type = genericParameterTypes[hasImplicitDependency ? i - 1 : i];
            parameter = parameters[workaround ? i - 1 : i];
            dependencies[i] = ReflectionUtils.keyOf(container, type, parameter);
        }
        return dependencies;
    }

    public static <T> Binding<T> bindingFromMethod(@Nullable Object module, Method method) {
        method.setAccessible(true);
        Binding<Object> binding = Binding.to(args -> {
            try {
                Object result = method.invoke(module, args);
                if (result == null) {
                    throw new NullPointerException("@Provides method must return non-null result, method " + method);
                }
                return result;
            }
            catch (IllegalAccessException e) {
                throw new DIException("Not allowed to call method " + method, e);
            }
            catch (InvocationTargetException e) {
                throw new DIException("Failed to call method " + method, e.getCause());
            }
        }, ReflectionUtils.toDependencies(module != null ? module.getClass() : method.getDeclaringClass(), method));
        return module != null ? binding.at(LocationInfo.from(module, method)) : binding;
    }

    public static <T> Binding<T> bindingFromConstructor(Key<T> key, Constructor<T> constructor) {
        constructor.setAccessible(true);
        Key<?>[] dependencies = ReflectionUtils.toDependencies(key.getType(), constructor);
        return Binding.to(args -> {
            try {
                return constructor.newInstance(args);
            }
            catch (InstantiationException e) {
                throw new DIException("Cannot instantiate object from the constructor " + constructor + " to provide requested key " + key, e);
            }
            catch (IllegalAccessException e) {
                throw new DIException("Not allowed to call constructor " + constructor + " to provide requested key " + key, e);
            }
            catch (InvocationTargetException e) {
                throw new DIException("Failed to call constructor " + constructor + " to provide requested key " + key, e.getCause());
            }
        }, dependencies);
    }

    public static Module scanClass(@NotNull Class<?> moduleClass, @Nullable Object module) {
        return ReflectionUtils.scanClassInto(moduleClass, module, ModuleBuilder.create());
    }

    public static Module scanClassInto(@NotNull Class<?> moduleClass, @Nullable Object module, ModuleBuilder builder) {
        for (Method method : moduleClass.getDeclaredMethods()) {
            if (method.isAnnotationPresent(Provides.class)) {
                if (module == null && !Modifier.isStatic(method.getModifiers())) {
                    throw new DIException("Found non-static provider method while scanning for statics, method " + method);
                }
                Object qualifier = ReflectionUtils.qualifierOf(method);
                Scope[] methodScope = ReflectionUtils.getScope(method);
                boolean isEager = method.isAnnotationPresent(Eager.class);
                boolean isTransient = method.isAnnotationPresent(Transient.class);
                TypeVariable<Method>[] methodTypeParameters = method.getTypeParameters();
                HashMap<TypeVariable<Method>, TypeVariable<Method>> mapping = new HashMap<TypeVariable<Method>, TypeVariable<Method>>();
                for (TypeVariable<Method> methodTypeParameter : methodTypeParameters) {
                    mapping.put(methodTypeParameter, methodTypeParameter);
                }
                mapping.putAll(Types.getAllTypeBindings(module != null ? module.getClass() : moduleClass));
                Type returnType = Types.bind((Type)method.getGenericReturnType(), mapping);
                if (methodTypeParameters.length == 0) {
                    Key key = Key.ofType(returnType, qualifier);
                    ModuleBuilder1 binder = builder.bind(key).to(ReflectionUtils.bindingFromMethod(module, method)).in(methodScope);
                    if (isEager) {
                        binder.asEager();
                    }
                    if (!isTransient) continue;
                    binder.asTransient();
                    continue;
                }
                Set unused = Arrays.stream(methodTypeParameters).filter(typeVar -> !TypeUtils.contains(returnType, typeVar)).collect(Collectors.toSet());
                if (!unused.isEmpty()) {
                    throw new DIException("Generic type variables " + unused + " are not used in return type of templated provider method " + method);
                }
                builder.generate(KeyPattern.of(method.getReturnType()), new TemplatedProviderGenerator(methodScope, qualifier, method, module, returnType, isEager ? BindingType.EAGER : (isTransient ? BindingType.TRANSIENT : BindingType.REGULAR)));
                continue;
            }
            if (!method.isAnnotationPresent(ProvidesIntoSet.class)) continue;
            if (module == null && !Modifier.isStatic(method.getModifiers())) {
                throw new DIException("Found non-static provider method while scanning for statics, method " + method);
            }
            if (method.getTypeParameters().length != 0) {
                throw new DIException("@ProvidesIntoSet does not support templated methods, method " + method);
            }
            Class<?> container = module != null ? module.getClass() : moduleClass;
            Type type = Types.bind((Type)method.getGenericReturnType(), (Map)Types.getAllTypeBindings(container));
            Scope[] methodScope = ReflectionUtils.getScope(method);
            boolean isEager = method.isAnnotationPresent(Eager.class);
            boolean isTransient = method.isAnnotationPresent(Transient.class);
            Key key = Key.ofType(type, Qualifiers.uniqueQualifier());
            builder.bind(key).to(ReflectionUtils.bindingFromMethod(module, method)).in(methodScope);
            Key setKey = Key.ofType(Types.parameterizedType(Set.class, (Type[])new Type[]{type}), ReflectionUtils.qualifierOf(method));
            Binding<Set> binding = Binding.to(Collections::singleton, key);
            if (module != null) {
                binding.at(LocationInfo.from(module, method));
            }
            ModuleBuilder1 setBinder = builder.bind(setKey).to(binding).in(methodScope);
            if (isEager) {
                setBinder.asEager();
            }
            if (isTransient) {
                setBinder.asTransient();
            }
            builder.multibind(setKey, Multibinders.toSet());
        }
        return builder.build();
    }

    public static Map<Class<?>, Module> scanClassHierarchy(@NotNull Class<?> moduleClass, @Nullable Object module) {
        HashMap result = new HashMap();
        for (Class<?> cls = moduleClass; cls != Object.class && cls != null; cls = cls.getSuperclass()) {
            result.put(cls, ReflectionUtils.scanClass(cls, module));
        }
        return result;
    }

    private static class TemplatedProviderGenerator
    implements BindingGenerator<Object> {
        private final Scope[] methodScope;
        @Nullable
        private final Object qualifier;
        private final Method method;
        private final Object module;
        private final Type returnType;
        private final BindingType bindingType;

        private TemplatedProviderGenerator(Scope[] methodScope, @Nullable Object qualifier, Method method, Object module, Type returnType, BindingType bindingType) {
            this.methodScope = methodScope;
            this.qualifier = qualifier;
            this.method = method;
            this.module = module;
            this.returnType = returnType;
            this.bindingType = bindingType;
        }

        @Override
        @Nullable
        public Binding<Object> generate(BindingLocator bindings, Scope[] scope, Key<Object> key) {
            if (scope.length < this.methodScope.length || this.qualifier != null && !this.qualifier.equals(key.getQualifier()) || !TypeUtils.matches(key.getType(), this.returnType)) {
                return null;
            }
            for (int i = 0; i < this.methodScope.length; ++i) {
                if (scope[i].equals(this.methodScope[i])) continue;
                return null;
            }
            this.method.setAccessible(true);
            Type genericReturnType = this.method.getGenericReturnType();
            Map<TypeVariable<?>, Type> mapping = TypeUtils.extractMatchingGenerics(genericReturnType, key.getType());
            Key[] dependencies = (Key[])Arrays.stream(this.method.getParameters()).map(parameter -> {
                Type type = Types.bind((Type)parameter.getParameterizedType(), (Map)mapping);
                Object q = ReflectionUtils.qualifierOf(parameter);
                return Key.ofType(type, q);
            }).toArray(Key[]::new);
            Binding<Object> binding = Binding.to(args -> {
                try {
                    Object result = this.method.invoke(this.module, args);
                    if (result == null) {
                        throw new NullPointerException("@Provides method must return non-null result, method " + this.method);
                    }
                    return result;
                }
                catch (IllegalAccessException e) {
                    throw new DIException("Not allowed to call generic method " + this.method + " to provide requested key " + key, e);
                }
                catch (InvocationTargetException e) {
                    throw new DIException("Failed to call generic method " + this.method + " to provide requested key " + key, e.getCause());
                }
            }, dependencies);
            return (this.module != null ? binding.at(LocationInfo.from(this.module, this.method)) : binding).as(this.bindingType);
        }
    }
}

