/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.util;

import io.activej.inject.Key;
import io.activej.inject.Scope;
import io.activej.inject.util.Utils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class ScopedKey {
    private final Scope[] scope;
    private final Key<?> key;

    private ScopedKey(Scope[] scope, Key<?> key) {
        this.scope = scope;
        this.key = key;
    }

    public static ScopedKey of(@NotNull Key<?> key) {
        return new ScopedKey(Scope.UNSCOPED, key);
    }

    public static ScopedKey of(@NotNull Scope scope, @NotNull Key<?> key) {
        return new ScopedKey(new Scope[]{scope}, key);
    }

    public static ScopedKey of(Scope[] scope, @NotNull Key<?> key) {
        return new ScopedKey(scope.length != 0 ? scope : Scope.UNSCOPED, key);
    }

    public Scope[] getScope() {
        return this.scope;
    }

    @NotNull
    public Key<?> getKey() {
        return this.key;
    }

    public boolean isScoped() {
        return this.scope.length != 0;
    }

    public boolean isUnscoped() {
        return this.scope.length == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopedKey other = (ScopedKey)o;
        return Arrays.equals(this.scope, other.scope) && this.key.equals(other.key);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.scope) + this.key.hashCode();
    }

    public String toString() {
        return Utils.getScopeDisplayString(this.scope) + " " + this.key.toString();
    }
}

