/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.util;

import io.activej.types.Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class TypeUtils {
    public static boolean isInheritedFrom(Type type, Type from) {
        return TypeUtils.isInheritedFrom(type, from, new HashMap<Type, Type>());
    }

    public static boolean isInheritedFrom(Type type, Type from, Map<Type, Type> dejaVu) {
        if (from == Object.class) {
            return true;
        }
        if (TypeUtils.matches(type, from, dejaVu) || TypeUtils.matches(from, type, dejaVu)) {
            return true;
        }
        if (!(type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType)) {
            return false;
        }
        Class rawType = Types.getRawType((Type)type);
        Type superclass = rawType.getGenericSuperclass();
        if (superclass != null && TypeUtils.isInheritedFrom(superclass, from, dejaVu)) {
            return true;
        }
        return Arrays.stream(rawType.getGenericInterfaces()).anyMatch(iface -> TypeUtils.isInheritedFrom(iface, from, dejaVu));
    }

    public static boolean matches(Type strict, Type pattern) {
        return TypeUtils.matches(strict, pattern, new HashMap<Type, Type>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean matches(Type strict, Type pattern, Map<Type, Type> dejaVu) {
        if (strict.equals(pattern) || dejaVu.get(strict) == pattern) {
            return true;
        }
        dejaVu.put(strict, pattern);
        try {
            Type[] patternParams;
            if (pattern instanceof WildcardType) {
                WildcardType wildcard = (WildcardType)pattern;
                boolean bl = Arrays.stream(wildcard.getUpperBounds()).allMatch(bound -> TypeUtils.isInheritedFrom(strict, bound, dejaVu)) && Arrays.stream(wildcard.getLowerBounds()).allMatch(bound -> TypeUtils.isInheritedFrom(bound, strict, dejaVu));
                return bl;
            }
            if (pattern instanceof TypeVariable) {
                TypeVariable typevar = (TypeVariable)pattern;
                boolean bl = Arrays.stream(typevar.getBounds()).allMatch(bound -> TypeUtils.isInheritedFrom(strict, bound, dejaVu));
                return bl;
            }
            if (strict instanceof GenericArrayType && pattern instanceof GenericArrayType) {
                boolean typevar = TypeUtils.matches(((GenericArrayType)strict).getGenericComponentType(), ((GenericArrayType)pattern).getGenericComponentType(), dejaVu);
                return typevar;
            }
            if (!(strict instanceof ParameterizedType) || !(pattern instanceof ParameterizedType)) {
                boolean typevar = false;
                return typevar;
            }
            ParameterizedType parameterizedStrict = (ParameterizedType)strict;
            ParameterizedType parameterizedPattern = (ParameterizedType)pattern;
            if (parameterizedPattern.getOwnerType() != null) {
                if (parameterizedStrict.getOwnerType() == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!TypeUtils.matches(parameterizedPattern.getOwnerType(), parameterizedStrict.getOwnerType(), dejaVu)) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (!TypeUtils.matches(parameterizedPattern.getRawType(), parameterizedStrict.getRawType(), dejaVu)) {
                boolean bl = false;
                return bl;
            }
            Type[] strictParams = parameterizedStrict.getActualTypeArguments();
            if (strictParams.length != (patternParams = parameterizedPattern.getActualTypeArguments()).length) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < strictParams.length; ++i) {
                if (TypeUtils.matches(strictParams[i], patternParams[i], dejaVu)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            dejaVu.remove(strict);
        }
    }

    public static boolean contains(Type type, Type sub) {
        if (type.equals(sub)) {
            return true;
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.contains(((GenericArrayType)type).getGenericComponentType(), sub);
        }
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterized = (ParameterizedType)type;
        if (TypeUtils.contains(parameterized.getRawType(), sub)) {
            return true;
        }
        if (parameterized.getOwnerType() != null && TypeUtils.contains(parameterized.getOwnerType(), sub)) {
            return true;
        }
        return Arrays.stream(parameterized.getActualTypeArguments()).anyMatch(argument -> TypeUtils.contains(argument, sub));
    }

    public static Map<TypeVariable<?>, Type> extractMatchingGenerics(Type pattern, Type real) {
        HashMap result = new HashMap();
        TypeUtils.extractMatchingGenerics(pattern, real, result);
        return result;
    }

    private static void extractMatchingGenerics(Type pattern, Type real, Map<TypeVariable<?>, Type> result) {
        Type[] realTypeArgs;
        Type[] patternTypeArgs;
        if (pattern instanceof TypeVariable) {
            result.put((TypeVariable)pattern, real);
            return;
        }
        if (pattern.equals(real)) {
            return;
        }
        if (pattern instanceof GenericArrayType && real instanceof GenericArrayType) {
            TypeUtils.extractMatchingGenerics(((GenericArrayType)pattern).getGenericComponentType(), ((GenericArrayType)real).getGenericComponentType(), result);
            return;
        }
        if (!(pattern instanceof ParameterizedType) || !(real instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedPattern = (ParameterizedType)pattern;
        ParameterizedType parameterizedReal = (ParameterizedType)real;
        if (!parameterizedPattern.getRawType().equals(parameterizedReal.getRawType())) {
            return;
        }
        TypeUtils.extractMatchingGenerics(parameterizedPattern.getRawType(), parameterizedReal.getRawType(), result);
        if (!Objects.equals(parameterizedPattern.getOwnerType(), parameterizedReal.getOwnerType())) {
            return;
        }
        if (parameterizedPattern.getOwnerType() != null) {
            TypeUtils.extractMatchingGenerics(parameterizedPattern.getOwnerType(), parameterizedReal.getOwnerType(), result);
        }
        if ((patternTypeArgs = parameterizedPattern.getActualTypeArguments()).length != (realTypeArgs = parameterizedReal.getActualTypeArguments()).length) {
            return;
        }
        for (int i = 0; i < patternTypeArgs.length; ++i) {
            TypeUtils.extractMatchingGenerics(patternTypeArgs[i], realTypeArgs[i], result);
        }
    }

    public static Type simplifyType(Type original) {
        if (original instanceof Class) {
            return original;
        }
        if (original instanceof GenericArrayType) {
            Type repackedComponentType;
            Type componentType = ((GenericArrayType)original).getGenericComponentType();
            if (componentType != (repackedComponentType = TypeUtils.simplifyType(componentType))) {
                return Types.genericArrayType((Type)repackedComponentType);
            }
            return original;
        }
        if (original instanceof ParameterizedType) {
            Type[] repackedTypeArguments;
            ParameterizedType parameterizedType = (ParameterizedType)original;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (typeArguments != (repackedTypeArguments = TypeUtils.simplifyTypes(typeArguments))) {
                return Types.parameterizedType((Type)parameterizedType.getOwnerType(), (Type)parameterizedType.getRawType(), (Type[])repackedTypeArguments);
            }
            return original;
        }
        if (original instanceof TypeVariable) {
            throw new IllegalArgumentException("Key should not contain a type variable: " + original);
        }
        if (original instanceof WildcardType) {
            Type[] lowerBounds;
            WildcardType wildcardType = (WildcardType)original;
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length == 1) {
                Type upperBound = upperBounds[0];
                if (upperBound != Object.class) {
                    return TypeUtils.simplifyType(upperBound);
                }
            } else if (upperBounds.length > 1) {
                throw new IllegalArgumentException("Multiple upper bounds not supported: " + original);
            }
            if ((lowerBounds = wildcardType.getLowerBounds()).length == 1) {
                return TypeUtils.simplifyType(lowerBounds[0]);
            }
            if (lowerBounds.length > 1) {
                throw new IllegalArgumentException("Multiple lower bounds not supported: " + original);
            }
            return Object.class;
        }
        return original;
    }

    private static Type[] simplifyTypes(Type[] original) {
        int length = original.length;
        for (int i = 0; i < length; ++i) {
            Type typeArgument = original[i];
            Type repackTypeArgument = TypeUtils.simplifyType(typeArgument);
            if (repackTypeArgument == typeArgument) continue;
            Type[] repackedTypeArguments = new Type[length];
            System.arraycopy(original, 0, repackedTypeArguments, 0, i);
            repackedTypeArguments[i++] = repackTypeArgument;
            while (i < length) {
                repackedTypeArguments[i] = TypeUtils.simplifyType(original[i]);
                ++i;
            }
            return repackedTypeArguments;
        }
        return original;
    }
}

