/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.util;

import io.activej.inject.InstanceProvider;
import io.activej.inject.Key;
import io.activej.inject.KeyPattern;
import io.activej.inject.Scope;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingType;
import io.activej.inject.binding.DIException;
import io.activej.inject.binding.Multibinder;
import io.activej.inject.util.LocationInfo;
import io.activej.inject.util.ReflectionUtils;
import io.activej.inject.util.ScopedKey;
import io.activej.inject.util.Trie;
import io.activej.types.IsAssignableUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    private static final BiConsumer<Map<Key<?>, Set<Binding<?>>>, Map<Key<?>, Set<Binding<?>>>> BINDING_MULTIMAP_MERGER = (into, from) -> from.forEach((key, v) -> into.merge(key, v, (set1, set2) -> {
        BindingType type;
        HashSet set = new HashSet(set1.size() + set2.size());
        set.addAll(set1);
        set.addAll(set2);
        BindingType bindingType = type = set.isEmpty() ? null : ((Binding)set.iterator().next()).getType();
        if (set.stream().anyMatch(b -> b.getType() != type)) {
            throw new DIException("Two binding sets bound with different types for key " + key.getDisplayString());
        }
        return set;
    }));

    public static BiConsumer<Map<Key<?>, Set<Binding<?>>>, Map<Key<?>, Set<Binding<?>>>> bindingMultimapMerger() {
        return BINDING_MULTIMAP_MERGER;
    }

    public static <T> T[] next(T[] items, T item) {
        T[] next = Arrays.copyOf(items, items.length + 1);
        next[items.length] = item;
        return next;
    }

    public static String getScopeDisplayString(Scope[] scope) {
        return Arrays.stream(scope).map(Scope::getDisplayString).collect(Collectors.joining("->", "()", ""));
    }

    public static void mergeMultibinders(Map<Key<?>, Multibinder<?>> into, Map<Key<?>, Multibinder<?>> from) {
        from.forEach((k, v) -> into.merge((Key<?>)k, (Multibinder<?>)v, (oldResolver, newResolver) -> {
            if (!oldResolver.equals(newResolver)) {
                throw new DIException("More than one multibinder per key");
            }
            return oldResolver;
        }));
    }

    public static <K, V> void combineMultimap(Map<K, Set<V>> accumulator, Map<K, Set<V>> multimap) {
        multimap.forEach((key, set) -> accumulator.computeIfAbsent(key, $ -> new HashSet()).addAll(set));
    }

    public static <T> Set<T> union(Set<T> first, Set<T> second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        HashSet<T> result = new HashSet<T>((first.size() + second.size()) * 4 / 3 + 1);
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static <K, V> Map<K, V> override(Map<K, V> into, Map<K, V> from) {
        HashMap<K, V> result = new HashMap<K, V>((from.size() + into.size()) * 4 / 3 + 1);
        result.putAll(from);
        result.putAll(into);
        return result;
    }

    public static <T, K, V> Collector<T, ?, Map<K, Set<V>>> toMultimap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collectors.toMap(keyMapper, t -> Collections.singleton(valueMapper.apply(t)), Utils::union);
    }

    public static <K, V> Map<K, V> squash(Map<K, Set<V>> multimap, BiFunction<K, Set<V>, V> squasher) {
        return multimap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> squasher.apply(e.getKey(), (Set)e.getValue())));
    }

    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static String getLocation(@Nullable Binding<?> binding) {
        LocationInfo location = binding != null ? binding.getLocation() : null;
        return "at " + (location != null ? location.toString() : "<unknown binding location>");
    }

    public static void printGraphVizGraph(Trie<Scope, Map<Key<?>, Binding<?>>> trie) {
        System.out.println(Utils.makeGraphVizGraph(trie));
    }

    public static String makeGraphVizGraph(Trie<Scope, Map<Key<?>, Binding<?>>> trie) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph {\n\trankdir=BT;\n");
        HashSet<ScopedKey> known = new HashSet<ScopedKey>();
        Utils.writeNodes(Scope.UNSCOPED, trie, known, "", new int[]{0}, sb);
        Utils.writeEdges(Scope.UNSCOPED, trie, known, sb);
        sb.append("}\n");
        return sb.toString();
    }

    private static void writeNodes(Scope[] scope, Trie<Scope, Map<Key<?>, Binding<?>>> trie, Set<ScopedKey> known, String indent, int[] scopeCount, StringBuilder sb) {
        if (scope != Scope.UNSCOPED) {
            int n = scopeCount[0];
            scopeCount[0] = n + 1;
            sb.append("\n" + indent).append("subgraph cluster_" + n + " {\n").append(indent + "\tlabel=\"" + scope[scope.length - 1].getDisplayString().replace("\"", "\\\"") + "\"\n");
        }
        for (Map.Entry<Scope, Trie<Scope, Map<Key<?>, Binding<?>>>> entry : trie.getChildren().entrySet()) {
            Utils.writeNodes(Utils.next(scope, entry.getKey()), entry.getValue(), known, indent + '\t', scopeCount, sb);
        }
        HashSet leafs = new HashSet();
        for (Map.Entry<Key<?>, Binding<?>> entry : trie.get().entrySet()) {
            Key<?> key2 = entry.getKey();
            Binding<?> bindingInfo = entry.getValue();
            if (bindingInfo.getDependencies().isEmpty()) {
                leafs.add(key2);
            }
            known.add(ScopedKey.of(scope, key2));
            sb.append(indent).append('\t').append('\"' + Utils.getScopeId(scope) + key2.toString().replace("\"", "\\\"") + '\"').append(" [label=\"" + key2.getDisplayString().replace("\"", "\\\"") + '\"').append(bindingInfo.getType() == BindingType.TRANSIENT ? " style=dotted" : (bindingInfo.getType() == BindingType.EAGER ? " style=bold" : (bindingInfo.getType() == BindingType.SYNTHETIC ? " style=dashed" : ""))).append("];").append('\n');
        }
        if (!leafs.isEmpty()) {
            sb.append(leafs.stream().map(key -> '\"' + Utils.getScopeId(scope) + key.toString().replace("\"", "\\\"") + '\"').collect(Collectors.joining(" ", '\n' + indent + '\t' + "{ rank=same; ", " }\n")));
            if (scope == Scope.UNSCOPED) {
                sb.append('\n');
            }
        }
        if (scope != Scope.UNSCOPED) {
            sb.append(indent + "}\n\n");
        }
    }

    private static void writeEdges(Scope[] scope, Trie<Scope, Map<Key<?>, Binding<?>>> trie, Set<ScopedKey> known, StringBuilder sb) {
        String scopePath = Utils.getScopeId(scope);
        for (Map.Entry<Key<?>, Binding<?>> entry : trie.get().entrySet()) {
            String key = "\"" + scopePath + entry.getKey().toString().replace("\"", "\\\"") + "\"";
            for (Key<?> dependency : entry.getValue().getDependencies()) {
                Scope[] depScope = scope;
                while (!known.contains(ScopedKey.of(depScope, dependency)) && depScope.length != 0) {
                    depScope = Arrays.copyOfRange(depScope, 0, depScope.length - 1);
                }
                String dep = '\"' + Utils.getScopeId(depScope) + dependency.toString().replace("\"", "\\\"") + '\"';
                if (depScope.length == 0 && known.add(ScopedKey.of(depScope, dependency))) {
                    sb.append('\t').append(dep).append(" [label=\"" + dependency.getDisplayString().replace("\"", "\\\"") + '\"').append(" style=dashed, color=red];").append('\n');
                }
                sb.append('\t' + key + " -> " + dep);
                sb.append(" [");
                if (dependency.getRawType() == InstanceProvider.class) {
                    sb.append("color=gray");
                }
                sb.append("];\n");
            }
        }
        for (Map.Entry<Object, Object> entry : trie.getChildren().entrySet()) {
            Utils.writeEdges(Utils.next(scope, (Scope)entry.getKey()), (Trie)entry.getValue(), known, sb);
        }
    }

    private static String getScopeId(Scope[] scope) {
        return Arrays.stream(scope).map(Scope::toString).collect(Collectors.joining("->", "()->", "")).replace("\"", "\\\"");
    }

    public static int getKeyDisplayCenter(Key<?> key) {
        Object qualifier = key.getQualifier();
        int nameOffset = qualifier != null ? Utils.getDisplayString(qualifier).length() + 1 : 0;
        return nameOffset + (key.getDisplayString().length() - nameOffset) / 2;
    }

    @NotNull
    public static String getDisplayString(@NotNull Class<? extends Annotation> annotationType, @Nullable Annotation annotation) {
        if (annotation == null) {
            return "@" + ReflectionUtils.getDisplayName(annotationType);
        }
        String typeName = annotationType.getName();
        String str = annotation.toString();
        return str.startsWith("@" + typeName) ? "@" + ReflectionUtils.getDisplayName(annotationType) + str.substring(typeName.length() + 1) : str;
    }

    public static String getDisplayString(@NotNull Object object) {
        if (object instanceof Class && ((Class)object).isAnnotation()) {
            return Utils.getDisplayString((Class)object, null);
        }
        if (object instanceof Annotation) {
            Annotation annotation = (Annotation)object;
            return Utils.getDisplayString(annotation.annotationType(), annotation);
        }
        return object.toString();
    }

    public static String drawCycle(Key<?>[] cycle) {
        int offset = Utils.getKeyDisplayCenter(cycle[0]);
        String cycleString = Arrays.stream(cycle).map(Key::getDisplayString).collect(Collectors.joining(" -> ", "\t", ""));
        String indent = new String(new char[offset]).replace('\u0000', ' ');
        String line = new String(new char[cycleString.length() - offset]).replace('\u0000', '-');
        return cycleString + " -,\n\t" + indent + "^" + line + "'";
    }

    public static boolean isMarker(Class<? extends Annotation> annotationType) {
        return annotationType.getDeclaredMethods().length == 0;
    }

    public static <T> LinkedHashMap<KeyPattern<?>, Set<T>> sortPatternsMap(Map<KeyPattern<?>, Set<T>> map) {
        return map.entrySet().stream().sorted((entry1, entry2) -> {
            Type type2;
            KeyPattern pattern1 = (KeyPattern)entry1.getKey();
            KeyPattern pattern2 = (KeyPattern)entry2.getKey();
            Type type1 = pattern1.getType();
            if (type1.equals(type2 = pattern2.getType())) {
                if (!pattern1.hasQualifier() && pattern2.hasQualifier()) {
                    return 1;
                }
                if (pattern1.hasQualifier() && !pattern2.hasQualifier()) {
                    return -1;
                }
                return Integer.compare(System.identityHashCode(type1), System.identityHashCode(type2));
            }
            if (IsAssignableUtils.isAssignable((Type)type1, (Type)type2)) {
                return 1;
            }
            if (IsAssignableUtils.isAssignable((Type)type2, (Type)type1)) {
                return -1;
            }
            return Integer.compare(System.identityHashCode(type1), System.identityHashCode(type2));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
            throw new AssertionError();
        }, LinkedHashMap::new));
    }

    @Nullable
    public static Type match(Type type, Collection<Type> patterns) {
        Type best = null;
        for (Type found : patterns) {
            if (!IsAssignableUtils.isAssignable((Type)found, (Type)type) || best != null && !IsAssignableUtils.isAssignable(best, (Type)found)) continue;
            if (best != null && !best.equals(found) && IsAssignableUtils.isAssignable((Type)found, (Type)best)) {
                throw new IllegalArgumentException("Conflicting types: " + type + " " + best);
            }
            best = found;
        }
        return best;
    }
}

