/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.stats;

import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.initializer.WithInitializer;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.JmxRefreshableStats;
import io.activej.jmx.stats.JmxStats;
import io.activej.jmx.stats.JmxStatsWithReset;
import io.activej.jmx.stats.JmxStatsWithSmoothingWindow;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public final class EventStats
implements JmxRefreshableStats<EventStats>,
JmxStatsWithSmoothingWindow,
JmxStatsWithReset,
WithInitializer<EventStats> {
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    private static final long MAX_INTERVAL_BETWEEN_REFRESHES = ApplicationSettings.getDuration(JmxStats.class, (String)"maxIntervalBetweenRefreshes", (Duration)Duration.ofHours(1L)).toMillis();
    private static final double LN_2 = Math.log(2.0);
    private long lastTimestampMillis;
    private int lastCount;
    private long totalCount;
    private double smoothedRateCount;
    private double smoothedRateTime;
    private double smoothingWindow;
    private double smoothingWindowCoef;
    private int addedStats;
    @Nullable
    private String rateUnit;
    private int precision = 1000;

    private EventStats(double smoothingWindow) {
        this.smoothingWindow = smoothingWindow;
        this.smoothingWindowCoef = EventStats.calculateSmoothingWindowCoef(smoothingWindow);
    }

    private EventStats() {
        this.smoothingWindow = -1.0;
        this.smoothingWindowCoef = -1.0;
    }

    public static EventStats createAccumulator() {
        return new EventStats();
    }

    public static EventStats create(Duration smoothingWindow) {
        return new EventStats((double)smoothingWindow.toMillis() / 1000.0);
    }

    public EventStats withRateUnit(String rateUnit) {
        this.rateUnit = rateUnit;
        return this;
    }

    public EventStats withPrecision(int precision) {
        Checks.checkArgument((precision > 0 ? 1 : 0) != 0, (Object)"Precision should be a positive value");
        this.precision = precision;
        return this;
    }

    public EventStats withScientificNotation() {
        this.precision = -1;
        return this;
    }

    private static double calculateSmoothingWindowCoef(double smoothingWindow) {
        return -(LN_2 / smoothingWindow);
    }

    @Override
    public void resetStats() {
        this.lastCount = 0;
        this.totalCount = 0L;
        this.lastTimestampMillis = 0L;
        this.smoothedRateCount = 0.0;
        this.smoothedRateTime = 0.0;
    }

    public void recordEvent() {
        ++this.lastCount;
    }

    public void recordEvents(int events) {
        this.lastCount += events;
    }

    public void refresh(long timestamp) {
        long timeElapsedMillis = timestamp - this.lastTimestampMillis;
        if (EventStats.isTimePeriodValid(timeElapsedMillis)) {
            double timeElapsed = (double)timeElapsedMillis * 0.001;
            double smoothingFactor = Math.exp(timeElapsed * this.smoothingWindowCoef);
            this.smoothedRateCount = (double)this.lastCount + this.smoothedRateCount * smoothingFactor;
            this.smoothedRateTime = timeElapsed + this.smoothedRateTime * smoothingFactor;
            this.totalCount += (long)this.lastCount;
            this.lastCount = 0;
        }
        this.lastTimestampMillis = timestamp;
    }

    private static boolean isTimePeriodValid(long timePeriod) {
        return timePeriod < MAX_INTERVAL_BETWEEN_REFRESHES && timePeriod >= 0L;
    }

    @Override
    public void add(EventStats anotherStats) {
        this.totalCount += anotherStats.totalCount;
        this.smoothedRateCount += anotherStats.smoothedRateCount;
        this.smoothedRateTime += anotherStats.smoothedRateTime;
        if (this.addedStats == 0) {
            this.smoothingWindow = anotherStats.smoothingWindow;
            this.smoothingWindowCoef = anotherStats.smoothingWindowCoef;
        } else if (this.smoothingWindow != anotherStats.smoothingWindow) {
            this.smoothingWindow = -1.0;
            this.smoothingWindowCoef = EventStats.calculateSmoothingWindowCoef(this.smoothingWindow);
        }
        ++this.addedStats;
    }

    public static String format(long count, double rate, String rateUnit, DecimalFormat decimalFormat) {
        return count + " @ " + decimalFormat.format(rate) + (rateUnit == null || rateUnit.equals("") ? "" : " " + rateUnit) + "/second";
    }

    @JmxAttribute(optional=true)
    public double getSmoothedRate() {
        return this.totalCount != 0L ? this.smoothedRateCount / this.smoothedRateTime * (double)Math.max(1, this.addedStats) : 0.0;
    }

    @JmxAttribute(optional=true)
    public long getTotalCount() {
        return this.totalCount + (long)this.lastCount;
    }

    @Override
    @JmxAttribute(optional=true)
    public Duration getSmoothingWindow() {
        return Duration.ofMillis((long)(this.smoothingWindow * 1000.0));
    }

    @Override
    @JmxAttribute(optional=true)
    public void setSmoothingWindow(Duration smoothingWindow) {
        this.smoothingWindow = (double)smoothingWindow.toMillis() / 1000.0;
        this.smoothingWindowCoef = EventStats.calculateSmoothingWindowCoef(this.smoothingWindow);
    }

    @JmxAttribute
    public String get() {
        return this.toString();
    }

    public String toString() {
        DecimalFormat decimalFormat;
        if (this.totalCount == 0L) {
            return "";
        }
        double smoothedRate = this.getSmoothedRate();
        if (this.precision == -1) {
            decimalFormat = new DecimalFormat("0.0####E0#", DECIMAL_FORMAT_SYMBOLS);
        } else {
            decimalFormat = new DecimalFormat("0", DECIMAL_FORMAT_SYMBOLS);
            decimalFormat.setMaximumFractionDigits((int)Math.ceil(Math.min(Math.max(-Math.log10(smoothedRate / (double)this.precision), 0.0), 6.0)));
        }
        String result = EventStats.format(this.totalCount, smoothedRate, this.rateUnit, decimalFormat);
        if (this.addedStats != 0) {
            result = result + "  [" + this.addedStats + ']';
        }
        return result;
    }
}

