/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.stats;

import io.activej.common.initializer.WithInitializer;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.JmxStats;
import io.activej.jmx.stats.JmxStatsWithReset;
import io.activej.jmx.stats.MBeanFormat;
import java.time.Instant;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class ExceptionStats
implements JmxStats<ExceptionStats>,
JmxStatsWithReset,
WithInitializer<ExceptionStats> {
    private static final long DETAILS_REFRESH_TIMEOUT = 1000L;
    @Nullable
    private Class<? extends Throwable> exceptionClass;
    private int count;
    private long lastExceptionTimestamp;
    @Nullable
    private Throwable throwable;
    @Nullable
    private Object context;

    private ExceptionStats() {
    }

    public static ExceptionStats create() {
        return new ExceptionStats();
    }

    public void recordException(Throwable e, @Nullable Object context) {
        ++this.count;
        long now = System.currentTimeMillis();
        if (now >= this.lastExceptionTimestamp + 1000L) {
            this.exceptionClass = e != null ? e.getClass() : null;
            this.throwable = e;
            this.context = context;
            this.lastExceptionTimestamp = now;
        }
    }

    public void recordException(Throwable e) {
        this.recordException(e, null);
    }

    @Override
    public void resetStats() {
        this.count = 0;
        this.lastExceptionTimestamp = 0L;
        this.exceptionClass = null;
        this.throwable = null;
        this.context = null;
    }

    @Override
    public void add(ExceptionStats another) {
        this.count += another.count;
        if (another.lastExceptionTimestamp >= this.lastExceptionTimestamp) {
            this.lastExceptionTimestamp = another.lastExceptionTimestamp;
            this.exceptionClass = another.exceptionClass;
            this.throwable = another.throwable;
            this.context = another.context;
        }
    }

    @JmxAttribute(optional=true)
    public int getTotal() {
        return this.count;
    }

    @JmxAttribute(optional=true)
    @Nullable
    public String getLastType() {
        return this.exceptionClass != null ? this.exceptionClass.toString() : null;
    }

    @JmxAttribute(optional=true)
    @Nullable
    public Instant getLastTime() {
        return this.lastExceptionTimestamp != 0L ? Instant.ofEpochMilli(this.lastExceptionTimestamp) : null;
    }

    @JmxAttribute(optional=true)
    @Nullable
    public Throwable getLastException() {
        return this.throwable;
    }

    @JmxAttribute(optional=true)
    @Nullable
    public String getLastMessage() {
        return this.throwable != null ? this.throwable.getMessage() : null;
    }

    @JmxAttribute
    public String getMultilineError() {
        if (this.count == 0) {
            return "";
        }
        StringBuilder summary = new StringBuilder("Count: " + this.count + " " + MBeanFormat.formatTimestamp(this.lastExceptionTimestamp));
        if (this.throwable != null) {
            summary.append("\nStack Trace: ");
            summary.append(MBeanFormat.formatExceptionMultiline(this.throwable).trim());
        }
        if (this.context != null) {
            summary.append("\nContext: ");
            summary.append(this.context);
        }
        return summary.toString();
    }

    @JmxAttribute
    @Nullable
    public List<String> getError() {
        return MBeanFormat.formatMultilineStringAsList(this.getMultilineError());
    }

    public String toString() {
        String last = "";
        if (this.exceptionClass != null) {
            last = "; " + this.exceptionClass.getSimpleName();
            last = last + " @" + MBeanFormat.formatTimestamp(this.lastExceptionTimestamp);
        }
        return this.count + last;
    }

    @Nullable
    public Object getContext() {
        return this.context;
    }
}

