/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.stats;

import io.activej.common.StringFormatUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class MBeanFormat {
    public static String formatExceptionMultiline(@Nullable Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String formatTimestamp(long timestamp) {
        if (timestamp == 0L) {
            return "";
        }
        Instant instant = Instant.ofEpochMilli(timestamp);
        Duration ago = Duration.between(instant, Instant.ofEpochMilli(System.currentTimeMillis())).withNanos(0);
        return StringFormatUtils.formatInstant((Instant)instant) + " (" + StringFormatUtils.formatDuration((Duration)ago) + " ago)";
    }

    public static String formatListAsMultilineString(@Nullable List<?> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        List strings = list.stream().map(Object::toString).collect(Collectors.toList());
        return (strings.stream().anyMatch(s -> s.contains("\n")) ? strings.stream().map(s -> s + "\n") : strings.stream()).collect(Collectors.joining("\n")).trim();
    }

    @Nullable
    public static List<String> formatMultilineStringAsList(@Nullable String multiline) {
        if (multiline == null) {
            return null;
        }
        return multiline.isEmpty() ? null : Arrays.asList(multiline.split("\n"));
    }
}

