/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.stats;

import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.initializer.WithInitializer;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.JmxHistogram;
import io.activej.jmx.stats.JmxRefreshableStats;
import io.activej.jmx.stats.JmxStats;
import io.activej.jmx.stats.JmxStatsWithReset;
import io.activej.jmx.stats.JmxStatsWithSmoothingWindow;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nullable;

public final class ValueStats
implements JmxRefreshableStats<ValueStats>,
JmxStatsWithReset,
JmxStatsWithSmoothingWindow,
WithInitializer<ValueStats> {
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    private static final long MAX_INTERVAL_BETWEEN_REFRESHES = ApplicationSettings.getDuration(JmxStats.class, (String)"maxIntervalBetweenRefreshes", (Duration)Duration.ofHours(1L)).toMillis();
    private static final double LN_2 = Math.log(2.0);
    private static final String NEG_INF = "-\u221e";
    private static final String POS_INF = "+\u221e";
    private long lastTimestampMillis;
    private int lastValueInteger;
    private int lastSumInteger;
    private int lastSqrInteger;
    private int lastCountInteger;
    private int lastMinInteger;
    private int lastMaxInteger;
    private double lastValueDouble;
    private double lastSumDouble;
    private double lastSqrDouble;
    private int lastCountDouble;
    private double lastMinDouble = Double.MAX_VALUE;
    private double lastMaxDouble = -1.7976931348623157E308;
    private double totalSum;
    private long totalCount;
    private double smoothedSum;
    private double smoothedSqr;
    private double smoothedCount;
    private double smoothedMin = Double.MAX_VALUE;
    private double smoothedMax = -1.7976931348623157E308;
    private double absoluteMax = Double.MAX_VALUE;
    private double absoluteMin = -1.7976931348623157E308;
    private double smoothedRateCount;
    private double smoothedRateTime;
    private double smoothingWindow;
    private double smoothingWindowCoef;
    @Nullable
    JmxHistogram histogram;
    private int addedStats;
    @Nullable
    private String unit;
    @Nullable
    private String rateUnit;
    private boolean useAvgAndDeviaton = true;
    private boolean useMinMax = true;
    private boolean useLastValue = true;
    private boolean useAbsoluteValues;
    private int precision = 1000;

    private ValueStats(double smoothingWindow) {
        this.smoothingWindow = smoothingWindow;
        this.smoothingWindowCoef = ValueStats.calculateSmoothingWindowCoef(smoothingWindow);
        this.resetStats();
    }

    private ValueStats() {
        this.smoothingWindow = -1.0;
        this.smoothingWindowCoef = -1.0;
    }

    public static ValueStats createAccumulator() {
        return new ValueStats();
    }

    public static ValueStats create(Duration smoothingWindow) {
        return new ValueStats((double)smoothingWindow.toMillis() / 1000.0);
    }

    public ValueStats withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public ValueStats withRate(String rateUnit) {
        this.rateUnit = rateUnit;
        return this;
    }

    public ValueStats withRate() {
        this.rateUnit = "";
        return this;
    }

    public ValueStats withHistogram(JmxHistogram histogram) {
        this.histogram = histogram;
        return this;
    }

    public ValueStats withHistogram(int[] histogram) {
        this.setHistogram(histogram);
        return this;
    }

    public ValueStats withAbsoluteValues(boolean value) {
        this.useAbsoluteValues = value;
        return this;
    }

    public ValueStats withAverageAndDeviation(boolean value) {
        this.useAvgAndDeviaton = value;
        return this;
    }

    public ValueStats withMinMax(boolean value) {
        this.useMinMax = value;
        return this;
    }

    public ValueStats withLastValue(boolean value) {
        this.useLastValue = value;
        return this;
    }

    public ValueStats withPrecision(int precision) {
        Checks.checkArgument((precision > 0 ? 1 : 0) != 0, (Object)"Precision should be a positive value");
        this.precision = precision;
        return this;
    }

    public ValueStats withScientificNotation() {
        this.precision = -1;
        return this;
    }

    public void setHistogram(@Nullable JmxHistogram histogram) {
        this.histogram = histogram;
    }

    public void setHistogram(int[] levels) {
        this.histogram = JmxHistogram.ofLevels(levels);
    }

    @Override
    public void resetStats() {
        this.smoothedSum = 0.0;
        this.smoothedSqr = 0.0;
        this.smoothedCount = 0.0;
        this.smoothedMin = Double.MAX_VALUE;
        this.smoothedMax = -1.7976931348623157E308;
        this.smoothedRateCount = 0.0;
        this.smoothedRateTime = 0.0;
        this.totalSum = 0.0;
        this.totalCount = 0L;
        this.absoluteMin = Double.MAX_VALUE;
        this.absoluteMax = -1.7976931348623157E308;
        this.lastMaxInteger = Integer.MIN_VALUE;
        this.lastMinInteger = Integer.MAX_VALUE;
        this.lastSumInteger = 0;
        this.lastSqrInteger = 0;
        this.lastCountInteger = 0;
        this.lastValueInteger = 0;
        this.lastMaxDouble = -1.7976931348623157E308;
        this.lastMinDouble = Double.MAX_VALUE;
        this.lastSumDouble = 0.0;
        this.lastSqrDouble = 0.0;
        this.lastCountDouble = 0;
        this.lastValueDouble = 0.0;
        this.lastTimestampMillis = 0L;
        if (this.histogram != null) {
            this.histogram.reset();
        }
    }

    public void recordValue(int value) {
        this.lastValueInteger = value;
        if (value < this.lastMinInteger) {
            this.lastMinInteger = value;
        }
        if (value > this.lastMaxInteger) {
            this.lastMaxInteger = value;
        }
        this.lastSumInteger += value;
        this.lastSqrInteger += value * value;
        ++this.lastCountInteger;
        if (this.histogram != null) {
            this.histogram.record(value);
        }
    }

    public void recordValue(double value) {
        this.lastValueDouble = value;
        if (value < this.lastMinDouble) {
            this.lastMinDouble = value;
        }
        if (value > this.lastMaxDouble) {
            this.lastMaxDouble = value;
        }
        this.lastSumDouble += value;
        this.lastSqrDouble += value * value;
        ++this.lastCountDouble;
    }

    public void refresh(long timestamp) {
        long timeElapsedMillis;
        double lastSum = 0.0;
        double lastSqr = 0.0;
        long lastCount = 0L;
        double lastMin = Double.MAX_VALUE;
        double lastMax = -1.7976931348623157E308;
        if (this.lastCountInteger > 0) {
            lastSum += (double)this.lastSumInteger;
            lastSqr += (double)this.lastSqrInteger;
            lastCount += (long)this.lastCountInteger;
            lastMin = this.lastMinInteger;
            lastMax = this.lastMaxInteger;
            this.lastSumInteger = 0;
            this.lastSqrInteger = 0;
            this.lastCountInteger = 0;
            this.lastMinInteger = Integer.MAX_VALUE;
            this.lastMaxInteger = Integer.MIN_VALUE;
        }
        if (this.lastCountDouble > 0) {
            lastSum += this.lastSumDouble;
            lastSqr += this.lastSqrDouble;
            lastCount += (long)this.lastCountDouble;
            lastMin = Math.min(lastMin, this.lastMinDouble);
            lastMax = Math.max(lastMax, this.lastMaxDouble);
            this.lastSumDouble = 0.0;
            this.lastSqrDouble = 0.0;
            this.lastCountDouble = 0;
            this.lastMinDouble = Double.MAX_VALUE;
            this.lastMaxDouble = -1.7976931348623157E308;
        }
        long l = timeElapsedMillis = this.lastTimestampMillis == 0L ? 0L : timestamp - this.lastTimestampMillis;
        if (ValueStats.isTimePeriodValid(timeElapsedMillis)) {
            double timeElapsed = (double)timeElapsedMillis * 0.001;
            double smoothingFactor = Math.exp(timeElapsed * this.smoothingWindowCoef);
            if (lastCount != 0L) {
                this.smoothedSum = lastSum + this.smoothedSum * smoothingFactor;
                this.smoothedSqr = lastSqr + this.smoothedSqr * smoothingFactor;
                this.smoothedCount = (double)lastCount + this.smoothedCount * smoothingFactor;
                this.totalSum += lastSum;
                this.totalCount += lastCount;
                double smoothedAvg = this.smoothedSum / this.smoothedCount;
                this.smoothedMin = lastMin < this.smoothedMin ? lastMin : smoothedAvg + (this.smoothedMin - smoothedAvg) * smoothingFactor;
                this.smoothedMax = lastMax > this.smoothedMax ? lastMax : smoothedAvg + (this.smoothedMax - smoothedAvg) * smoothingFactor;
                this.absoluteMin = Math.min(this.absoluteMin, lastMin);
                this.absoluteMax = Math.max(this.absoluteMax, lastMax);
            }
            this.smoothedRateCount = (double)lastCount + this.smoothedRateCount * smoothingFactor;
            this.smoothedRateTime = timeElapsed + this.smoothedRateTime * smoothingFactor;
        }
        this.lastTimestampMillis = timestamp;
    }

    private static boolean isTimePeriodValid(long timePeriod) {
        return timePeriod < MAX_INTERVAL_BETWEEN_REFRESHES && timePeriod >= 0L;
    }

    @Override
    public void add(ValueStats anotherStats) {
        if (anotherStats.lastTimestampMillis == 0L) {
            return;
        }
        this.smoothedSum += anotherStats.smoothedSum;
        this.smoothedSqr += anotherStats.smoothedSqr;
        this.smoothedCount += anotherStats.smoothedCount;
        this.smoothedRateCount += anotherStats.smoothedRateCount;
        this.smoothedRateTime += anotherStats.smoothedRateTime;
        this.totalSum += anotherStats.totalSum;
        this.totalCount += anotherStats.totalCount;
        this.smoothedMin = Math.min(this.smoothedMin, anotherStats.smoothedMin);
        this.smoothedMax = Math.max(this.smoothedMax, anotherStats.smoothedMax);
        if (anotherStats.lastTimestampMillis > this.lastTimestampMillis) {
            this.lastTimestampMillis = anotherStats.lastTimestampMillis;
            this.lastValueInteger = anotherStats.lastValueInteger;
            this.lastValueDouble = anotherStats.lastValueDouble;
        }
        if (this.addedStats == 0) {
            this.smoothingWindow = anotherStats.smoothingWindow;
            this.smoothingWindowCoef = anotherStats.smoothingWindowCoef;
        } else if (this.smoothingWindow != anotherStats.smoothingWindow) {
            this.smoothingWindow = -1.0;
            this.smoothingWindowCoef = ValueStats.calculateSmoothingWindowCoef(this.smoothingWindow);
        }
        if (anotherStats.histogram != null) {
            if (this.histogram == null) {
                this.histogram = anotherStats.histogram.createAccumulator();
            }
            this.histogram.add(anotherStats.histogram);
        }
        ++this.addedStats;
    }

    private static double calculateSmoothingWindowCoef(double smoothingWindow) {
        return -(LN_2 / smoothingWindow);
    }

    @JmxAttribute(optional=true)
    public double getLastValue() {
        return this.lastCountInteger > this.lastCountDouble ? (double)this.lastValueInteger : this.lastValueDouble;
    }

    @JmxAttribute(optional=true)
    public double getSmoothedAverage() {
        if (this.totalCount == 0L) {
            return 0.0;
        }
        return this.smoothedSum / this.smoothedCount;
    }

    @JmxAttribute(optional=true)
    public double getSmoothedStandardDeviation() {
        if (this.totalCount == 0L) {
            return 0.0;
        }
        double avg = this.smoothedSum / this.smoothedCount;
        double variance = this.smoothedSqr / this.smoothedCount - avg * avg;
        if (variance < 0.0) {
            variance = 0.0;
        }
        return Math.sqrt(variance);
    }

    @JmxAttribute(name="min", optional=true)
    public double getSmoothedMin() {
        return this.totalCount == 0L ? 0.0 : this.smoothedMin;
    }

    @JmxAttribute(name="max", optional=true)
    public double getSmoothedMax() {
        return this.totalCount == 0L ? 0.0 : this.smoothedMax;
    }

    @JmxAttribute(name="absoluteMin", optional=true)
    public double getAbsosuteMin() {
        return this.totalCount == 0L ? 0.0 : this.absoluteMin;
    }

    @JmxAttribute(name="absoluteMax", optional=true)
    public double getAbsoluteMax() {
        return this.totalCount == 0L ? 0.0 : this.absoluteMax;
    }

    @JmxAttribute(optional=true)
    public double getAverage() {
        return this.totalCount != 0L ? this.totalSum / (double)this.totalCount : 0.0;
    }

    @JmxAttribute(optional=true)
    public double getSmoothedRate() {
        return this.totalCount != 0L ? this.smoothedRateCount / this.smoothedRateTime * (double)Math.max(1, this.addedStats) : 0.0;
    }

    @Override
    @JmxAttribute(optional=true)
    public Duration getSmoothingWindow() {
        return Duration.ofMillis((long)(this.smoothingWindow * 1000.0));
    }

    @Override
    @JmxAttribute(optional=true)
    public void setSmoothingWindow(Duration smoothingWindow) {
        this.smoothingWindow = (double)smoothingWindow.toMillis() / 1000.0;
        this.smoothingWindowCoef = ValueStats.calculateSmoothingWindowCoef(this.smoothingWindow);
    }

    @JmxAttribute(optional=true)
    public long getCount() {
        return this.totalCount + (long)this.lastCountInteger + (long)this.lastCountDouble;
    }

    @JmxAttribute(optional=true)
    @Nullable
    public List<String> getHistogram() {
        if (this.histogram == null) {
            return null;
        }
        int[] levels = this.histogram.levels();
        long[] counts = this.histogram.counts();
        assert (counts.length == levels.length + 1);
        if (Arrays.stream(counts).noneMatch(value -> value != 0L)) {
            return null;
        }
        int left = IntStream.range(0, counts.length).filter(i -> i > 0 && levels[i - 1] == 0 || counts[i] != 0L).findFirst().getAsInt();
        int right = IntStream.iterate(levels.length, i -> i - 1).filter(i -> counts[i] != 0L).findFirst().getAsInt();
        int maxLevelStrLen = Math.max(Math.max(NEG_INF.length(), POS_INF.length()), IntStream.range(left, right).map(i -> Integer.toString(levels[i]).length()).max().orElse(0));
        int maxValueStrLen = IntStream.rangeClosed(left, right).map(i -> Long.toString(counts[i]).length()).max().orElse(0);
        return IntStream.rangeClosed(left, right).mapToObj(i -> String.format("%c%" + maxLevelStrLen + "s, %" + maxLevelStrLen + "s%c  :  %" + maxValueStrLen + "s", Character.valueOf(i == 0 ? (char)'(' : (char)'['), i == 0 ? NEG_INF : Integer.valueOf(levels[i - 1]), i == levels.length ? POS_INF : Integer.valueOf(levels[i]), Character.valueOf(')'), counts[i])).collect(Collectors.toList());
    }

    @JmxAttribute
    public String get() {
        return this.toString();
    }

    public String toString() {
        DecimalFormat decimalFormat;
        if (this.totalCount == 0L) {
            return "";
        }
        double min = this.smoothedMin;
        double max = this.smoothedMax;
        if (this.useAbsoluteValues) {
            min = this.absoluteMin;
            max = this.absoluteMax;
        }
        if (this.precision == -1) {
            decimalFormat = new DecimalFormat("0.0####E0#", DECIMAL_FORMAT_SYMBOLS);
        } else {
            decimalFormat = new DecimalFormat("0", DECIMAL_FORMAT_SYMBOLS);
            decimalFormat.setMaximumFractionDigits((int)Math.ceil(Math.min(Math.max(-Math.log10((max - min) / (double)this.precision), 0.0), 6.0)));
        }
        StringBuilder constructorTemplate = new StringBuilder();
        if (this.useAvgAndDeviaton) {
            constructorTemplate.append(decimalFormat.format(this.getSmoothedAverage())).append('\u00b1').append(decimalFormat.format(this.getSmoothedStandardDeviation())).append(' ');
            if (this.unit != null) {
                constructorTemplate.append(this.unit).append("  ");
            } else {
                constructorTemplate.append(' ');
            }
        }
        if (this.useMinMax) {
            constructorTemplate.append('[').append(decimalFormat.format(min)).append("...").append(decimalFormat.format(max)).append("]  ");
        }
        if (this.useLastValue) {
            constructorTemplate.append("last: ").append(decimalFormat.format(this.getLastValue())).append("  ");
        }
        if (this.rateUnit != null) {
            constructorTemplate.append("calls: ").append(EventStats.format(this.totalCount, this.getSmoothedRate(), this.rateUnit, decimalFormat)).append("  ");
        }
        if (this.addedStats != 0) {
            constructorTemplate.append('[').append(this.addedStats).append(']');
        }
        return constructorTemplate.toString().trim();
    }
}

