/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.stats;

import io.activej.common.Checks;
import io.activej.jmx.stats.JmxHistograms;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public interface JmxHistogram {
    public static final int[] POWERS_OF_TWO = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};
    public static final int[] POWERS_OF_TEN = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public static final int[] POWERS_OF_TEN_LINEAR = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000, 1000000, 2000000, 3000000, 4000000, 5000000, 6000000, 7000000, 8000000, 9000000, 10000000, 20000000, 30000000, 40000000, 50000000, 60000000, 70000000, 80000000, 90000000, 100000000, 200000000, 300000000, 400000000, 500000000, 600000000, 700000000, 800000000, 900000000, 1000000000, 2000000000};

    public static JmxHistogram ofLevels(int[] levels) {
        Checks.checkArgument((levels.length > 0 ? 1 : 0) != 0, (Object)"levels amount must be at least 1");
        for (int i = 1; i < levels.length; ++i) {
            Checks.checkArgument((levels[i] > levels[i - 1] ? 1 : 0) != 0, (Object)"levels must be ascending");
        }
        if (Arrays.equals(POWERS_OF_TWO, levels)) {
            return new JmxHistograms.Base2();
        }
        if (Arrays.equals(POWERS_OF_TEN, levels)) {
            return new JmxHistograms.Base10();
        }
        if (Arrays.equals(POWERS_OF_TEN_LINEAR, levels)) {
            return new JmxHistograms.Base10Linear();
        }
        return new JmxHistograms.Custom(levels);
    }

    public int[] levels();

    public long[] counts();

    public void record(int var1);

    public void reset();

    public JmxHistogram createAccumulator();

    public void add(@NotNull JmxHistogram var1);
}

