/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.stats;

import io.activej.common.Checks;
import io.activej.jmx.stats.JmxHistogram;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class JmxHistograms {
    private static final int[] TABLE_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    static int integerLogBase10(int v) {
        int t;
        return t - (v < TABLE_10[t = (32 - Integer.numberOfLeadingZeros(v)) * 1233 >>> 12] ? 1 : 0);
    }

    public static final class Custom
    extends AbstractJmxHistogram {
        public Custom(int[] levels) {
            super(levels);
        }

        @Override
        public JmxHistogram createAccumulator() {
            return new Custom(this.levels);
        }

        @Override
        public void record(int value) {
            int n = Math.abs(Arrays.binarySearch(this.levels, value) + 1);
            this.counters[n] = this.counters[n] + 1L;
        }

        @Override
        protected long getResult(int index) {
            return this.counters[index];
        }
    }

    public static final class Base10Linear
    extends AbstractJmxHistogram {
        public Base10Linear() {
            super(POWERS_OF_TEN_LINEAR);
        }

        @Override
        public JmxHistogram createAccumulator() {
            return new Base10Linear();
        }

        @Override
        public void record(int value) {
            if (value == 0) {
                this.counters[1] = this.counters[1] + 1L;
            } else if (value > 0) {
                int index = (32 - Integer.numberOfLeadingZeros(value)) * 1233 >>> 12;
                int power = TABLE_10[index];
                if (value < power) {
                    power = TABLE_10[--index];
                }
                int subindex = value / power;
                int n = index * 9 + subindex + 1;
                this.counters[n] = this.counters[n] + 1L;
            } else {
                this.counters[0] = this.counters[0] + 1L;
            }
        }

        @Override
        protected long getResult(int index) {
            return this.counters[index];
        }
    }

    public static class Base10
    extends AbstractJmxHistogram {
        public Base10() {
            super(POWERS_OF_TEN);
        }

        @Override
        public JmxHistogram createAccumulator() {
            return new Base10();
        }

        @Override
        public void record(int value) {
            if (value >= 0) {
                int n = JmxHistograms.integerLogBase10(value) + 2;
                this.counters[n] = this.counters[n] + 1L;
            } else {
                this.counters[0] = this.counters[0] + 1L;
            }
        }

        @Override
        protected long getResult(int index) {
            return this.counters[index];
        }
    }

    public static final class Base2
    extends AbstractJmxHistogram {
        public Base2() {
            super(POWERS_OF_TWO);
        }

        @Override
        public JmxHistogram createAccumulator() {
            return new Base2();
        }

        @Override
        public void record(int value) {
            int n = 32 - Integer.numberOfLeadingZeros(value);
            this.counters[n] = this.counters[n] + 1L;
        }

        @Override
        protected long getResult(int index) {
            return this.counters[(index + 33 - 1) % 33];
        }
    }

    public static abstract class AbstractJmxHistogram
    implements JmxHistogram {
        protected final long[] counters;
        protected final int[] levels;

        protected AbstractJmxHistogram(int[] levels) {
            this.counters = new long[levels.length + 1];
            this.levels = levels;
        }

        protected AbstractJmxHistogram(int[] levels, int counters) {
            this.counters = new long[counters];
            this.levels = levels;
        }

        @Override
        public int[] levels() {
            return this.levels;
        }

        @Override
        public long[] counts() {
            long[] result = new long[this.levels.length + 1];
            for (int i = 0; i <= this.levels.length; ++i) {
                result[i] = this.getResult(i);
            }
            return result;
        }

        protected abstract long getResult(int var1);

        @Override
        public void reset() {
            Arrays.fill(this.counters, 0L);
        }

        @Override
        public void add(@NotNull JmxHistogram another) {
            AbstractJmxHistogram anotherImpl = (AbstractJmxHistogram)another;
            Checks.checkArgument((Arrays.equals(anotherImpl.levels, this.levels) && anotherImpl.counters.length == this.counters.length ? 1 : 0) != 0, (Object)"Histograms mismatch");
            for (int i = 0; i < this.counters.length; ++i) {
                int n = i;
                this.counters[n] = this.counters[n] + anotherImpl.counters[i];
            }
        }
    }
}

