/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.common.Checks;
import io.activej.common.Utils;
import io.activej.jmx.AttributeModifier;
import io.activej.jmx.AttributeNode;
import io.activej.jmx.ValueFetcher;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractAttributeNodeForLeaf
implements AttributeNode {
    protected final String name;
    private final String description;
    protected final ValueFetcher fetcher;
    private boolean visible;

    protected AbstractAttributeNodeForLeaf(String name, @Nullable String description, ValueFetcher fetcher, boolean visible) {
        this.name = name;
        this.description = description;
        this.fetcher = fetcher;
        this.visible = visible;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Set<String> getAllAttributes() {
        return Collections.singleton(this.name);
    }

    @Override
    public final Set<String> getVisibleAttributes() {
        return this.visible ? Collections.singleton(this.name) : Collections.emptySet();
    }

    @Override
    public final Map<String, Map<String, String>> getDescriptions() {
        if (this.description != null) {
            return Collections.singletonMap(this.name, Collections.singletonMap(this.name, this.description));
        }
        return Collections.singletonMap(this.name, Collections.emptyMap());
    }

    @Override
    public final Map<String, Object> aggregateAttributes(@NotNull Set<String> attrNames, @NotNull List<?> sources) {
        Checks.checkArgument((attrNames.size() == 1 ? 1 : 0) != 0);
        String attrName = (String)Utils.first(attrNames);
        Checks.checkArgument((boolean)this.name.equals(attrName));
        if (sources.isEmpty()) {
            return Collections.singletonMap(attrName, null);
        }
        return Collections.singletonMap(this.name, this.aggregateAttribute(attrName, sources));
    }

    protected abstract Object aggregateAttribute(String var1, List<?> var2);

    @Override
    public final boolean isVisible() {
        return this.visible;
    }

    @Override
    public final void setVisible(@NotNull String attrName) {
        Checks.checkArgument((boolean)this.name.equals(attrName));
        this.visible = true;
    }

    @Override
    public final void hideNullPojos(@NotNull List<?> sources) {
    }

    @Override
    public final void applyModifier(@NotNull String attrName, @NotNull AttributeModifier<?> modifier, @NotNull List<?> target) {
        Checks.checkArgument((boolean)this.name.equals(attrName));
        throw new UnsupportedOperationException(String.format("AttributeModifier can be applied only to POJO. Attribute \"%s\" is not a POJO.", attrName));
    }
}

