/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.common.Checks;
import io.activej.common.Utils;
import io.activej.jmx.AbstractAttributeNodeForLeaf;
import io.activej.jmx.AttributeNode;
import io.activej.jmx.ValueFetcher;
import io.activej.jmx.api.JmxRefreshable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AttributeNodeForList
extends AbstractAttributeNodeForLeaf {
    private final AttributeNode subNode;
    private final ArrayType<?> arrayType;
    private final boolean isListOfJmxRefreshables;

    public AttributeNodeForList(String name, @Nullable String description, boolean visible, ValueFetcher fetcher, AttributeNode subNode, boolean isListOfJmxRefreshables) {
        super(name, description, fetcher, visible);
        Checks.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"List attribute cannot have empty name");
        this.subNode = subNode;
        this.arrayType = AttributeNodeForList.createArrayType(subNode, name);
        this.isListOfJmxRefreshables = isListOfJmxRefreshables;
    }

    private static ArrayType<?> createArrayType(AttributeNode subNode, String name) {
        String nodeName = "Attribute name = " + name;
        Set<String> visibleAttrs = subNode.getVisibleAttributes();
        Map<String, OpenType<?>> attrTypes = subNode.getOpenTypes();
        if (visibleAttrs.isEmpty()) {
            throw new IllegalArgumentException("Arrays must have at least one visible attribute. " + nodeName);
        }
        try {
            CompositeType elementType;
            if (visibleAttrs.size() == 1) {
                String attr = (String)Utils.first(visibleAttrs);
                CompositeType openType = attrTypes.get(attr);
                if (openType instanceof ArrayType) {
                    throw new IllegalArgumentException("Multidimensional arrays are note supported in JMX. " + nodeName);
                }
                elementType = openType;
            } else {
                ArrayList<String> itemNames = new ArrayList<String>();
                ArrayList itemTypes = new ArrayList();
                for (String visibleAttr : visibleAttrs) {
                    OpenType<?> visibleAttrType = attrTypes.get(visibleAttr);
                    itemNames.add(visibleAttr);
                    itemTypes.add(visibleAttrType);
                }
                String[] itemNamesArr = itemNames.toArray(new String[0]);
                OpenType[] itemTypesArr = itemTypes.toArray(new OpenType[0]);
                elementType = new CompositeType("CompositeData", "CompositeData", itemNamesArr, itemNamesArr, itemTypesArr);
            }
            return new ArrayType(1, elementType);
        }
        catch (OpenDataException e) {
            throw new IllegalArgumentException("Cannot create ArrayType. " + nodeName, e);
        }
    }

    @Override
    public Map<String, OpenType<?>> getOpenTypes() {
        return Collections.singletonMap(this.name, this.arrayType);
    }

    @Override
    @Nullable
    public Object aggregateAttribute(String attrName, List<?> sources) {
        ArrayList<Map<String, Object>> attributesFromAllElements = new ArrayList<Map<String, Object>>();
        Set<String> visibleSubAttrs = this.subNode.getVisibleAttributes();
        for (Object source : sources) {
            List currentList = (List)this.fetcher.fetchFrom(source);
            if (currentList == null) continue;
            ArrayList list = new ArrayList(currentList);
            for (Object element : list) {
                Map<String, Object> attributesFromElement = this.subNode.aggregateAttributes(visibleSubAttrs, Collections.singletonList(element));
                attributesFromAllElements.add(attributesFromElement);
            }
        }
        return attributesFromAllElements.isEmpty() ? null : this.createArrayFrom(attributesFromAllElements);
    }

    private Object[] createArrayFrom(List<Map<String, Object>> attributesFromAllElements) {
        OpenType<?> arrayElementOpenType = this.arrayType.getElementOpenType();
        if (arrayElementOpenType instanceof ArrayType) {
            throw new RuntimeException("Multidimensional arrays are not supported");
        }
        try {
            Class<?> elementClass = AttributeNodeForList.classOf(this.arrayType.getElementOpenType());
            Object[] array = (Object[])Array.newInstance(elementClass, attributesFromAllElements.size());
            for (int i = 0; i < attributesFromAllElements.size(); ++i) {
                Map<String, Object> attributesFromElement = attributesFromAllElements.get(i);
                array[i] = AttributeNodeForList.jmxCompatibleObjectOf(arrayElementOpenType, attributesFromElement);
            }
            return array;
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object jmxCompatibleObjectOf(OpenType<?> openType, Map<String, Object> attributes) throws OpenDataException {
        if (openType instanceof SimpleType || openType instanceof TabularType) {
            Checks.checkArgument((attributes.size() == 1 ? 1 : 0) != 0, (Object)"Only one attribute should be present");
            return Utils.first(attributes.values());
        }
        if (openType instanceof CompositeType) {
            CompositeType compositeType = (CompositeType)openType;
            return new CompositeDataSupport(compositeType, attributes);
        }
        throw new RuntimeException("There is no support for " + openType);
    }

    @Override
    public List<JmxRefreshable> getAllRefreshables(@NotNull Object source) {
        if (!this.isListOfJmxRefreshables) {
            return Collections.emptyList();
        }
        List listRef = (List)this.fetcher.fetchFrom(source);
        return Collections.singletonList(timestamp -> {
            for (JmxRefreshable jmxRefreshableElement : listRef) {
                jmxRefreshableElement.refresh(timestamp);
            }
        });
    }

    @Override
    public boolean isSettable(@NotNull String attrName) {
        return false;
    }

    @Override
    public void setAttribute(@NotNull String attrName, @NotNull Object value, @NotNull List<?> targets) {
        throw new UnsupportedOperationException("Cannot set attributes for list attribute node");
    }

    private static Class<?> classOf(OpenType<?> openType) {
        if (openType.equals(SimpleType.BOOLEAN)) {
            return Boolean.class;
        }
        if (openType.equals(SimpleType.BYTE)) {
            return Byte.class;
        }
        if (openType.equals(SimpleType.SHORT)) {
            return Short.class;
        }
        if (openType.equals(SimpleType.CHARACTER)) {
            return Character.class;
        }
        if (openType.equals(SimpleType.INTEGER)) {
            return Integer.class;
        }
        if (openType.equals(SimpleType.LONG)) {
            return Long.class;
        }
        if (openType.equals(SimpleType.FLOAT)) {
            return Float.class;
        }
        if (openType.equals(SimpleType.DOUBLE)) {
            return Double.class;
        }
        if (openType.equals(SimpleType.STRING)) {
            return String.class;
        }
        if (openType instanceof CompositeType) {
            return CompositeData.class;
        }
        if (openType instanceof TabularType) {
            return TabularData.class;
        }
        throw new IllegalArgumentException(String.format("OpenType \"%s\" cannot be converted to Class", openType));
    }
}

