/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.common.Checks;
import io.activej.common.Utils;
import io.activej.jmx.AbstractAttributeNodeForLeaf;
import io.activej.jmx.AttributeNode;
import io.activej.jmx.ValueFetcher;
import io.activej.jmx.api.JmxRefreshable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AttributeNodeForMap
extends AbstractAttributeNodeForLeaf {
    private static final String KEY_COLUMN_NAME = "> key";
    private static final String VALUE_COLUMN_NAME = "value";
    private static final String EMPTY_COLUMN_NAME = "default";
    private static final String ROW_TYPE_NAME = "RowType";
    private static final String TABULAR_TYPE_NAME = "TabularType";
    private final AttributeNode subNode;
    private final TabularType tabularType;
    private final boolean isMapOfJmxRefreshable;

    public AttributeNodeForMap(String name, @Nullable String description, boolean visible, ValueFetcher fetcher, AttributeNode subNode, boolean isMapOfJmxRefreshable) {
        super(name, description, fetcher, visible);
        Checks.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Map attribute cannot have empty name");
        this.tabularType = AttributeNodeForMap.createTabularType(subNode, name);
        this.subNode = subNode;
        this.isMapOfJmxRefreshable = isMapOfJmxRefreshable;
    }

    private static TabularType createTabularType(AttributeNode subNode, String name) {
        String nodeName = "Attribute name = " + name;
        Set<String> visibleAttrs = subNode.getVisibleAttributes();
        Map<String, OpenType<?>> attrTypes = subNode.getOpenTypes();
        if (visibleAttrs.isEmpty()) {
            throw new IllegalArgumentException("Arrays must have at least one visible attribute. " + nodeName);
        }
        HashMap<Object, Object> attrNameToType = new HashMap<Object, Object>();
        attrNameToType.put(KEY_COLUMN_NAME, SimpleType.STRING);
        if (visibleAttrs.size() == 1) {
            String attrName = (String)Utils.first(visibleAttrs);
            OpenType<?> attrType = attrTypes.get(attrName);
            Object adjustedAttrName = attrName.isEmpty() ? VALUE_COLUMN_NAME : attrName;
            attrNameToType.put(adjustedAttrName, attrType);
        } else {
            for (String attrName : visibleAttrs) {
                String string;
                OpenType<?> attrType = attrTypes.get(attrName);
                String string2 = string = attrName.isEmpty() ? EMPTY_COLUMN_NAME : attrName;
                if (attrNameToType.containsKey(string)) {
                    throw new IllegalArgumentException("In case of empty attribute name there must not be another empty attribute and attribute with name \"default\"." + nodeName);
                }
                attrNameToType.put(attrName, attrType);
            }
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<OpenType> columnTypes = new ArrayList<OpenType>();
        for (Map.Entry entry : attrNameToType.entrySet()) {
            columnNames.add((String)entry.getKey());
            columnTypes.add((OpenType)entry.getValue());
        }
        String[] columnNamesArr = columnNames.toArray(new String[0]);
        OpenType[] openTypeArray = columnTypes.toArray(new OpenType[0]);
        try {
            return new TabularType(TABULAR_TYPE_NAME, TABULAR_TYPE_NAME, new CompositeType(ROW_TYPE_NAME, ROW_TYPE_NAME, columnNamesArr, columnNamesArr, openTypeArray), new String[]{KEY_COLUMN_NAME});
        }
        catch (OpenDataException e) {
            throw new IllegalArgumentException("Cannot create TabularType. " + nodeName, e);
        }
    }

    @Override
    public Map<String, OpenType<?>> getOpenTypes() {
        return Collections.singletonMap(this.name, this.tabularType);
    }

    @Override
    @Nullable
    public Object aggregateAttribute(String attrName, List<?> sources) {
        Map<Object, List<Object>> groupedByKey = this.fetchMapsAndGroupEntriesByKey(sources);
        if (groupedByKey.size() == 0) {
            return null;
        }
        TabularDataSupport tdSupport = new TabularDataSupport(this.tabularType);
        Set<String> visibleSubAttrs = this.subNode.getVisibleAttributes();
        for (Map.Entry<Object, List<Object>> entry : groupedByKey.entrySet()) {
            Map<String, Object> aggregatedGroup = this.subNode.aggregateAttributes(visibleSubAttrs, entry.getValue());
            try {
                tdSupport.put(this.createTabularDataRow(entry.getKey().toString(), aggregatedGroup));
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }
        return tdSupport.size() > 0 ? tdSupport : null;
    }

    private CompositeData createTabularDataRow(String key, Map<String, Object> attributes) throws OpenDataException {
        HashMap<String, Object> allAttributes = new HashMap<String, Object>(attributes.size() + 1);
        if (attributes.size() == 1) {
            String attrName = (String)Utils.first(attributes.keySet());
            Object attrValue = attributes.get(attrName);
            String valueColumnName = attrName.isEmpty() ? VALUE_COLUMN_NAME : attrName;
            allAttributes.put(valueColumnName, attrValue);
        } else {
            if (attributes.containsKey("")) {
                Object emptyColumnValue = attributes.get("");
                attributes.remove("");
                attributes.put(EMPTY_COLUMN_NAME, emptyColumnValue);
            }
            allAttributes.putAll(attributes);
        }
        allAttributes.put(KEY_COLUMN_NAME, key);
        return new CompositeDataSupport(this.tabularType.getRowType(), allAttributes);
    }

    private Map<Object, List<Object>> fetchMapsAndGroupEntriesByKey(List<?> pojos) {
        ArrayList listOfMaps = new ArrayList();
        for (Object pojo : pojos) {
            Map map2 = (Map)this.fetcher.fetchFrom(pojo);
            if (map2 == null || map2.size() <= 0) continue;
            listOfMaps.add(new HashMap(map2));
        }
        return listOfMaps.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(e -> e.getValue(), Collectors.toList())));
    }

    @Override
    public List<JmxRefreshable> getAllRefreshables(@NotNull Object source) {
        if (!this.isMapOfJmxRefreshable) {
            return Collections.emptyList();
        }
        Map mapRef = (Map)this.fetcher.fetchFrom(source);
        return Collections.singletonList(timestamp -> {
            for (JmxRefreshable jmxRefreshableValue : mapRef.values()) {
                jmxRefreshableValue.refresh(timestamp);
            }
        });
    }

    @Override
    public boolean isSettable(@NotNull String attrName) {
        return false;
    }

    @Override
    public void setAttribute(@NotNull String attrName, @NotNull Object value, @NotNull List<?> targets) {
        throw new UnsupportedOperationException("Cannot set attributes for map attribute node");
    }
}

