/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.bytebuf.ByteBufPool;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.StringFormatUtils;
import io.activej.common.initializer.Initializer;
import io.activej.common.initializer.WithInitializer;
import io.activej.inject.Injector;
import io.activej.inject.Key;
import io.activej.inject.annotation.Provides;
import io.activej.inject.annotation.ProvidesIntoSet;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingType;
import io.activej.inject.binding.OptionalDependency;
import io.activej.inject.module.AbstractModule;
import io.activej.jmx.AttributeModifier;
import io.activej.jmx.DynamicMBeanFactory;
import io.activej.jmx.JmxBeanSettings;
import io.activej.jmx.JmxRegistry;
import io.activej.jmx.ProtoObjectNameMapper;
import io.activej.jmx.stats.JmxHistogram;
import io.activej.launcher.LauncherService;
import io.activej.trigger.Severity;
import io.activej.trigger.Triggers;
import io.activej.worker.WorkerPool;
import io.activej.worker.WorkerPools;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.management.DynamicMBean;
import org.jetbrains.annotations.Nullable;

public final class JmxModule
extends AbstractModule
implements WithInitializer<JmxModule> {
    public static final Duration REFRESH_PERIOD_DEFAULT = ApplicationSettings.getDuration(JmxModule.class, (String)"refreshPeriod", (Duration)Duration.ofSeconds(1L));
    public static final int MAX_JMX_REFRESHES_PER_ONE_CYCLE_DEFAULT = ApplicationSettings.getInt(JmxModule.class, (String)"maxJmxRefreshesPerOneCycle", (int)50);
    private final Set<Object> globalSingletons = new HashSet<Object>();
    private final Map<Key<?>, JmxBeanSettings> keyToSettings = new HashMap();
    private final Map<Type, JmxBeanSettings> typeToSettings = new HashMap<Type, JmxBeanSettings>();
    private final Map<Type, DynamicMBeanFactory.JmxCustomTypeAdapter<?>> customTypes = new HashMap();
    private final Map<Type, Key<?>> globalMBeans = new HashMap();
    private Duration refreshPeriod = REFRESH_PERIOD_DEFAULT;
    private int maxJmxRefreshesPerOneCycle = MAX_JMX_REFRESHES_PER_ONE_CYCLE_DEFAULT;
    private ProtoObjectNameMapper objectNameMapper = ProtoObjectNameMapper.identity();
    private BiPredicate<Key<?>, Integer> workerPredicate = (key, workerId) -> true;
    private boolean withScopes = true;

    private JmxModule() {
    }

    public static JmxModule create() {
        return new JmxModule().withCustomType(Duration.class, StringFormatUtils::formatDuration, StringFormatUtils::parseDuration).withCustomType(Period.class, StringFormatUtils::formatPeriod, StringFormatUtils::parsePeriod).withCustomType(Instant.class, StringFormatUtils::formatInstant, StringFormatUtils::parseInstant).withCustomType(LocalDateTime.class, StringFormatUtils::formatLocalDateTime, StringFormatUtils::parseLocalDateTime).withCustomType(MemSize.class, StringFormatUtils::formatMemSize, StringFormatUtils::parseMemSize).withCustomType(Triggers.TriggerWithResult.class, Triggers.TriggerWithResult::toString).withCustomType(Severity.class, Enum::toString).withGlobalSingletons(ByteBufPool.getStats());
    }

    public JmxModule withRefreshPeriod(Duration refreshPeriod) {
        Checks.checkArgument((refreshPeriod.toMillis() > 0L ? 1 : 0) != 0, (Object)"Duration of refresh period should be a positive value");
        this.refreshPeriod = refreshPeriod;
        return this;
    }

    public JmxModule withMaxJmxRefreshesPerOneCycle(int max) {
        Checks.checkArgument((max > 0 ? 1 : 0) != 0, (Object)"Number of JMX refreshes should be a positive value");
        this.maxJmxRefreshesPerOneCycle = max;
        return this;
    }

    public <T> JmxModule withModifier(Key<?> key, String attrName, AttributeModifier<T> modifier) {
        this.keyToSettings.computeIfAbsent(key, $ -> JmxBeanSettings.create()).withModifier(attrName, modifier);
        return this;
    }

    public <T> JmxModule withModifier(Type type, String attrName, AttributeModifier<T> modifier) {
        this.typeToSettings.computeIfAbsent(type, $ -> JmxBeanSettings.create()).withModifier(attrName, modifier);
        return this;
    }

    public JmxModule withOptional(Key<?> key, String attrName) {
        this.keyToSettings.computeIfAbsent(key, $ -> JmxBeanSettings.create()).withIncludedOptional(attrName);
        return this;
    }

    public JmxModule withOptional(Type type, String attrName) {
        this.typeToSettings.computeIfAbsent(type, $ -> JmxBeanSettings.create()).withIncludedOptional(attrName);
        return this;
    }

    public JmxModule withHistogram(Class<?> clazz, String attrName, int[] histogramLevels) {
        return this.withHistogram(Key.of(clazz), attrName, () -> JmxHistogram.ofLevels((int[])histogramLevels));
    }

    public JmxModule withHistogram(Key<?> key, String attrName, int[] histogramLevels) {
        return this.withHistogram(key, attrName, () -> JmxHistogram.ofLevels((int[])histogramLevels));
    }

    public JmxModule withHistogram(Class<?> clazz, String attrName, Supplier<JmxHistogram> histogram) {
        return this.withHistogram(Key.of(clazz), attrName, histogram);
    }

    public JmxModule withHistogram(Key<?> key, String attrName, Supplier<JmxHistogram> histogram) {
        return this.withOptional(key, attrName + "_histogram").withModifier(key, attrName, (T attribute) -> attribute.setHistogram((JmxHistogram)histogram.get()));
    }

    public JmxModule withGlobalMBean(Type type, String named) {
        return this.withGlobalMBean(type, Key.ofType((Type)type, (Object)named));
    }

    public JmxModule withGlobalMBean(Type type, Key<?> key) {
        Checks.checkArgument((key.getType() == type ? 1 : 0) != 0, (Object)("Type " + type + " does not match key type " + key.getType()));
        this.globalMBeans.put(type, key);
        return this;
    }

    public JmxModule withObjectNameMapping(ProtoObjectNameMapper objectNameMapper) {
        this.objectNameMapper = objectNameMapper;
        return this;
    }

    public JmxModule withScopes(boolean withScopes) {
        this.withScopes = withScopes;
        return this;
    }

    public <T> JmxModule withCustomType(Class<T> type, Function<T, String> to, Function<String, T> from) {
        this.customTypes.put(type, new DynamicMBeanFactory.JmxCustomTypeAdapter<T>(to, from));
        return this;
    }

    public <T> JmxModule withCustomType(Class<T> type, Function<T, String> to) {
        this.customTypes.put(type, new DynamicMBeanFactory.JmxCustomTypeAdapter<T>(to));
        return this;
    }

    public JmxModule withGlobalSingletons(Object ... instances) {
        Checks.checkArgument((boolean)Arrays.stream(instances).map(Object::getClass).noneMatch(Class::isAnonymousClass), (Object)"Instances of anonymous classes will not be registered in JMX");
        this.globalSingletons.addAll(Arrays.asList(instances));
        return this;
    }

    public JmxModule withWorkerPredicate(BiPredicate<Key<?>, Integer> predicate) {
        this.workerPredicate = predicate;
        return this;
    }

    @Provides
    JmxRegistry jmxRegistry(DynamicMBeanFactory mbeanFactory) {
        return JmxRegistry.create(ManagementFactory.getPlatformMBeanServer(), mbeanFactory, this.customTypes).withObjectNameMapping(this.objectNameMapper).withScopes(this.withScopes).withWorkerPredicate(this.workerPredicate);
    }

    @Provides
    DynamicMBeanFactory mbeanFactory() {
        return DynamicMBeanFactory.create(this.refreshPeriod, this.maxJmxRefreshesPerOneCycle);
    }

    @ProvidesIntoSet
    LauncherService service(final Injector injector, final JmxRegistry jmxRegistry, final DynamicMBeanFactory mbeanFactory, OptionalDependency<Set<Initializer<JmxModule>>> initializers) {
        for (Initializer initializer : (Set)initializers.orElse(Collections.emptySet())) {
            initializer.accept((Object)this);
        }
        return new LauncherService(){

            public CompletableFuture<?> start() {
                JmxModule.this.doStart(injector, jmxRegistry, mbeanFactory);
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> stop() {
                jmxRegistry.unregisterAll();
                return CompletableFuture.completedFuture(null);
            }
        };
    }

    private void doStart(Injector injector, JmxRegistry jmxRegistry, DynamicMBeanFactory mbeanFactory) {
        HashMap<Type, Set> globalMBeanObjects = new HashMap<Type, Set>();
        for (Object object : this.globalSingletons) {
            Key globalKey = Key.of(object.getClass());
            this.registerSingleton(jmxRegistry, object, globalKey, injector, JmxBeanSettings.create().withCustomTypes(this.customTypes));
        }
        for (Map.Entry entry2 : injector.peekInstances().entrySet()) {
            Key key = (Key)entry2.getKey();
            Object instance = entry2.getValue();
            if (instance == null || key.getRawType().isAnonymousClass()) continue;
            this.registerSingleton(jmxRegistry, instance, key, injector, null);
            Type type = key.getType();
            if (!this.globalMBeans.containsKey(type)) continue;
            globalMBeanObjects.computeIfAbsent(type, $ -> Collections.newSetFromMap(new IdentityHashMap())).add(instance);
        }
        WorkerPools workerPools = (WorkerPools)injector.peekInstance(WorkerPools.class);
        if (workerPools != null) {
            injector.peekInstances().entrySet().stream().filter(entry -> ((Key)entry.getKey()).getRawType().equals(WorkerPool.class)).forEach(entry -> jmxRegistry.addWorkerPoolKey((WorkerPool)entry.getValue(), (Key)entry.getKey()));
            for (WorkerPool workerPool : workerPools.getWorkerPools()) {
                Injector[] scopeInjectors = workerPool.getScopeInjectors();
                if (scopeInjectors.length == 0) continue;
                Injector workerScopeInjector = scopeInjectors[0];
                for (Map.Entry entry3 : workerPool.peekInstances().entrySet()) {
                    Key key = (Key)entry3.getKey();
                    WorkerPool.Instances workerInstances = (WorkerPool.Instances)entry3.getValue();
                    if (key.getRawType().isAnonymousClass()) continue;
                    this.registerWorkers(jmxRegistry, workerPool, key, workerInstances.getList(), workerScopeInjector);
                    Type type = key.getType();
                    if (!this.globalMBeans.containsKey(type)) continue;
                    for (Object instance : workerInstances) {
                        globalMBeanObjects.computeIfAbsent(type, $ -> Collections.newSetFromMap(new IdentityHashMap())).add(instance);
                    }
                }
            }
        }
        for (Map.Entry entry4 : globalMBeanObjects.entrySet()) {
            Key<?> key = this.globalMBeans.get(entry4.getKey());
            DynamicMBean globalMBean = mbeanFactory.createDynamicMBean(new ArrayList((Collection)entry4.getValue()), this.ensureSettingsFor(key), false);
            this.registerSingleton(jmxRegistry, globalMBean, key, injector, JmxBeanSettings.defaultSettings());
        }
    }

    private void registerSingleton(JmxRegistry jmxRegistry, Object instance, Key<?> key, Injector injector, @Nullable JmxBeanSettings settings) {
        if (key.getRawType() == OptionalDependency.class) {
            OptionalDependency optional = (OptionalDependency)instance;
            if (!optional.isPresent()) {
                return;
            }
            Binding binding = injector.getBinding(key);
            if (binding == null || binding.getType() == BindingType.SYNTHETIC) {
                return;
            }
            key = key.getTypeParameter(0).qualified(key.getQualifier());
            instance = optional.get();
        }
        jmxRegistry.registerSingleton(key, instance, settings != null ? settings : this.ensureSettingsFor(key));
    }

    private void registerWorkers(JmxRegistry jmxRegistry, WorkerPool workerPool, Key<?> key, List<?> workerInstances, Injector injector) {
        int size = workerInstances.size();
        if (size == 0) {
            return;
        }
        if (key.getRawType() == OptionalDependency.class) {
            Binding binding = injector.getBinding(key);
            if (binding == null || binding.getType() == BindingType.SYNTHETIC) {
                return;
            }
            ArrayList instances = new ArrayList(size);
            for (Object workerInstance : workerInstances) {
                OptionalDependency optional = (OptionalDependency)workerInstance;
                if (!optional.isPresent()) {
                    JmxRegistry.logger.info("Pool of instances with key {} was not registered to jmx, because some instances were not present", (Object)key);
                    return;
                }
                instances.add(optional.get());
            }
            key = key.getTypeParameter(0).qualified(key.getQualifier());
            workerInstances = instances;
        }
        jmxRegistry.registerWorkers(workerPool, key, workerInstances, this.ensureSettingsFor(key));
    }

    private JmxBeanSettings ensureSettingsFor(Key<?> key) {
        JmxBeanSettings settings = JmxBeanSettings.create().withCustomTypes(this.customTypes);
        if (this.keyToSettings.containsKey(key)) {
            settings.merge(this.keyToSettings.get(key));
        }
        if (this.typeToSettings.containsKey(key.getType())) {
            settings.merge(this.typeToSettings.get(key.getType()));
        }
        return settings;
    }
}

