/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.common.Checks;
import io.activej.common.StringFormatUtils;
import io.activej.common.initializer.WithInitializer;
import io.activej.common.reflection.ReflectionUtils;
import io.activej.inject.Key;
import io.activej.inject.Scope;
import io.activej.inject.module.UniqueQualifierImpl;
import io.activej.jmx.DynamicMBeanFactory;
import io.activej.jmx.JmxBeanSettings;
import io.activej.jmx.JmxRegistryMXBean;
import io.activej.jmx.ProtoObjectName;
import io.activej.jmx.ProtoObjectNameMapper;
import io.activej.jmx.Utils;
import io.activej.worker.WorkerPool;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxRegistry
implements JmxRegistryMXBean,
WithInitializer<JmxRegistry> {
    static final Logger logger = LoggerFactory.getLogger(JmxRegistry.class);
    private static final String GENERIC_PARAM_NAME_FORMAT = "T%d=%s";
    private final MBeanServer mbs;
    private final DynamicMBeanFactory mbeanFactory;
    private final Map<Type, DynamicMBeanFactory.JmxCustomTypeAdapter<?>> customTypes;
    private final Map<WorkerPool, Key<?>> workerPoolKeys = new HashMap();
    private final Set<ObjectName> registeredObjectNames = new HashSet<ObjectName>();
    private ProtoObjectNameMapper objectNameMapper = ProtoObjectNameMapper.identity();
    private BiPredicate<Key<?>, Integer> workerPredicate = (key, workerId) -> true;
    private boolean withScopes = true;
    private int registeredSingletons;
    private int registeredPools;
    private int totallyRegisteredMBeans;

    private JmxRegistry(@NotNull MBeanServer mbs, DynamicMBeanFactory mbeanFactory, Map<Type, DynamicMBeanFactory.JmxCustomTypeAdapter<?>> customTypes) {
        this.mbs = mbs;
        this.mbeanFactory = mbeanFactory;
        this.customTypes = customTypes;
    }

    public static JmxRegistry create(MBeanServer mbs, DynamicMBeanFactory mbeanFactory) {
        return new JmxRegistry(mbs, mbeanFactory, Collections.emptyMap());
    }

    public static JmxRegistry create(MBeanServer mbs, DynamicMBeanFactory mbeanFactory, Map<Type, DynamicMBeanFactory.JmxCustomTypeAdapter<?>> customTypes) {
        return new JmxRegistry(mbs, mbeanFactory, customTypes);
    }

    public JmxRegistry withScopes(boolean withScopes) {
        this.withScopes = withScopes;
        return this;
    }

    public JmxRegistry withObjectNameMapping(ProtoObjectNameMapper objectNameMapper) {
        this.objectNameMapper = objectNameMapper;
        return this;
    }

    public JmxRegistry withWorkerPredicate(BiPredicate<Key<?>, Integer> predicate) {
        this.workerPredicate = predicate;
        return this;
    }

    public void addWorkerPoolKey(WorkerPool workerPool, Key<?> workerPoolKey) {
        Checks.checkArgument((!this.workerPoolKeys.containsKey(workerPool) ? 1 : 0) != 0, (Object)"Key already added");
        this.workerPoolKeys.put(workerPool, workerPoolKey);
    }

    public void registerSingleton(@NotNull Key<?> key, @NotNull Object singletonInstance, @NotNull JmxBeanSettings settings) {
        ObjectName objectName;
        ProtoObjectName protoName;
        Object mbean;
        Class<?> instanceClass = singletonInstance.getClass();
        if (Utils.isJmxBean(instanceClass)) {
            mbean = this.mbeanFactory.createDynamicMBean(Collections.singletonList(singletonInstance), settings, true);
        } else if (Utils.isStandardMBean(instanceClass) || Utils.isMXBean(instanceClass) || Utils.isDynamicMBean(instanceClass)) {
            mbean = singletonInstance;
        } else {
            logger.trace("Instance with key {} was not registered to jmx, because its type or any of its supertypes is not annotated with @JmxBean annotation and does not implement neither *MBean nor *MXBean interface", key);
            return;
        }
        try {
            protoName = this.createProtoObjectNameForKey(key);
        }
        catch (ReflectiveOperationException e) {
            logger.error("Error during generation name for instance with key {}", key, (Object)e);
            return;
        }
        protoName = this.objectNameMapper.apply(protoName);
        try {
            objectName = this.createObjectName(protoName);
        }
        catch (ReflectiveOperationException | MalformedObjectNameException e) {
            logger.error("Cannot create ObjectName for instance with key {}. Proposed proto name was \"{}\".", new Object[]{key, protoName, e});
            return;
        }
        try {
            this.mbs.registerMBean(mbean, objectName);
            logger.trace("Instance with key {} was successfully registered to jmx with ObjectName \"{}\" ", key, (Object)objectName);
            this.registeredObjectNames.add(objectName);
            ++this.registeredSingletons;
            ++this.totallyRegisteredMBeans;
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            String msg = String.format("Cannot register MBean for instance with key %s and ObjectName \"%s\"", key, objectName);
            logger.error(msg, (Throwable)e);
        }
    }

    public void unregisterSingleton(@NotNull Key<?> key, Object singletonInstance) {
        if (Utils.isMBean(singletonInstance.getClass())) {
            try {
                ProtoObjectName name = this.createProtoObjectNameForKey(key);
                name = this.objectNameMapper.apply(name);
                ObjectName objectName = this.createObjectName(name);
                this.mbs.unregisterMBean(objectName);
                this.registeredObjectNames.remove(objectName);
            }
            catch (ReflectiveOperationException | JMException e) {
                String msg = String.format("Error during attempt to unregister MBean for instance with key %s.", key);
                logger.error(msg, (Throwable)e);
            }
        }
    }

    public void registerWorkers(@NotNull WorkerPool pool, Key<?> key, @NotNull List<?> poolInstances, JmxBeanSettings settings) {
        ObjectName objectName;
        DynamicMBean mbean;
        ProtoObjectName commonName;
        if (poolInstances.isEmpty()) {
            logger.info("Pool of instances with key {} is empty", key);
            return;
        }
        if (poolInstances.stream().map(Object::getClass).collect(Collectors.toSet()).size() != 1) {
            logger.info("Pool of instances with key {} was not registered to jmx because their types differ", key);
            return;
        }
        if (!Utils.isJmxBean(poolInstances.get(0).getClass())) {
            logger.info("Pool of instances with key {} was not registered to jmx, because instances' type or any of instances' supertypes is not annotated with @JmxBean annotation", key);
            return;
        }
        try {
            commonName = this.createProtoObjectNameForKey(key, pool);
        }
        catch (Exception e) {
            String msg = String.format("Error during generation name for pool of instances with key %s", key.toString());
            logger.error(msg, (Throwable)e);
            return;
        }
        for (int i = 0; i < poolInstances.size(); ++i) {
            if (!this.workerPredicate.test(key, i)) continue;
            JmxBeanSettings settingsForOptionals = JmxBeanSettings.of(settings.getIncludedOptionals(), new HashMap(), this.customTypes);
            this.registerMBeanForWorker(poolInstances.get(i), i, commonName, key, settingsForOptionals);
        }
        try {
            mbean = this.mbeanFactory.createDynamicMBean(poolInstances, settings, true);
        }
        catch (Exception e) {
            String msg = String.format("Cannot create DynamicMBean for aggregated MBean of pool of workers with key %s", key);
            logger.error(msg, (Throwable)e);
            return;
        }
        ProtoObjectName mappedName = this.objectNameMapper.apply(commonName);
        try {
            objectName = this.createObjectName(mappedName);
        }
        catch (ReflectiveOperationException | MalformedObjectNameException e) {
            String msg = String.format("Cannot create ObjectName for aggregated MBean of pool of workers with key %s. Proposed String name was \"%s\".", key, mappedName);
            logger.error(msg, (Throwable)e);
            return;
        }
        try {
            this.mbs.registerMBean(mbean, objectName);
            logger.trace("Pool of instances with key {} was successfully registered to jmx with ObjectName \"{}\"", key, (Object)objectName);
            this.registeredObjectNames.add(objectName);
            ++this.registeredPools;
            ++this.totallyRegisteredMBeans;
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            String msg = String.format("Cannot register aggregated MBean of pool of workers with key %s and ObjectName \"%s\"", key, objectName);
            logger.error(msg, (Throwable)e);
        }
    }

    public void unregisterWorkers(WorkerPool pool, @NotNull Key<?> key, List<?> poolInstances) {
        String msg;
        ProtoObjectName commonName;
        if (poolInstances.isEmpty()) {
            return;
        }
        if (poolInstances.stream().map(Object::getClass).collect(Collectors.toSet()).size() != 1) {
            return;
        }
        if (!Utils.isJmxBean(poolInstances.get(0).getClass())) {
            return;
        }
        try {
            commonName = this.createProtoObjectNameForKey(key, pool);
        }
        catch (ReflectiveOperationException e) {
            String msg2 = String.format("Error during generation name for pool of instances with key %s", key);
            logger.error(msg2, (Throwable)e);
            return;
        }
        for (int i = 0; i < poolInstances.size(); ++i) {
            if (!this.workerPredicate.test(key, i)) continue;
            try {
                ProtoObjectName workerName = JmxRegistry.addWorkerName(commonName, i);
                ProtoObjectName mappedWorkerName = this.objectNameMapper.apply(workerName);
                ObjectName objectName = this.createObjectName(mappedWorkerName);
                this.mbs.unregisterMBean(objectName);
                this.registeredObjectNames.remove(objectName);
                continue;
            }
            catch (ReflectiveOperationException | JMException e) {
                msg = String.format("Error during attempt to unregister mbean for worker of pool of instances with key %s. Worker id is \"%d\"", key, i);
                logger.error(msg, (Throwable)e);
            }
        }
        ProtoObjectName mappedName = this.objectNameMapper.apply(commonName);
        try {
            ObjectName objectName = this.createObjectName(mappedName);
            this.mbs.unregisterMBean(objectName);
            this.registeredObjectNames.remove(objectName);
        }
        catch (ReflectiveOperationException | JMException e) {
            msg = String.format("Error during attempt to unregister aggregated mbean for pool of instances with key %s.", key);
            logger.error(msg, (Throwable)e);
        }
    }

    public void unregisterAll() {
        Iterator<ObjectName> iterator = this.registeredObjectNames.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = iterator.next();
            try {
                this.mbs.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException e) {
                String msg = String.format("Cannot unregister MBean with ObjectName \"%s\"", objectName.toString());
                logger.error(msg, (Throwable)e);
            }
            iterator.remove();
        }
    }

    private void registerMBeanForWorker(Object worker, int workerId, ProtoObjectName commonName, Key<?> key, JmxBeanSettings settings) {
        ObjectName objectName;
        DynamicMBean mbean;
        ProtoObjectName workerName = JmxRegistry.addWorkerName(commonName, workerId);
        ProtoObjectName mappedWorkerName = this.objectNameMapper.apply(workerName);
        try {
            mbean = this.mbeanFactory.createDynamicMBean(Collections.singletonList(worker), settings, false);
        }
        catch (Exception e) {
            String msg = String.format("Cannot create DynamicMBean for worker of pool of instances with key %s", key.toString());
            logger.error(msg, (Throwable)e);
            return;
        }
        try {
            objectName = this.createObjectName(mappedWorkerName);
        }
        catch (ReflectiveOperationException | MalformedObjectNameException e) {
            String msg = String.format("Cannot create ObjectName for worker of pool of instances with key %s. Proposed proto object name was \"%s\".", key.toString(), mappedWorkerName);
            logger.error(msg, (Throwable)e);
            return;
        }
        try {
            this.mbs.registerMBean(mbean, objectName);
            this.registeredObjectNames.add(objectName);
            ++this.totallyRegisteredMBeans;
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            String msg = String.format("Cannot register MBean for worker of pool of instances with key %s. ObjectName for worker is \"%s\"", key.toString(), objectName);
            logger.error(msg, (Throwable)e);
        }
    }

    private static ProtoObjectName addWorkerName(ProtoObjectName protoObjectName, int workerId) {
        return protoObjectName.withWorkerId("worker-" + workerId);
    }

    private ProtoObjectName createProtoObjectNameForKey(Key<?> key) throws ReflectiveOperationException {
        return this.createProtoObjectNameForKey(key, null);
    }

    private ProtoObjectName createProtoObjectNameForKey(Key<?> key, @Nullable WorkerPool pool) throws ReflectiveOperationException {
        Type type;
        Class rawType = key.getRawType();
        Package domainPackage = rawType.getPackage();
        String packageName = domainPackage == null ? "" : domainPackage.getName();
        ProtoObjectName protoObjectName = ProtoObjectName.create(rawType.getSimpleName(), packageName);
        Object keyQualifier = key.getQualifier();
        if (keyQualifier instanceof UniqueQualifierImpl) {
            keyQualifier = ((UniqueQualifierImpl)keyQualifier).getOriginalQualifier();
        }
        protoObjectName = protoObjectName.withQualifier(keyQualifier);
        if (pool != null) {
            Key<?> poolKey;
            if (this.withScopes) {
                Scope scope = pool.getScope();
                protoObjectName = protoObjectName.withScope(scope.getDisplayString());
            }
            if ((poolKey = this.workerPoolKeys.get(pool)) != null && poolKey.getQualifier() != null) {
                String qualifierString = Utils.getQualifierString(poolKey.getQualifier());
                protoObjectName = protoObjectName.withWorkerPoolQualifier("WorkerPool@" + qualifierString);
            }
        }
        if ((type = key.getType()) instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] genericArgs = pType.getActualTypeArguments();
            ArrayList<String> genericParams = new ArrayList<String>();
            for (Type genericArg : genericArgs) {
                String argClassName = JmxRegistry.formatSimpleGenericName(genericArg);
                genericParams.add(argClassName);
            }
            protoObjectName = protoObjectName.withGenericParameters(genericParams);
        }
        return protoObjectName;
    }

    private static String formatAnnotationString(String annotationString) {
        if (!annotationString.contains("(")) {
            return "annotation=" + annotationString;
        }
        if (!annotationString.startsWith("(")) {
            String annotationName = annotationString.substring(0, annotationString.indexOf(40));
            return annotationName + '=' + annotationString.substring(annotationString.indexOf(40) + 1, annotationString.length() - 1);
        }
        return annotationString.substring(1, annotationString.length() - 1);
    }

    private static String formatSimpleGenericName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        ParameterizedType genericType = (ParameterizedType)type;
        return ((Class)genericType.getRawType()).getSimpleName() + Arrays.stream(genericType.getActualTypeArguments()).map(JmxRegistry::formatSimpleGenericName).collect(Collectors.joining(";", "<", ">"));
    }

    private ObjectName createObjectName(ProtoObjectName protoObjectName) throws MalformedObjectNameException, ReflectiveOperationException {
        String workerId;
        List<String> genericParameters;
        String workerPoolQualifier;
        String scope;
        Object qualifier;
        StringJoiner joiner = new StringJoiner(",", protoObjectName.getPackageName() + ":", "");
        if (protoObjectName.getClassName() != null) {
            joiner.add("type=" + protoObjectName.getClassName());
        }
        if ((qualifier = protoObjectName.getQualifier()) != null) {
            String qualifierString = null;
            if (qualifier instanceof Class) {
                Class qualifierClass = (Class)qualifier;
                if (qualifierClass.isAnnotation()) {
                    qualifierString = qualifierClass.getSimpleName();
                }
            } else if (qualifier instanceof Annotation) {
                qualifierString = ReflectionUtils.getAnnotationString((Annotation)((Annotation)qualifier));
            }
            qualifierString = qualifierString != null ? JmxRegistry.formatAnnotationString(qualifierString) : "qualifier=" + qualifier;
            joiner.add(qualifierString);
        }
        if ((scope = protoObjectName.getScope()) != null) {
            joiner.add("scope=" + scope);
        }
        if ((workerPoolQualifier = protoObjectName.getWorkerPoolQualifier()) != null) {
            joiner.add("workerPool=" + workerPoolQualifier);
        }
        if ((genericParameters = protoObjectName.getGenericParameters()) != null) {
            for (int i = 0; i < genericParameters.size(); ++i) {
                int argId = i + 1;
                joiner.add(String.format(GENERIC_PARAM_NAME_FORMAT, argId, genericParameters.get(i)));
            }
        }
        if ((workerId = protoObjectName.getWorkerId()) != null) {
            joiner.add("workerId=" + workerId);
        }
        return new ObjectName(joiner.toString());
    }

    @Override
    public int getRegisteredSingletons() {
        return this.registeredSingletons;
    }

    @Override
    public int getRegisteredPools() {
        return this.registeredPools;
    }

    @Override
    public int getTotallyRegisteredMBeans() {
        return this.totallyRegisteredMBeans;
    }

    @Override
    public String getRefreshPeriod() {
        return StringFormatUtils.formatDuration((Duration)this.mbeanFactory.getSpecifiedRefreshPeriod());
    }

    @Override
    public void setRefreshPeriod(String refreshPeriod) {
        this.mbeanFactory.setRefreshPeriod(StringFormatUtils.parseDuration((String)refreshPeriod));
    }

    @Override
    public int getMaxRefreshesPerOneCycle() {
        return this.mbeanFactory.getMaxJmxRefreshesPerOneCycle();
    }

    @Override
    public void setMaxRefreshesPerOneCycle(int maxRefreshesPerOneCycle) {
        this.mbeanFactory.setMaxJmxRefreshesPerOneCycle(maxRefreshesPerOneCycle);
    }

    @Override
    public String[] getRefreshStats() {
        return this.mbeanFactory.getRefreshStats();
    }
}

