/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.jmx.ValueFetcher;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ValueFetcherFromGetterArrayAdapter
implements ValueFetcher {
    private final Method getter;

    public ValueFetcherFromGetterArrayAdapter(@NotNull Method getter) {
        this.getter = getter;
    }

    @Override
    public Object fetchFrom(Object source) {
        try {
            Object arr = this.getter.invoke(source, new Object[0]);
            if (arr.getClass().getComponentType().isPrimitive()) {
                return this.wrapPrimitives(arr);
            }
            return Arrays.asList((Object[])arr);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Object> wrapPrimitives(Object arr) {
        int length = Array.getLength(arr);
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> wrappers = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            wrappers.add(Array.get(arr, i));
        }
        return wrappers;
    }
}

