/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launcher;

import io.activej.inject.Injector;
import io.activej.inject.InstanceInjector;
import io.activej.inject.Key;
import io.activej.inject.module.Module;
import io.activej.inject.module.ModuleBuilder;
import io.activej.inject.util.Trie;
import io.activej.inject.util.Utils;
import io.activej.jmx.api.ConcurrentJmxBeanAdapter;
import io.activej.jmx.api.JmxBean;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.launcher.LauncherService;
import io.activej.launcher.annotation.Args;
import io.activej.launcher.annotation.OnComplete;
import io.activej.launcher.annotation.OnRun;
import io.activej.launcher.annotation.OnStart;
import io.activej.types.Types;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JmxBean(value=ConcurrentJmxBeanAdapter.class)
public abstract class Launcher {
    public static final Key<Set<InstanceInjector<?>>> INSTANCE_INJECTORS_KEY = new Key<Set<InstanceInjector<?>>>(){};
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Logger logger0 = LoggerFactory.getLogger((String)(this.getClass().getName() + ".0"));
    public static final String[] NO_ARGS = new String[0];
    protected String[] args = NO_ARGS;
    private Thread mainThread;
    private volatile Throwable applicationError;
    private volatile Instant instantOfLaunch;
    private volatile Instant instantOfStart;
    private volatile Instant instantOfRun;
    private volatile Instant instantOfStop;
    private volatile Instant instantOfComplete;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final CountDownLatch completeLatch = new CountDownLatch(1);
    private final CompletableFuture<Void> onStartFuture = new CompletableFuture();
    private final CompletableFuture<Void> onRunFuture = new CompletableFuture();
    private final CompletableFuture<Void> onCompleteFuture = new CompletableFuture();
    private final Thread shutdownHook = new Thread(() -> {
        try {
            this.shutdownLatch.countDown();
            this.completeLatch.await();
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("Shutdown thread got interrupted", (Throwable)e);
        }
    }, "shutdownNotification");

    public final void testInjector() {
        this.createInjector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void launch(String[] args) throws Exception {
        block18: {
            this.mainThread = Thread.currentThread();
            this.instantOfLaunch = Instant.now();
            try {
                this.logger.info("=== INJECTING DEPENDENCIES");
                Injector injector = this.createInjector(args);
                injector.getInstance(this.getClass());
                if (this.logger0.isInfoEnabled()) {
                    this.logger0.info("Effective Injector:\n\n{}", (Object)Utils.makeGraphVizGraph((Trie)injector.getBindingsTrie()));
                }
                this.onInit(injector);
                injector.createEagerInstances();
                this.logger0.info("Created eager singletons");
                Set services = (Set)injector.getInstanceOr((Key)new Key<Set<LauncherService>>(){}, Collections.emptySet());
                HashSet<LauncherService> startedServices = new HashSet<LauncherService>();
                this.logger0.info("Post-injected instances: {}", this.postInjectInstances(injector));
                this.logger.info("=== STARTING APPLICATION");
                try {
                    this.instantOfStart = Instant.now();
                    this.logger0.info("Starting Root Services: {}", (Object)services);
                    this.startServices(services, startedServices);
                    this.onStart();
                    this.onStartFuture.complete(null);
                }
                catch (Exception e) {
                    this.applicationError = e;
                    this.logger.error("Start error", (Throwable)e);
                    this.onStartFuture.completeExceptionally(e);
                }
                if (this.applicationError == null) {
                    this.logger.info("=== RUNNING APPLICATION");
                    try {
                        this.instantOfRun = Instant.now();
                        this.run();
                        this.onRunFuture.complete(null);
                    }
                    catch (Exception e) {
                        this.applicationError = e;
                        this.logger.error("Error", (Throwable)e);
                        this.onRunFuture.completeExceptionally(e);
                    }
                } else {
                    this.onRunFuture.completeExceptionally(this.applicationError);
                }
                this.logger.info("=== STOPPING APPLICATION");
                this.instantOfStop = Instant.now();
                if (!this.onStartFuture.isCompletedExceptionally()) {
                    try {
                        this.onStop();
                    }
                    catch (Exception e) {
                        this.logger.error("Stop error", (Throwable)e);
                    }
                }
                this.stopServices(startedServices);
                if (this.applicationError == null) {
                    this.onCompleteFuture.complete(null);
                    break block18;
                }
                this.onCompleteFuture.completeExceptionally(this.applicationError);
                throw this.applicationError;
            }
            catch (Exception e) {
                if (this.applicationError != e) {
                    this.logger.error("Launch error", (Throwable)e);
                }
                throw e;
            }
            catch (Throwable e) {
                this.applicationError = e;
                this.logger.error("JVM Fatal Error", e);
                System.exit(-1);
            }
            finally {
                this.instantOfComplete = Instant.now();
                this.completeLatch.countDown();
            }
        }
    }

    private Set<Key<?>> postInjectInstances(Injector injector) {
        Set postInjectors = (Set)injector.getInstanceOr(INSTANCE_INJECTORS_KEY, Collections.emptySet());
        for (InstanceInjector instanceInjector : postInjectors) {
            Object instance = injector.peekInstance(instanceInjector.key());
            if (instance == null) continue;
            instanceInjector.injectInto(instance);
        }
        return postInjectors.stream().map(InstanceInjector::key).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServices(Collection<LauncherService> services, Collection<LauncherService> startedServices) throws Throwable {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        CountDownLatch latch = new CountDownLatch(services.size());
        Launcher launcher = this;
        synchronized (launcher) {
            for (LauncherService service : services) {
                if (!exceptions.isEmpty()) {
                    latch.countDown();
                    continue;
                }
                this.logger0.info("Starting Root Service: {}", (Object)service);
                service.start().whenComplete(($, e) -> {
                    Launcher launcher = this;
                    synchronized (launcher) {
                        if (e == null) {
                            startedServices.add(service);
                        } else {
                            exceptions.add((e instanceof CompletionException || e instanceof ExecutionException) && e.getCause() != null ? e.getCause() : e);
                        }
                        latch.countDown();
                    }
                });
            }
        }
        latch.await();
        if (!exceptions.isEmpty()) {
            exceptions.sort(Comparator.comparingInt(e -> e instanceof RuntimeException ? 1 : (e instanceof Error ? 0 : 2)));
            throw (Throwable)exceptions.get(0);
        }
    }

    private void stopServices(Collection<LauncherService> startedServices) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(startedServices.size());
        for (LauncherService service : startedServices) {
            this.logger0.info("Stopping Root Service: {}", (Object)service);
            service.stop().whenComplete(($, e) -> {
                if (e != null) {
                    this.logger.error("Stop error in " + service, (e instanceof CompletionException || e instanceof ExecutionException) && e.getCause() != null ? e.getCause() : e);
                }
                latch.countDown();
            });
        }
        latch.await();
    }

    @NotNull
    public final Injector createInjector(String[] args) {
        this.args = args;
        return this.createInjector();
    }

    @NotNull
    public final Injector createInjector() {
        return Injector.of((Module[])new Module[]{this.getInternalModule().combineWith(this.getModule()).overrideWith(this.getOverrideModule())});
    }

    private Module getInternalModule() {
        Class<?> launcherClass = this.getClass();
        Key<CompletionStage<Void>> completionStageKey = new Key<CompletionStage<Void>>(){};
        return ModuleBuilder.create().bind(String[].class, Args.class).toInstance((Object)this.args).bind(Launcher.class).to(launcherClass).bind(launcherClass).toInstance((Object)this).bindIntoSet(INSTANCE_INJECTORS_KEY.getTypeParameter(0), Key.ofType((Type)Types.parameterizedType(InstanceInjector.class, (Type[])new Type[]{launcherClass}))).bind(completionStageKey.qualified(OnStart.class)).toInstance(this.onStartFuture).bind(completionStageKey.qualified(OnRun.class)).toInstance(this.onRunFuture).bind(completionStageKey.qualified(OnComplete.class)).toInstance(this.onCompleteFuture).scan((Object)this).build();
    }

    protected Module getModule() {
        return Module.empty();
    }

    protected Module getOverrideModule() {
        return Module.empty();
    }

    protected void onInit(Injector injector) throws Exception {
    }

    protected void onStart() throws Exception {
    }

    protected abstract void run() throws Exception;

    protected void onStop() throws Exception {
    }

    protected final void awaitShutdown() throws InterruptedException {
        if (this.shutdownLatch.getCount() != 1L) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.shutdownLatch.await();
    }

    public final void shutdown() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        this.shutdownLatch.countDown();
    }

    @NotNull
    public final Thread getMainThread() {
        return this.mainThread;
    }

    public final String[] getArgs() {
        return this.args;
    }

    public final CompletionStage<Void> getStartFuture() {
        return this.onStartFuture;
    }

    public final CompletionStage<Void> getRunFuture() {
        return this.onRunFuture;
    }

    public final CompletionStage<Void> getCompleteFuture() {
        return this.onCompleteFuture;
    }

    @JmxAttribute
    @Nullable
    public final Instant getInstantOfLaunch() {
        return this.instantOfLaunch;
    }

    @JmxAttribute
    @Nullable
    public final Instant getInstantOfStart() {
        return this.instantOfStart;
    }

    @JmxAttribute
    @Nullable
    public final Instant getInstantOfRun() {
        return this.instantOfRun;
    }

    @JmxAttribute
    @Nullable
    public final Instant getInstantOfStop() {
        return this.instantOfStop;
    }

    @JmxAttribute
    @Nullable
    public final Instant getInstantOfComplete() {
        return this.instantOfComplete;
    }

    @JmxAttribute
    @Nullable
    public final Duration getDurationOfStart() {
        if (this.instantOfLaunch == null) {
            return null;
        }
        return Duration.between(this.instantOfLaunch, this.instantOfRun == null ? Instant.now() : this.instantOfRun);
    }

    @JmxAttribute
    @Nullable
    public final Duration getDurationOfRun() {
        if (this.instantOfRun == null) {
            return null;
        }
        return Duration.between(this.instantOfRun, this.instantOfStop == null ? Instant.now() : this.instantOfStop);
    }

    @JmxAttribute
    @Nullable
    public final Duration getDurationOfStop() {
        if (this.instantOfStop == null) {
            return null;
        }
        return Duration.between(this.instantOfStop, this.instantOfComplete == null ? Instant.now() : this.instantOfComplete);
    }

    @JmxAttribute
    @Nullable
    public final Duration getDuration() {
        if (this.instantOfLaunch == null) {
            return null;
        }
        return Duration.between(this.instantOfLaunch, this.instantOfComplete == null ? Instant.now() : this.instantOfComplete);
    }

    @JmxAttribute
    @Nullable
    public final Throwable getApplicationError() {
        return this.applicationError;
    }
}

