/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.initializers;

import io.activej.async.service.EventloopTaskScheduler;
import io.activej.common.MemSize;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.initializer.Initializer;
import io.activej.config.Config;
import io.activej.config.converter.ConfigConverter;
import io.activej.config.converter.ConfigConverters;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.inspector.ThrottlingController;
import io.activej.eventloop.net.ServerSocketSettings;
import io.activej.eventloop.net.SocketSettings;
import io.activej.http.AsyncHttpServer;
import io.activej.inject.Key;
import io.activej.jmx.JmxModule;
import io.activej.jmx.stats.ExceptionStats;
import io.activej.launcher.Launcher;
import io.activej.launchers.initializers.TriggersHelper;
import io.activej.net.AbstractServer;
import io.activej.net.PrimaryServer;
import io.activej.promise.RetryPolicy;
import io.activej.trigger.Severity;
import io.activej.trigger.TriggerResult;
import io.activej.trigger.TriggersModuleSettings;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public class Initializers {
    public static final String GLOBAL_EVENTLOOP_NAME = "GlobalEventloopStats";
    public static final Key<Eventloop> GLOBAL_EVENTLOOP_KEY = Key.of(Eventloop.class, (Object)"GlobalEventloopStats");

    public static <T extends AbstractServer<T>> Initializer<T> ofAbstractServer(Config config) {
        return server -> server.withListenAddresses((List)config.get(ConfigConverters.ofList((ConfigConverter)ConfigConverters.ofInetSocketAddress()), "listenAddresses")).withAcceptOnce(((Boolean)config.get(ConfigConverters.ofBoolean(), "acceptOnce", (Object)false)).booleanValue()).withSocketSettings((SocketSettings)config.get(ConfigConverters.ofSocketSettings(), "socketSettings", (Object)server.getSocketSettings())).withServerSocketSettings((ServerSocketSettings)config.get(ConfigConverters.ofServerSocketSettings(), "serverSocketSettings", (Object)server.getServerSocketSettings()));
    }

    public static Initializer<PrimaryServer> ofPrimaryServer(Config config) {
        return Initializers.ofAbstractServer(config);
    }

    public static Initializer<Eventloop> ofEventloop(Config config) {
        return eventloop -> eventloop.withEventloopFatalErrorHandler((FatalErrorHandler)config.get(ConfigConverters.ofFatalErrorHandler(), "fatalErrorHandler", (Object)eventloop.getEventloopFatalErrorHandler())).withThreadFatalErrorHandler((FatalErrorHandler)config.get(ConfigConverters.ofFatalErrorHandler(), "threadFatalErrorHandler", (Object)eventloop.getThreadFatalErrorHandler())).withIdleInterval((Duration)config.get(ConfigConverters.ofDuration(), "idleInterval", (Object)eventloop.getIdleInterval())).withThreadPriority(((Integer)config.get(ConfigConverters.ofInteger(), "threadPriority", (Object)eventloop.getThreadPriority())).intValue());
    }

    public static Initializer<EventloopTaskScheduler> ofEventloopTaskScheduler(Config config) {
        return scheduler -> {
            scheduler.setEnabled((Boolean)config.get(ConfigConverters.ofBoolean(), "disabled", (Object)false) == false);
            scheduler.withAbortOnError(((Boolean)config.get(ConfigConverters.ofBoolean(), "abortOnError", (Object)false)).booleanValue()).withInitialDelay((Duration)config.get(ConfigConverters.ofDuration(), "initialDelay", (Object)Duration.ZERO)).withSchedule((EventloopTaskScheduler.Schedule)config.get(ConfigConverters.ofEventloopTaskSchedule(), "schedule", null)).withRetryPolicy((RetryPolicy)config.get(ConfigConverters.ofRetryPolicy(), "retryPolicy"));
        };
    }

    public static Initializer<AsyncHttpServer> ofHttpServer(Config config) {
        return server -> ((AsyncHttpServer)server.withInitializer(Initializers.ofAbstractServer(config))).withInitializer(Initializers.ofHttpWorker(config));
    }

    public static Initializer<AsyncHttpServer> ofHttpWorker(Config config) {
        return server -> server.withKeepAliveTimeout((Duration)config.get(ConfigConverters.ofDuration(), "keepAliveTimeout", (Object)server.getKeepAliveTimeout())).withReadWriteTimeout((Duration)config.get(ConfigConverters.ofDuration(), "readWriteTimeout", (Object)server.getReadWriteTimeout())).withMaxBodySize((MemSize)config.get(ConfigConverters.ofMemSize(), "maxBodySize", (Object)MemSize.ZERO));
    }

    public static Initializer<JmxModule> ofGlobalEventloopStats() {
        return jmxModule -> jmxModule.withGlobalMBean(Eventloop.class, GLOBAL_EVENTLOOP_KEY).withOptional(GLOBAL_EVENTLOOP_KEY, "fatalErrors_total").withOptional(GLOBAL_EVENTLOOP_KEY, "businessLogicTime_smoothedAverage").withOptional(GLOBAL_EVENTLOOP_KEY, "loops_totalCount").withOptional(GLOBAL_EVENTLOOP_KEY, "loops_smoothedRate").withOptional(GLOBAL_EVENTLOOP_KEY, "idleLoops_totalCount").withOptional(GLOBAL_EVENTLOOP_KEY, "idleLoops_smoothedRate").withOptional(GLOBAL_EVENTLOOP_KEY, "selectOverdues_totalCount").withOptional(GLOBAL_EVENTLOOP_KEY, "selectOverdues_smoothedRate");
    }

    public static Initializer<TriggersModuleSettings> ofLauncherTriggers(Duration maxRunDelay) {
        return triggersSettings -> triggersSettings.with(Launcher.class, Severity.AVERAGE, "runDelay", launcher -> TriggerResult.ofValue((Object)launcher.getDurationOfStart(), (launcher.getInstantOfRun() == null && launcher.getDurationOfStart() != null && launcher.getDurationOfStart().toMillis() > maxRunDelay.toMillis() ? 1 : 0) != 0));
    }

    public static Initializer<TriggersModuleSettings> ofEventloopFatalErrorsTriggers() {
        return triggersSettings -> triggersSettings.with(Eventloop.class, Severity.HIGH, "fatalErrors", eventloop -> eventloop.getStats() == null ? TriggerResult.none() : TriggerResult.ofError((ExceptionStats)eventloop.getStats().getFatalErrors()));
    }

    public static Initializer<TriggersModuleSettings> ofEventloopBusinessLogicTriggers(Config config) {
        long businessLogicTimeLow = (Long)config.get(ConfigConverters.ofDurationAsMillis(), "businessLogicTimeLow", (Object)10L);
        long businessLogicTimeHigh = (Long)config.get(ConfigConverters.ofDurationAsMillis(), "businessLogicTimeHigh", (Object)100L);
        return triggersSettings -> triggersSettings.with(Eventloop.class, Severity.WARNING, "businessLogic", eventloop -> eventloop.getStats() == null ? TriggerResult.none() : TriggerResult.ofValue((Object)eventloop.getStats().getBusinessLogicTime().getSmoothedAverage(), businessLogicTime -> businessLogicTime > (double)businessLogicTimeLow)).with(Eventloop.class, Severity.HIGH, "businessLogic", eventloop -> eventloop.getStats() == null ? TriggerResult.none() : TriggerResult.ofValue((Object)eventloop.getStats().getBusinessLogicTime().getSmoothedAverage(), businessLogicTime -> businessLogicTime > (double)businessLogicTimeHigh));
    }

    public static Initializer<TriggersModuleSettings> ofThrottlingControllerTriggers(Config config) {
        double throttlingLow = (Double)config.get(ConfigConverters.ofDouble(), "throttlingLow", (Object)0.1);
        double throttlingHigh = (Double)config.get(ConfigConverters.ofDouble(), "throttlingHigh", (Object)0.5);
        return triggersSettings -> triggersSettings.with(ThrottlingController.class, Severity.WARNING, "throttling", throttlingController -> TriggerResult.ofValue((Object)(throttlingController == null ? null : Double.valueOf(throttlingController.getAvgThrottling())), throttling -> throttling > throttlingLow)).with(ThrottlingController.class, Severity.HIGH, "throttling", throttlingController -> TriggerResult.ofValue((Object)(throttlingController == null ? null : Double.valueOf(throttlingController.getAvgThrottling())), throttling -> throttling > throttlingHigh));
    }

    public static Initializer<TriggersModuleSettings> ofEventloopTaskSchedulerTriggers(Config config) {
        Long delayError = (Long)config.get(ConfigConverters.ofDurationAsMillis(), "scheduler.delayError", null);
        Long delayWarning = (Long)config.get(ConfigConverters.ofDurationAsMillis(), "scheduler.delayWarning", null);
        return triggersSettings -> triggersSettings.with(EventloopTaskScheduler.class, Severity.WARNING, "error", scheduler -> TriggerResult.ofError((Throwable)scheduler.getLastException())).with(EventloopTaskScheduler.class, Severity.INFORMATION, "error", scheduler -> TriggersHelper.ofPromiseStatsLastSuccess(scheduler.getStats())).with(EventloopTaskScheduler.class, Severity.WARNING, "delay", scheduler -> {
            Duration currentDuration = scheduler.getStats().getCurrentDuration();
            Duration duration = Initializers.getDuration(scheduler);
            if (currentDuration == null || duration == null) {
                return TriggerResult.none();
            }
            return TriggerResult.ofInstant((Instant)scheduler.getStats().getLastStartTime(), (currentDuration.toMillis() > (delayWarning != null ? delayWarning : duration.toMillis() * 3L) ? 1 : 0) != 0);
        }).with(EventloopTaskScheduler.class, Severity.HIGH, "delay", scheduler -> {
            Duration currentDuration = scheduler.getStats().getCurrentDuration();
            Duration duration = Initializers.getDuration(scheduler);
            if (currentDuration == null || duration == null) {
                return TriggerResult.none();
            }
            return TriggerResult.ofInstant((Instant)scheduler.getStats().getLastStartTime(), (currentDuration.toMillis() > (delayError != null ? delayError : duration.toMillis() * 10L) ? 1 : 0) != 0);
        });
    }

    private static Duration getDuration(EventloopTaskScheduler scheduler) {
        return scheduler.getPeriod() != null ? scheduler.getPeriod() : scheduler.getInterval();
    }
}

