/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.http;

import io.activej.config.Config;
import io.activej.config.ConfigModule;
import io.activej.config.converter.ConfigConverter;
import io.activej.config.converter.ConfigConverters;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.inspector.EventloopInspector;
import io.activej.eventloop.inspector.ThrottlingController;
import io.activej.http.AsyncHttpServer;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpResponse;
import io.activej.inject.annotation.Inject;
import io.activej.inject.annotation.Provides;
import io.activej.inject.binding.OptionalDependency;
import io.activej.inject.module.AbstractModule;
import io.activej.inject.module.Module;
import io.activej.inject.module.Modules;
import io.activej.launcher.Launcher;
import io.activej.launchers.initializers.Initializers;
import io.activej.net.PrimaryServer;
import io.activej.service.ServiceGraphModule;
import io.activej.worker.WorkerPool;
import io.activej.worker.WorkerPoolModule;
import io.activej.worker.WorkerPools;
import io.activej.worker.annotation.Worker;
import io.activej.worker.annotation.WorkerId;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class MultithreadedHttpServerLauncher
extends Launcher {
    public static final int PORT = 8080;
    public static final int WORKERS = 4;
    public static final String PROPERTIES_FILE = "http-server.properties";
    @Inject
    PrimaryServer primaryServer;

    @Provides
    Eventloop primaryEventloop(Config config) {
        return (Eventloop)Eventloop.create().withInitializer((Consumer)Initializers.ofEventloop((Config)config.getChild("eventloop.primary")));
    }

    @Provides
    @Worker
    Eventloop workerEventloop(Config config, OptionalDependency<ThrottlingController> throttlingController) {
        return (Eventloop)((Eventloop)Eventloop.create().withInitializer((Consumer)Initializers.ofEventloop((Config)config.getChild("eventloop.worker")))).withInitializer(eventloop -> eventloop.withInspector((EventloopInspector)throttlingController.orElse(null)));
    }

    @Provides
    WorkerPool workerPool(WorkerPools workerPools, Config config) {
        return workerPools.createPool(((Integer)config.get(ConfigConverters.ofInteger(), "workers", (Object)4)).intValue());
    }

    @Provides
    PrimaryServer primaryServer(Eventloop primaryEventloop, WorkerPool.Instances<AsyncHttpServer> workerServers, Config config) {
        return (PrimaryServer)PrimaryServer.create((Eventloop)primaryEventloop, (List)workerServers.getList()).withInitializer((Consumer)Initializers.ofPrimaryServer((Config)config.getChild("http")));
    }

    @Provides
    @Worker
    AsyncHttpServer workerServer(Eventloop eventloop, AsyncServlet servlet, Config config) {
        return (AsyncHttpServer)AsyncHttpServer.create((Eventloop)eventloop, (AsyncServlet)servlet).withInitializer((Consumer)Initializers.ofHttpWorker((Config)config.getChild("http")));
    }

    @Provides
    Config config() {
        return Config.create().with("http.listenAddresses", Config.ofValue((ConfigConverter)ConfigConverters.ofInetSocketAddress(), (Object)new InetSocketAddress(8080))).with("workers", "4").overrideWith(Config.ofClassPathProperties((String)PROPERTIES_FILE, (boolean)true)).overrideWith(Config.ofSystemProperties((String)"config"));
    }

    protected final Module getModule() {
        return Modules.combine((Module[])new Module[]{ServiceGraphModule.create(), WorkerPoolModule.create(), ConfigModule.create().withEffectiveConfigLogger(), this.getBusinessLogicModule()});
    }

    protected Module getBusinessLogicModule() {
        return Module.empty();
    }

    protected void run() throws Exception {
        this.logger.info("HTTP Server is listening on {}", (Object)Stream.concat(this.primaryServer.getListenAddresses().stream().map(address -> "http://" + ("0.0.0.0".equals(address.getHostName()) ? "localhost" : address.getHostName()) + (address.getPort() != 80 ? ":" + address.getPort() : "") + "/"), this.primaryServer.getSslListenAddresses().stream().map(address -> "https://" + ("0.0.0.0".equals(address.getHostName()) ? "localhost" : address.getHostName()) + (address.getPort() != 80 ? ":" + address.getPort() : "") + "/")).collect(Collectors.joining(" ")));
        this.awaitShutdown();
    }

    public static void main(String[] args) throws Exception {
        MultithreadedHttpServerLauncher launcher = new MultithreadedHttpServerLauncher(){

            @Override
            protected Module getBusinessLogicModule() {
                return new AbstractModule(){

                    @Provides
                    @Worker
                    AsyncServlet servlet(@WorkerId int workerId) {
                        return request -> HttpResponse.ok200().withPlainText("Hello, world! #" + workerId);
                    }
                };
            }
        };
        launcher.launch(args);
    }
}

