/*
 * Decompiled with CFR 0.152.
 */
package io.activej.net.socket.udp;

import io.activej.bytebuf.ByteBuf;
import io.activej.common.Checks;
import io.activej.common.Utils;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.Nullable;

public final class UdpPacket {
    @Nullable
    private ByteBuf buf;
    private final InetSocketAddress inetSocketAddress;

    private UdpPacket(@Nullable ByteBuf buf, InetSocketAddress inetSocketAddress) {
        this.buf = buf;
        this.inetSocketAddress = inetSocketAddress;
    }

    public static UdpPacket of(ByteBuf buf, InetSocketAddress inetSocketAddress) {
        return new UdpPacket(buf, inetSocketAddress);
    }

    public ByteBuf getBuf() {
        return (ByteBuf)Checks.checkNotNull((Object)this.buf, (Object)"Using UdpPacket after recycling");
    }

    public InetSocketAddress getSocketAddress() {
        return this.inetSocketAddress;
    }

    public void recycle() {
        this.buf = (ByteBuf)Utils.nullify((Object)this.buf, ByteBuf::recycle);
    }
}

