/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.AsyncAccumulator;
import io.activej.async.function.AsyncBiPredicate;
import io.activej.async.process.AsyncExecutor;
import io.activej.async.process.AsyncExecutors;
import io.activej.common.ref.RefBoolean;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class AsyncBiPredicates {
    @Contract(pure=true)
    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> buffer(@NotNull AsyncBiPredicate<T, U> actual) {
        return AsyncBiPredicates.buffer(1, Integer.MAX_VALUE, actual);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> buffer(int maxParallelCalls, int maxBufferedCalls, @NotNull AsyncBiPredicate<T, U> asyncPredicate) {
        return AsyncBiPredicates.ofExecutor(AsyncExecutors.buffered(maxParallelCalls, maxBufferedCalls), asyncPredicate);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> ofExecutor(@NotNull AsyncExecutor asyncExecutor, @NotNull AsyncBiPredicate<T, U> predicate) {
        return (t, u) -> asyncExecutor.execute(() -> predicate.test(t, u));
    }

    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> and(Collection<AsyncBiPredicate<? super T, ? super U>> predicates) {
        return (t, u) -> {
            AsyncAccumulator<RefBoolean> asyncAccumulator = AsyncAccumulator.create(new RefBoolean(true));
            for (AsyncBiPredicate predicate : predicates) {
                asyncAccumulator.addPromise(predicate.test(t, u), (ref, result) -> ref.set(ref.get() && result != false));
            }
            return asyncAccumulator.run().map(RefBoolean::get);
        };
    }

    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> and() {
        return AsyncBiPredicate.alwaysTrue();
    }

    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> and(AsyncBiPredicate<? super T, ? super U> predicate1) {
        return predicate1;
    }

    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> and(AsyncBiPredicate<? super T, ? super U> predicate1, AsyncBiPredicate<? super T, ? super U> predicate2) {
        return predicate1.and(predicate2);
    }

    @SafeVarargs
    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> and(AsyncBiPredicate<? super T, ? super U> ... predicates) {
        return AsyncBiPredicates.and(Arrays.asList(predicates));
    }

    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> or(Collection<AsyncBiPredicate<? super T, ? super U>> predicates) {
        return (t, u) -> {
            AsyncAccumulator<RefBoolean> asyncAccumulator = AsyncAccumulator.create(new RefBoolean(false));
            for (AsyncBiPredicate predicate : predicates) {
                asyncAccumulator.addPromise(predicate.test(t, u), (ref, result) -> ref.set(ref.get() || result != false));
            }
            return asyncAccumulator.run().map(RefBoolean::get);
        };
    }

    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> or() {
        return AsyncBiPredicate.alwaysFalse();
    }

    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> or(AsyncBiPredicate<? super T, ? super U> predicate1) {
        return predicate1;
    }

    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> or(AsyncBiPredicate<? super T, ? super U> predicate1, AsyncBiPredicate<? super T, ? super U> predicate2) {
        return predicate1.or(predicate2);
    }

    @SafeVarargs
    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> or(AsyncBiPredicate<? super T, ? super U> ... predicates) {
        return AsyncBiPredicates.or(Arrays.asList(predicates));
    }
}

