/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.ConsumerEx;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface AsyncConsumer<T> {
    @NotNull
    public Promise<Void> accept(T var1);

    @NotNull
    public static <T> AsyncConsumer<T> of(@NotNull ConsumerEx<? super T> consumer) {
        return value -> {
            try {
                consumer.accept(value);
            }
            catch (Exception e) {
                FatalErrorHandlers.handleError((Throwable)e, (Object)consumer);
                return Promise.ofException(e);
            }
            return Promise.complete();
        };
    }
}

