/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.RunnableEx;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface AsyncRunnable {
    public Promise<Void> run();

    @NotNull
    public static AsyncRunnable of(@NotNull RunnableEx runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                FatalErrorHandlers.handleError((Throwable)e, (Object)runnable);
                return Promise.ofException(e);
            }
            return Promise.complete();
        };
    }
}

