/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncFunction;
import io.activej.async.function.AsyncRunnable;
import io.activej.async.process.AsyncExecutor;
import io.activej.async.process.AsyncExecutors;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AsyncRunnables {
    @Contract(pure=true)
    @NotNull
    public static AsyncRunnable reuse(final @NotNull AsyncRunnable actual) {
        return new AsyncRunnable(){
            @Nullable
            Promise<Void> runningPromise;

            @Override
            @NotNull
            public Promise<Void> run() {
                if (this.runningPromise != null) {
                    return this.runningPromise;
                }
                Promise<Void> runningPromise = this.runningPromise = actual.run();
                runningPromise.whenComplete(() -> {
                    this.runningPromise = null;
                });
                return runningPromise;
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static AsyncRunnable coalesce(@NotNull AsyncRunnable actual) {
        AsyncFunction fn = Promises.coalesce(() -> null, (a, v) -> {}, a -> actual.run());
        return () -> fn.apply(null);
    }

    @Contract(pure=true)
    @NotNull
    public static AsyncRunnable buffer(@NotNull AsyncRunnable actual) {
        return AsyncRunnables.buffer(1, Integer.MAX_VALUE, actual);
    }

    @Contract(pure=true)
    @NotNull
    public static AsyncRunnable buffer(int maxParallelCalls, int maxBufferedCalls, @NotNull AsyncRunnable asyncRunnable) {
        return AsyncRunnables.ofExecutor(AsyncExecutors.buffered(maxParallelCalls, maxBufferedCalls), asyncRunnable);
    }

    @Contract(pure=true)
    @NotNull
    public static AsyncRunnable ofExecutor(@NotNull AsyncExecutor asyncExecutor, @NotNull AsyncRunnable runnable) {
        return () -> asyncExecutor.execute(runnable::run);
    }
}

