/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.SupplierEx;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface AsyncSupplier<T> {
    public Promise<T> get();

    public static <T> AsyncSupplier<T> of(@NotNull SupplierEx<T> supplier) {
        return () -> {
            try {
                return Promise.of(supplier.get());
            }
            catch (Exception e) {
                FatalErrorHandlers.handleError((Throwable)e, (Object)supplier);
                return Promise.ofException(e);
            }
        };
    }
}

