/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.process;

import io.activej.async.function.AsyncSupplier;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.promise.Promise;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import org.jetbrains.annotations.NotNull;

public interface AsyncExecutor {
    @NotNull
    public <T> Promise<T> execute(@NotNull AsyncSupplier<T> var1) throws RejectedExecutionException;

    @NotNull
    default public Promise<Void> run(@NotNull Runnable runnable) throws RejectedExecutionException {
        return this.execute(() -> {
            runnable.run();
            return Promise.complete();
        });
    }

    @NotNull
    default public <T> Promise<T> call(@NotNull Callable<T> callable) throws RejectedExecutionException {
        return this.execute(() -> {
            Object result;
            try {
                result = callable.call();
            }
            catch (Exception e) {
                FatalErrorHandlers.handleError((Throwable)e, (Object)this);
                return Promise.ofException(e);
            }
            return Promise.of(result);
        });
    }
}

