/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.Callback;
import io.activej.common.collection.Try;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.BiFunctionEx;
import io.activej.common.function.ConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.function.RunnableEx;
import io.activej.common.function.SupplierEx;
import io.activej.common.recycle.Recyclers;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.promise.NextPromise;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CompleteExceptionallyPromise<T>
implements Promise<T> {
    @NotNull
    private final Exception exception;

    public CompleteExceptionallyPromise(@NotNull Exception e) {
        this.exception = e;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isResult() {
        return false;
    }

    @Override
    public boolean isException() {
        return true;
    }

    @Override
    public T getResult() {
        return null;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public Try<T> getTry() {
        return Try.ofException((Exception)this.exception);
    }

    @Override
    @NotNull
    public <U> Promise<U> next(@NotNull NextPromise<T, U> promise) {
        promise.accept(null, this.exception);
        return promise;
    }

    @Override
    @NotNull
    public <U> Promise<U> map(@NotNull FunctionEx<? super T, ? extends U> fn) {
        return this;
    }

    @Override
    @NotNull
    public <U> Promise<U> mapIfElse(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, ? extends U> fn, @NotNull FunctionEx<? super T, ? extends U> fnElse) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> mapIf(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, ? extends T> fn) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> mapIfNull(@NotNull SupplierEx<? extends T> supplier) {
        return this;
    }

    @Override
    @NotNull
    public <U> Promise<U> mapIfNonNull(@NotNull @NotNull FunctionEx<? super @NotNull T, ? extends U> fn) {
        return this;
    }

    @Override
    @NotNull
    public <U> Promise<U> map(@NotNull BiFunctionEx<? super T, Exception, ? extends U> fn) {
        try {
            return Promise.of(fn.apply(null, (Object)this.exception));
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> map(@NotNull FunctionEx<? super T, ? extends U> fn, @NotNull @NotNull FunctionEx<@NotNull Exception, ? extends U> exceptionFn) {
        try {
            return Promise.of(exceptionFn.apply((Object)this.exception));
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> mapException(@NotNull @NotNull FunctionEx<@NotNull Exception, @NotNull Exception> exceptionFn) {
        try {
            return Promise.ofException((Exception)exceptionFn.apply((Object)this.exception));
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> mapException(@NotNull Predicate<Exception> predicate, @NotNull @NotNull FunctionEx<@NotNull Exception, @NotNull Exception> exceptionFn) {
        try {
            return predicate.test(this.exception) ? Promise.ofException((Exception)exceptionFn.apply((Object)this.exception)) : this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> mapException(@NotNull Class<? extends Exception> clazz, @NotNull @NotNull FunctionEx<@NotNull Exception, @NotNull Exception> exceptionFn) {
        try {
            return clazz.isAssignableFrom(this.exception.getClass()) ? Promise.ofException((Exception)exceptionFn.apply((Object)this.exception)) : this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> then(@NotNull FunctionEx<? super T, Promise<? extends U>> fn) {
        return this;
    }

    @Override
    @NotNull
    public <U> Promise<U> thenIfElse(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, Promise<? extends U>> fn, @NotNull FunctionEx<? super T, Promise<? extends U>> fnElse) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> thenIf(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, Promise<? extends T>> fn) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> thenIfNull(@NotNull SupplierEx<Promise<? extends T>> supplier) {
        return this;
    }

    @Override
    @NotNull
    public <U> Promise<U> thenIfNonNull(@NotNull @NotNull FunctionEx<? super @NotNull T, Promise<? extends U>> fn) {
        return this;
    }

    @Override
    @NotNull
    public <U> Promise<U> then(@NotNull SupplierEx<Promise<? extends U>> fn) {
        return this;
    }

    @Override
    @NotNull
    public <U> Promise<U> then(@NotNull BiFunctionEx<? super T, Exception, Promise<? extends U>> fn) {
        try {
            return (Promise)fn.apply(null, (Object)this.exception);
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> then(@NotNull FunctionEx<? super T, Promise<? extends U>> fn, @NotNull @NotNull FunctionEx<@NotNull Exception, Promise<? extends U>> exceptionFn) {
        try {
            return (Promise)exceptionFn.apply((Object)this.exception);
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> when(@NotNull BiPredicate<? super T, @Nullable Exception> predicate, @NotNull BiConsumerEx<? super T, Exception> fn) {
        try {
            if (predicate.test(null, this.exception)) {
                fn.accept(null, (Object)this.exception);
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> when(@NotNull BiPredicate<? super T, @Nullable Exception> predicate, @Nullable ConsumerEx<? super T> fn, @Nullable ConsumerEx<@NotNull Exception> exceptionFn) {
        try {
            if (predicate.test(null, this.exception)) {
                exceptionFn.accept((Object)this.exception);
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> when(@NotNull BiPredicate<? super T, @Nullable Exception> predicate, @NotNull RunnableEx action) {
        try {
            if (predicate.test(null, this.exception)) {
                action.run();
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(@NotNull BiConsumerEx<? super T, Exception> fn) {
        try {
            fn.accept(null, (Object)this.exception);
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(@NotNull ConsumerEx<? super T> fn, @NotNull @NotNull ConsumerEx<@NotNull Exception> exceptionFn) {
        try {
            exceptionFn.accept((Object)this.exception);
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(@NotNull RunnableEx action) {
        try {
            action.run();
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenResult(ConsumerEx<? super T> fn) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenResult(@NotNull Predicate<? super T> predicate, ConsumerEx<? super T> fn) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenResult(@NotNull RunnableEx action) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenResult(@NotNull Predicate<? super T> predicate, @NotNull RunnableEx action) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull ConsumerEx<Exception> fn) {
        try {
            fn.accept((Object)this.exception);
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull Predicate<Exception> predicate, @NotNull @NotNull ConsumerEx<@NotNull Exception> fn) {
        try {
            if (predicate.test(this.exception)) {
                fn.accept((Object)this.exception);
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull Class<? extends Exception> clazz, @NotNull @NotNull ConsumerEx<@NotNull Exception> fn) {
        try {
            if (clazz.isAssignableFrom(this.exception.getClass())) {
                fn.accept((Object)this.exception);
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull RunnableEx action) {
        try {
            action.run();
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull Predicate<Exception> predicate, @NotNull RunnableEx action) {
        try {
            if (predicate.test(this.exception)) {
                action.run();
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull Class<? extends Exception> clazz, @NotNull RunnableEx action) {
        try {
            if (clazz.isAssignableFrom(this.exception.getClass())) {
                action.run();
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public <U, V> Promise<V> combine(@NotNull Promise<? extends U> other, @NotNull BiFunctionEx<? super T, ? super U, ? extends V> fn) {
        other.whenResult(Recyclers::recycle);
        return this;
    }

    @Override
    @NotNull
    public Promise<Void> both(@NotNull Promise<?> other) {
        other.whenResult(Recyclers::recycle);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> either(@NotNull Promise<? extends T> other) {
        return other;
    }

    @Override
    @NotNull
    public Promise<T> async() {
        SettablePromise result = new SettablePromise();
        Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext(result, () -> result.setException(this.exception)));
        return result;
    }

    @Override
    @NotNull
    public Promise<Try<T>> toTry() {
        return Promise.of(Try.ofException((Exception)this.exception));
    }

    @Override
    @NotNull
    public Promise<Void> toVoid() {
        return this;
    }

    @Override
    public void run(@NotNull Callback<? super T> callback) {
        callback.accept(null, this.exception);
    }

    @Override
    @NotNull
    public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(this.exception);
        return future;
    }
}

