/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.AsyncAccumulator;
import io.activej.async.AsyncBuffer;
import io.activej.async.callback.Callback;
import io.activej.async.exception.AsyncTimeoutException;
import io.activej.async.function.AsyncFunction;
import io.activej.async.function.AsyncRunnable;
import io.activej.async.function.AsyncSupplier;
import io.activej.common.Utils;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.recycle.Recyclers;
import io.activej.common.tuple.Tuple1;
import io.activej.common.tuple.Tuple2;
import io.activej.common.tuple.Tuple3;
import io.activej.common.tuple.Tuple4;
import io.activej.common.tuple.Tuple5;
import io.activej.common.tuple.Tuple6;
import io.activej.common.tuple.TupleConstructor1;
import io.activej.common.tuple.TupleConstructor2;
import io.activej.common.tuple.TupleConstructor3;
import io.activej.common.tuple.TupleConstructor4;
import io.activej.common.tuple.TupleConstructor5;
import io.activej.common.tuple.TupleConstructor6;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.schedule.ScheduledRunnable;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.promise.AbstractPromise;
import io.activej.promise.NextPromise;
import io.activej.promise.Promise;
import io.activej.promise.PromisePredicates;
import io.activej.promise.RetryPolicy;
import io.activej.promise.SettablePromise;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Promises {
    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> timeout(@NotNull Duration delay, @NotNull Promise<T> promise) {
        return Promises.timeout(delay.toMillis(), promise);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> timeout(final long delay, final @NotNull Promise<T> promise) {
        if (promise.isComplete()) {
            return promise;
        }
        if (delay <= 0L) {
            return Promise.ofException((Exception)new AsyncTimeoutException("Promise timeout"));
        }
        return promise.next(new NextPromise<T, T>(){
            @Nullable
            ScheduledRunnable schedule;
            {
                this.schedule = Eventloop.getCurrentEventloop().delay(delay, RunnableWithContext.wrapContext((Object)this, () -> {
                    promise.whenResult(Recyclers::recycle);
                    this.schedule = null;
                    this.tryCompleteExceptionally((Exception)new AsyncTimeoutException("Promise timeout"));
                }));
            }

            public void accept(T result, @Nullable Exception e) {
                this.schedule = (ScheduledRunnable)Utils.nullify((Object)this.schedule, ScheduledRunnable::cancel);
                if (e == null) {
                    this.tryComplete(result);
                } else {
                    this.tryCompleteExceptionally(e);
                }
            }
        });
    }

    @Contract(pure=true)
    @NotNull
    public static Promise<Void> delay(@NotNull Duration delay) {
        return Promises.delay(delay.toMillis(), (Void)null);
    }

    @Contract(pure=true)
    @NotNull
    public static Promise<Void> delay(long delayMillis) {
        return Promises.delay(delayMillis, (Void)null);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> delay(@NotNull Duration delay, T value) {
        return Promises.delay(delay.toMillis(), value);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> delay(long delayMillis, T value) {
        if (delayMillis <= 0L) {
            return Promise.of(value);
        }
        SettablePromise cb = new SettablePromise();
        Eventloop.getCurrentEventloop().delay(delayMillis, RunnableWithContext.wrapContext(cb, () -> cb.set(value)));
        return cb;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> delay(@NotNull Duration delay, @NotNull Promise<T> promise) {
        return Promises.delay(delay.toMillis(), promise);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> delay(long delayMillis, @NotNull Promise<T> promise) {
        if (delayMillis <= 0L) {
            return promise;
        }
        return Promise.ofCallback(cb -> Eventloop.getCurrentEventloop().delay(delayMillis, RunnableWithContext.wrapContext((Object)cb, () -> promise.run((Callback)cb))));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> interval(@NotNull Duration interval, @NotNull Promise<T> promise) {
        return Promises.interval(interval.toMillis(), promise);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> interval(long intervalMillis, @NotNull Promise<T> promise) {
        return intervalMillis <= 0L ? promise : promise.then(value -> Promise.ofCallback(cb -> Eventloop.getCurrentEventloop().delay(intervalMillis, RunnableWithContext.wrapContext((Object)cb, () -> cb.set(value)))));
    }

    @Contract(pure=true)
    @NotNull
    public static Promise<Void> schedule(@NotNull Instant instant) {
        return Promises.schedule((Void)null, instant.toEpochMilli());
    }

    @Contract(pure=true)
    @NotNull
    public static Promise<Void> schedule(long timestamp) {
        return Promises.schedule((Void)null, timestamp);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> schedule(T value, @NotNull Instant instant) {
        return Promises.schedule(value, instant.toEpochMilli());
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> schedule(T value, long timestamp) {
        SettablePromise cb = new SettablePromise();
        Eventloop.getCurrentEventloop().schedule(timestamp, RunnableWithContext.wrapContext(cb, () -> cb.set(value)));
        return cb;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> schedule(@NotNull Promise<T> promise, @NotNull Instant instant) {
        return Promises.schedule(promise, instant.toEpochMilli());
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> schedule(@NotNull Promise<T> promise, long timestamp) {
        return Promise.ofCallback(cb -> Eventloop.getCurrentEventloop().schedule(timestamp, RunnableWithContext.wrapContext((Object)cb, () -> promise.run((Callback)cb))));
    }

    @Contract(pure=true)
    @NotNull
    public static Promise<Void> all() {
        return Promise.complete();
    }

    @Contract(pure=true)
    @NotNull
    public static Promise<Void> all(@NotNull Promise<?> promise1) {
        return promise1.toVoid();
    }

    @Contract(pure=true)
    @NotNull
    public static Promise<Void> all(@NotNull Promise<?> promise1, @NotNull Promise<?> promise2) {
        return promise1.both(promise2);
    }

    @Contract(pure=true)
    @NotNull
    public static Promise<Void> all(Promise<?> ... promises) {
        return Promises.all(Arrays.asList(promises));
    }

    @Contract(pure=true)
    @NotNull
    public static Promise<Void> all(@NotNull List<? extends Promise<?>> promises) {
        int size = promises.size();
        if (size == 0) {
            return Promise.complete();
        }
        if (size == 1) {
            return promises.get(0).map(AbstractPromise::recycleToVoid);
        }
        if (size == 2) {
            return promises.get(0).both(promises.get(1));
        }
        return Promises.allIterator(promises.iterator(), true);
    }

    @Contract(pure=true)
    @NotNull
    public static Promise<Void> all(@NotNull Stream<? extends Promise<?>> promises) {
        return Promises.all(promises.iterator());
    }

    @NotNull
    public static Promise<Void> all(@NotNull Iterator<? extends Promise<?>> promises) {
        return Promises.allIterator(promises, false);
    }

    @NotNull
    private static Promise<Void> allIterator(@NotNull Iterator<? extends Promise<?>> promises, boolean ownership) {
        if (!promises.hasNext()) {
            return Promises.all();
        }
        PromiseAll resultPromise = new PromiseAll();
        while (promises.hasNext()) {
            Promise<?> promise = promises.next();
            if (promise.isResult()) {
                Recyclers.recycle(promise.getResult());
                continue;
            }
            if (promise.isException()) {
                if (ownership) {
                    promises.forEachRemaining(Recyclers::recycle);
                } else {
                    Recyclers.recycle(promises);
                }
                return Promise.ofException(promise.getException());
            }
            ++resultPromise.countdown;
            promise.run(resultPromise);
        }
        --resultPromise.countdown;
        return resultPromise.countdown == 0 ? Promise.complete() : resultPromise;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> any() {
        return Promise.ofException(new Exception("There are no promises to be complete"));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> any(@NotNull Promise<? extends T> promise1) {
        return promise1;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> any(@NotNull Promise<? extends T> promise1, @NotNull Promise<? extends T> promise2) {
        return promise1.either(promise2);
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> any(Promise<? extends T> ... promises) {
        return Promises.any(PromisePredicates.isResult(), Arrays.asList(promises));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> any(@NotNull List<? extends Promise<? extends T>> promises) {
        int size = promises.size();
        if (size == 0) {
            return Promises.any();
        }
        if (size == 1) {
            return promises.get(0);
        }
        if (size == 2) {
            return promises.get(0).either(promises.get(1));
        }
        return Promises.any(PromisePredicates.isResult(), promises);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> any(@NotNull Stream<? extends Promise<? extends T>> promises) {
        return Promises.any(PromisePredicates.isResult(), promises.iterator());
    }

    @NotNull
    public static <T> Promise<T> any(@NotNull Iterator<? extends Promise<? extends T>> promises) {
        return Promises.any(PromisePredicates.isResult(), promises);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> any(@NotNull BiPredicate<? super T, Exception> predicate, @NotNull Promise<? extends T> promise1) {
        return Promises.any(predicate, Collections.singletonList(promise1));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> any(@NotNull BiPredicate<? super T, Exception> predicate, @NotNull Promise<? extends T> promise1, @NotNull Promise<? extends T> promise2) {
        return Promises.any(predicate, Arrays.asList(promise1, promise2));
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> any(@NotNull BiPredicate<? super T, Exception> predicate, Promise<? extends T> ... promises) {
        return Promises.any(predicate, Arrays.asList(promises));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> any(@NotNull BiPredicate<? super T, Exception> predicate, @NotNull Stream<? extends Promise<? extends T>> promises) {
        return Promises.any(predicate, promises.iterator());
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T> any(@NotNull BiPredicate<? super T, Exception> predicate, @NotNull List<? extends Promise<? extends T>> promises) {
        return Promises.anyIterator(predicate, promises.iterator(), true);
    }

    @NotNull
    public static <T> Promise<T> any(@NotNull BiPredicate<? super T, Exception> predicate, @NotNull Iterator<? extends Promise<? extends T>> promises) {
        return Promises.anyIterator(predicate, promises, false);
    }

    @NotNull
    private static <T> Promise<T> anyIterator(@NotNull BiPredicate<? super T, Exception> predicate, @NotNull Iterator<? extends Promise<? extends T>> promises, boolean ownership) {
        if (!promises.hasNext()) {
            return Promises.any();
        }
        PromiseAny resultPromise = new PromiseAny(predicate);
        while (promises.hasNext()) {
            Promise promise = promises.next();
            if (promise.isComplete()) {
                T result = promise.getResult();
                if (predicate.test(result, promise.getException())) {
                    if (ownership) {
                        promises.forEachRemaining(Recyclers::recycle);
                    } else {
                        Recyclers.recycle(promises);
                    }
                    return Promise.of(result);
                }
                Recyclers.recycle(result);
                continue;
            }
            ++resultPromise.countdown;
            promise.run(resultPromise);
        }
        --resultPromise.countdown;
        return resultPromise.countdown == 0 ? Promises.any() : resultPromise;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<List<T>> toList() {
        return Promise.of(Collections.emptyList());
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<List<T>> toList(@NotNull Promise<? extends T> promise1) {
        return promise1.map(Collections::singletonList);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<List<T>> toList(@NotNull Promise<? extends T> promise1, @NotNull Promise<? extends T> promise2) {
        return promise1.combine(promise2, (xva$0, xva$1) -> Arrays.asList(xva$0, xva$1));
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Promise<List<T>> toList(Promise<? extends T> ... promises) {
        return Promises.toList(Arrays.asList(promises));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<List<T>> toList(@NotNull List<? extends Promise<? extends T>> promises) {
        int size = promises.size();
        if (size == 0) {
            return Promise.of(Collections.emptyList());
        }
        if (size == 1) {
            return promises.get(0).map(Collections::singletonList);
        }
        if (size == 2) {
            return promises.get(0).combine(promises.get(1), (xva$0, xva$1) -> Arrays.asList(xva$0, xva$1));
        }
        return Promises.toListImpl(promises.iterator(), promises.size(), true);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<List<T>> toList(@NotNull Stream<? extends Promise<? extends T>> promises) {
        return Promises.toList(promises.iterator());
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<List<T>> toList(@NotNull Iterable<? extends Promise<? extends T>> promises) {
        return Promises.toList(promises.iterator());
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<List<T>> toList(@NotNull Iterator<? extends Promise<? extends T>> promises) {
        return Promises.toListImpl(promises, 10, false);
    }

    @Contract(pure=true)
    @NotNull
    private static <T> Promise<List<T>> toListImpl(@NotNull Iterator<? extends Promise<? extends T>> promises, int initialSize, boolean ownership) {
        PromisesToList resultPromise = new PromisesToList(initialSize);
        int i = 0;
        while (promises.hasNext() && !resultPromise.isComplete()) {
            resultPromise.addToList(i, promises.next());
            ++i;
        }
        if (promises.hasNext()) {
            if (ownership) {
                promises.forEachRemaining(Recyclers::recycle);
            } else {
                Recyclers.recycle(promises);
            }
        }
        return resultPromise.countdown == 0 ? Promise.of(resultPromise.getList()) : resultPromise;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T[]> toArray(@NotNull Class<T> type) {
        return Promise.of((Object[])Array.newInstance(type, 0));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T[]> toArray(@NotNull Class<T> type, @NotNull Promise<? extends T> promise1) {
        return promise1.map(value -> {
            Object[] array = (Object[])Array.newInstance(type, 1);
            array[0] = value;
            return array;
        });
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T[]> toArray(@NotNull Class<T> type, @NotNull Promise<? extends T> promise1, @NotNull Promise<? extends T> promise2) {
        return promise1.combine(promise2, (value1, value2) -> {
            Object[] array = (Object[])Array.newInstance(type, 2);
            array[0] = value1;
            array[1] = value2;
            return array;
        });
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T[]> toArray(@NotNull Class<T> type, Promise<? extends T> ... promises) {
        return Promises.toList(promises).map(list -> list.toArray((Object[])Array.newInstance(type, list.size())));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T[]> toArray(@NotNull Class<T> type, @NotNull List<? extends Promise<? extends T>> promises) {
        int size = promises.size();
        if (size == 0) {
            return Promises.toArray(type);
        }
        if (size == 1) {
            return Promises.toArray(type, promises.get(0));
        }
        if (size == 2) {
            return Promises.toArray(type, promises.get(0), promises.get(1));
        }
        return Promises.toList(promises).map(list -> list.toArray((Object[])Array.newInstance(type, list.size())));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T[]> toArray(@NotNull Class<T> type, @NotNull Stream<? extends Promise<? extends T>> promises) {
        return Promises.toList(promises).map(list -> list.toArray((Object[])Array.newInstance(type, list.size())));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T[]> toArray(@NotNull Class<T> type, @NotNull Iterable<? extends Promise<? extends T>> promises) {
        return Promises.toList(promises).map(list -> list.toArray((Object[])Array.newInstance(type, list.size())));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Promise<T[]> toArray(@NotNull Class<T> type, @NotNull Iterator<? extends Promise<? extends T>> promises) {
        return Promises.toList(promises).map(list -> list.toArray((Object[])Array.newInstance(type, list.size())));
    }

    @Contract(pure=true)
    @NotNull
    public static <T1, R> Promise<R> toTuple(@NotNull TupleConstructor1<T1, R> constructor, @NotNull Promise<? extends T1> promise1) {
        return promise1.map(arg_0 -> constructor.create(arg_0));
    }

    @Contract(pure=true)
    @NotNull
    public static <T1, T2, R> Promise<R> toTuple(@NotNull TupleConstructor2<T1, T2, R> constructor, @NotNull Promise<? extends T1> promise1, @NotNull Promise<? extends T2> promise2) {
        return promise1.combine(promise2, (arg_0, arg_1) -> constructor.create(arg_0, arg_1));
    }

    @Contract(pure=true)
    @NotNull
    public static <T1, T2, T3, R> Promise<R> toTuple(@NotNull TupleConstructor3<T1, T2, T3, R> constructor, @NotNull Promise<? extends T1> promise1, @NotNull Promise<? extends T2> promise2, @NotNull Promise<? extends T3> promise3) {
        return Promises.toList(promise1, promise2, promise3).map(list -> constructor.create(list.get(0), list.get(1), list.get(2)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T1, T2, T3, T4, R> Promise<R> toTuple(@NotNull TupleConstructor4<T1, T2, T3, T4, R> constructor, @NotNull Promise<? extends T1> promise1, @NotNull Promise<? extends T2> promise2, @NotNull Promise<? extends T3> promise3, @NotNull Promise<? extends T4> promise4) {
        return Promises.toList(promise1, promise2, promise3, promise4).map(list -> constructor.create(list.get(0), list.get(1), list.get(2), list.get(3)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T1, T2, T3, T4, T5, R> Promise<R> toTuple(@NotNull TupleConstructor5<T1, T2, T3, T4, T5, R> constructor, @NotNull Promise<? extends T1> promise1, @NotNull Promise<? extends T2> promise2, @NotNull Promise<? extends T3> promise3, @NotNull Promise<? extends T4> promise4, @NotNull Promise<? extends T5> promise5) {
        return Promises.toList(promise1, promise2, promise3, promise4, promise5).map(list -> constructor.create(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T1, T2, T3, T4, T5, T6, R> Promise<R> toTuple(@NotNull TupleConstructor6<T1, T2, T3, T4, T5, T6, R> constructor, @NotNull Promise<? extends T1> promise1, @NotNull Promise<? extends T2> promise2, @NotNull Promise<? extends T3> promise3, @NotNull Promise<? extends T4> promise4, @NotNull Promise<? extends T5> promise5, @NotNull Promise<? extends T6> promise6) {
        return Promises.toList(promise1, promise2, promise3, promise4, promise5, promise6).map(list -> constructor.create(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T1> Promise<Tuple1<T1>> toTuple(@NotNull Promise<? extends T1> promise1) {
        return promise1.map(Tuple1::new);
    }

    @Contract(pure=true)
    @NotNull
    public static <T1, T2> Promise<Tuple2<T1, T2>> toTuple(@NotNull Promise<? extends T1> promise1, @NotNull Promise<? extends T2> promise2) {
        return promise1.combine(promise2, Tuple2::new);
    }

    @Contract(pure=true)
    @NotNull
    public static <T1, T2, T3> Promise<Tuple3<T1, T2, T3>> toTuple(@NotNull Promise<? extends T1> promise1, @NotNull Promise<? extends T2> promise2, @NotNull Promise<? extends T3> promise3) {
        return Promises.toList(promise1, promise2, promise3).map(list -> new Tuple3(list.get(0), list.get(1), list.get(2)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T1, T2, T3, T4> Promise<Tuple4<T1, T2, T3, T4>> toTuple(@NotNull Promise<? extends T1> promise1, @NotNull Promise<? extends T2> promise2, @NotNull Promise<? extends T3> promise3, @NotNull Promise<? extends T4> promise4) {
        return Promises.toList(promise1, promise2, promise3, promise4).map(list -> new Tuple4(list.get(0), list.get(1), list.get(2), list.get(3)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T1, T2, T3, T4, T5> Promise<Tuple5<T1, T2, T3, T4, T5>> toTuple(@NotNull Promise<? extends T1> promise1, @NotNull Promise<? extends T2> promise2, @NotNull Promise<? extends T3> promise3, @NotNull Promise<? extends T4> promise4, @NotNull Promise<? extends T5> promise5) {
        return Promises.toList(promise1, promise2, promise3, promise4, promise5).map(list -> new Tuple5(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T1, T2, T3, T4, T5, T6> Promise<Tuple6<T1, T2, T3, T4, T5, T6>> toTuple(@NotNull Promise<? extends T1> promise1, @NotNull Promise<? extends T2> promise2, @NotNull Promise<? extends T3> promise3, @NotNull Promise<? extends T4> promise4, @NotNull Promise<? extends T5> promise5, @NotNull Promise<? extends T6> promise6) {
        return Promises.toList(promise1, promise2, promise3, promise4, promise5, promise6).map(list -> new Tuple6(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T, T1, R, R1> AsyncFunction<T, R> mapTuple(@NotNull TupleConstructor1<R1, R> constructor, @NotNull Function<? super T, T1> getter1, Function<T1, Promise<R1>> fn1) {
        return t -> Promises.toTuple(constructor, (Promise)fn1.apply(getter1.apply(t)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T, T1, T2, R, R1, R2> AsyncFunction<T, R> mapTuple(@NotNull TupleConstructor2<R1, R2, R> constructor, @NotNull Function<? super T, T1> getter1, Function<T1, Promise<R1>> fn1, @NotNull Function<? super T, T2> getter2, Function<T2, Promise<R2>> fn2) {
        return t -> Promises.toTuple(constructor, (Promise)fn1.apply(getter1.apply(t)), (Promise)fn2.apply(getter2.apply(t)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T, T1, T2, T3, R, R1, R2, R3> AsyncFunction<T, R> mapTuple(@NotNull TupleConstructor3<R1, R2, R3, R> constructor, @NotNull Function<? super T, T1> getter1, Function<T1, Promise<R1>> fn1, @NotNull Function<? super T, T2> getter2, Function<T2, Promise<R2>> fn2, @NotNull Function<? super T, T3> getter3, Function<T3, Promise<R3>> fn3) {
        return t -> Promises.toTuple(constructor, (Promise)fn1.apply(getter1.apply(t)), (Promise)fn2.apply(getter2.apply(t)), (Promise)fn3.apply(getter3.apply(t)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T, T1, T2, T3, T4, R, R1, R2, R3, R4> AsyncFunction<T, R> mapTuple(@NotNull TupleConstructor4<R1, R2, R3, R4, R> constructor, @NotNull Function<? super T, T1> getter1, Function<T1, Promise<R1>> fn1, @NotNull Function<? super T, T2> getter2, Function<T2, Promise<R2>> fn2, @NotNull Function<? super T, T3> getter3, Function<T3, Promise<R3>> fn3, @NotNull Function<? super T, T4> getter4, Function<T4, Promise<R4>> fn4) {
        return t -> Promises.toTuple(constructor, (Promise)fn1.apply(getter1.apply(t)), (Promise)fn2.apply(getter2.apply(t)), (Promise)fn3.apply(getter3.apply(t)), (Promise)fn4.apply(getter4.apply(t)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T, T1, T2, T3, T4, T5, R, R1, R2, R3, R4, R5> AsyncFunction<T, R> mapTuple(@NotNull TupleConstructor5<R1, R2, R3, R4, R5, R> constructor, @NotNull Function<? super T, T1> getter1, Function<T1, Promise<R1>> fn1, @NotNull Function<? super T, T2> getter2, Function<T2, Promise<R2>> fn2, @NotNull Function<? super T, T3> getter3, Function<T3, Promise<R3>> fn3, @NotNull Function<? super T, T4> getter4, Function<T4, Promise<R4>> fn4, @NotNull Function<? super T, T5> getter5, Function<T5, Promise<R5>> fn5) {
        return t -> Promises.toTuple(constructor, (Promise)fn1.apply(getter1.apply(t)), (Promise)fn2.apply(getter2.apply(t)), (Promise)fn3.apply(getter3.apply(t)), (Promise)fn4.apply(getter4.apply(t)), (Promise)fn5.apply(getter5.apply(t)));
    }

    @Contract(pure=true)
    @NotNull
    public static <T, T1, T2, T3, T4, T5, T6, R, R1, R2, R3, R4, R5, R6> AsyncFunction<T, R> mapTuple(@NotNull TupleConstructor6<R1, R2, R3, R4, R5, R6, R> constructor, @NotNull Function<? super T, T1> getter1, Function<T1, Promise<R1>> fn1, @NotNull Function<? super T, T2> getter2, Function<T2, Promise<R2>> fn2, @NotNull Function<? super T, T3> getter3, Function<T3, Promise<R3>> fn3, @NotNull Function<? super T, T4> getter4, Function<T4, Promise<R4>> fn4, @NotNull Function<? super T, T5> getter5, Function<T5, Promise<R5>> fn5, @NotNull Function<? super T, T6> getter6, Function<T6, Promise<R6>> fn6) {
        return t -> Promises.toTuple(constructor, (Promise)fn1.apply(getter1.apply(t)), (Promise)fn2.apply(getter2.apply(t)), (Promise)fn3.apply(getter3.apply(t)), (Promise)fn4.apply(getter4.apply(t)), (Promise)fn5.apply(getter5.apply(t)), (Promise)fn6.apply(getter6.apply(t)));
    }

    @NotNull
    public static Promise<Void> sequence() {
        return Promise.complete();
    }

    @NotNull
    public static Promise<Void> sequence(@NotNull AsyncRunnable runnable) {
        return runnable.run();
    }

    @NotNull
    public static Promise<Void> sequence(@NotNull AsyncRunnable runnable1, @NotNull AsyncRunnable runnable2) {
        return runnable1.run().then(runnable2::run);
    }

    @NotNull
    public static Promise<Void> sequence(AsyncRunnable ... runnables) {
        return Promises.sequence(Arrays.asList(runnables));
    }

    @NotNull
    public static Promise<Void> sequence(@NotNull Iterable<? extends AsyncRunnable> runnables) {
        return Promises.sequence(Utils.transformIterator(runnables.iterator(), AsyncRunnable::run));
    }

    @NotNull
    public static Promise<Void> sequence(@NotNull Stream<? extends AsyncRunnable> runnables) {
        return Promises.sequence(Utils.transformIterator(runnables.iterator(), AsyncRunnable::run));
    }

    @NotNull
    public static Promise<Void> sequence(@NotNull Iterator<? extends Promise<Void>> promises) {
        return Promise.ofCallback(cb -> Promises.sequenceImpl(promises, cb));
    }

    private static void sequenceImpl(@NotNull Iterator<? extends Promise<Void>> promises, SettablePromise<Void> cb) {
        while (promises.hasNext()) {
            Promise<Void> promise = promises.next();
            if (promise.isResult()) continue;
            promise.run((Callback<Void>)((Callback)(result, e) -> {
                if (e == null) {
                    Promises.sequenceImpl(promises, cb);
                } else {
                    cb.setException(e);
                }
            }));
            return;
        }
        cb.set(null);
    }

    @SafeVarargs
    @NotNull
    public static <T> Promise<T> first(AsyncSupplier<? extends T> ... promises) {
        return Promises.first(PromisePredicates.isResult(), promises);
    }

    @NotNull
    public static <T> Promise<T> first(@NotNull Iterable<? extends AsyncSupplier<? extends T>> promises) {
        return Promises.first(PromisePredicates.isResult(), promises);
    }

    @NotNull
    public static <T> Promise<T> first(@NotNull Stream<? extends AsyncSupplier<? extends T>> promises) {
        return Promises.first(PromisePredicates.isResult(), promises);
    }

    @NotNull
    public static <T> Promise<T> first(@NotNull Iterator<? extends Promise<? extends T>> promises) {
        return Promises.first(PromisePredicates.isResult(), promises);
    }

    @SafeVarargs
    @NotNull
    public static <T> Promise<T> first(@NotNull BiPredicate<? super T, ? super Exception> predicate, AsyncSupplier<? extends T> ... promises) {
        return Promises.first(predicate, Arrays.asList(promises));
    }

    @NotNull
    public static <T> Promise<T> first(@NotNull BiPredicate<? super T, ? super Exception> predicate, @NotNull Iterable<? extends AsyncSupplier<? extends T>> promises) {
        return Promises.first(predicate, Promises.asPromises(promises));
    }

    @NotNull
    public static <T> Promise<T> first(@NotNull BiPredicate<? super T, ? super Exception> predicate, @NotNull Stream<? extends AsyncSupplier<? extends T>> promises) {
        return Promises.first(predicate, Promises.asPromises(promises));
    }

    @NotNull
    public static <T> Promise<T> first(@NotNull BiPredicate<? super T, ? super Exception> predicate, @NotNull Iterator<? extends Promise<? extends T>> promises) {
        return Promise.ofCallback(cb -> Promises.firstImpl(promises, predicate, cb));
    }

    private static <T> void firstImpl(Iterator<? extends Promise<? extends T>> promises, @NotNull BiPredicate<? super T, ? super Exception> predicate, SettablePromise<T> cb) {
        while (promises.hasNext()) {
            Promise<T> nextPromise = promises.next();
            if (nextPromise.isComplete()) {
                Exception e2;
                T v2 = nextPromise.getResult();
                if (predicate.test(v2, e2 = nextPromise.getException())) {
                    cb.accept(v2, e2);
                    return;
                }
                Recyclers.recycle(v2);
                continue;
            }
            nextPromise.run((v, e) -> {
                if (predicate.test(v, e)) {
                    cb.accept(v, e);
                } else {
                    Recyclers.recycle((Object)v);
                    Promises.firstImpl(promises, predicate, cb);
                }
            });
            return;
        }
        cb.setException(new Exception("There are no promises to be complete"));
    }

    @NotNull
    public static Promise<Void> repeat(@NotNull AsyncSupplier<Boolean> supplier) {
        SettablePromise<Void> cb = new SettablePromise<Void>();
        Promises.repeatImpl(supplier, cb);
        return cb;
    }

    private static void repeatImpl(@NotNull AsyncSupplier<Boolean> supplier, SettablePromise<Void> cb) {
        block1: {
            Promise<Boolean> promise;
            while ((promise = supplier.get()).isResult()) {
                if (promise.getResult() == Boolean.TRUE) continue;
                cb.set(null);
                break block1;
            }
            promise.run((Callback<Boolean>)((Callback)(b, e) -> {
                if (e == null) {
                    if (b == Boolean.TRUE) {
                        Promises.repeatImpl(supplier, cb);
                    } else {
                        cb.set(null);
                    }
                } else {
                    cb.setException(e);
                }
            }));
        }
    }

    public static <T> Promise<T> loop(@Nullable T seed, @NotNull Predicate<T> loopCondition, @NotNull FunctionEx<T, Promise<T>> next) {
        if (!loopCondition.test(seed)) {
            return Promise.of(seed);
        }
        return Promises.until(seed, next, v -> !loopCondition.test(v));
    }

    public static <T> Promise<T> until(@Nullable T seed, @NotNull FunctionEx<T, Promise<T>> next, @NotNull Predicate<T> breakCondition) {
        return Promise.ofCallback(cb -> Promises.untilImpl(seed, next, breakCondition, cb));
    }

    private static <T> void untilImpl(@Nullable T value, @NotNull FunctionEx<T, Promise<T>> next, @NotNull Predicate<T> breakCondition, SettablePromise<T> cb) throws Exception {
        block1: {
            Promise promise;
            while ((promise = (Promise)next.apply(value)).isResult()) {
                value = promise.getResult();
                if (!breakCondition.test(value)) continue;
                break block1;
            }
            promise.run((newValue, e) -> {
                if (e == null) {
                    if (breakCondition.test(newValue)) {
                        cb.set(newValue);
                    } else {
                        try {
                            Promises.untilImpl(newValue, next, breakCondition, cb);
                        }
                        catch (Exception ex) {
                            FatalErrorHandlers.handleError((Throwable)ex, (Object)next);
                            cb.setException(ex);
                        }
                    }
                } else {
                    cb.setException(e);
                }
            });
            return;
        }
        cb.set(value);
    }

    public static <T> Promise<T> retry(AsyncSupplier<T> asyncSupplier) {
        return Promises.retry(PromisePredicates.isResult(), asyncSupplier);
    }

    public static <T> Promise<T> retry(BiPredicate<? super T, Exception> breakCondition, AsyncSupplier<T> asyncSupplier) {
        return Promises.first(breakCondition, Stream.generate(() -> asyncSupplier));
    }

    public static <T> Promise<T> retry(AsyncSupplier<T> asyncSupplier, @NotNull RetryPolicy<?> retryPolicy) {
        return Promises.retry(asyncSupplier, (v, e) -> e == null, retryPolicy);
    }

    public static <T> Promise<T> retry(AsyncSupplier<T> asyncSupplier, BiPredicate<T, Exception> breakCondition, @NotNull RetryPolicy<?> retryPolicy) {
        return Promise.ofCallback(cb -> Promises.retryImpl(asyncSupplier, breakCondition, retryPolicy, null, cb));
    }

    private static <T> void retryImpl(@NotNull AsyncSupplier<? extends T> next, BiPredicate<T, Exception> breakCondition, @NotNull RetryPolicy<Object> retryPolicy, Object retryState, SettablePromise<T> cb) {
        next.get().run((v, e) -> {
            if (breakCondition.test(v, e)) {
                cb.accept(v, e);
            } else {
                Object retryStateFinal;
                Eventloop eventloop = Eventloop.getCurrentEventloop();
                long now = eventloop.currentTimeMillis();
                long nextRetryTimestamp = retryPolicy.nextRetryTimestamp(now, e, retryStateFinal = retryState != null ? retryState : retryPolicy.createRetryState());
                if (nextRetryTimestamp == 0L) {
                    cb.setException(e != null ? e : new Exception("RetryPolicy: giving up " + retryState));
                } else {
                    eventloop.schedule(nextRetryTimestamp, RunnableWithContext.wrapContext((Object)cb, () -> Promises.retryImpl(next, breakCondition, retryPolicy, retryStateFinal, cb)));
                }
            }
        });
    }

    @NotNull
    public static <T> Iterator<Promise<T>> asPromises(@NotNull Iterator<? extends AsyncSupplier<? extends T>> tasks) {
        return Utils.transformIterator(tasks, AsyncSupplier::get);
    }

    public static <T> Iterator<Promise<T>> asPromises(@NotNull Stream<? extends AsyncSupplier<? extends T>> tasks) {
        return Promises.asPromises(tasks.iterator());
    }

    public static <T> Iterator<Promise<T>> asPromises(@NotNull Iterable<? extends AsyncSupplier<? extends T>> tasks) {
        return Promises.asPromises(tasks.iterator());
    }

    @SafeVarargs
    public static <T> Iterator<Promise<T>> asPromises(AsyncSupplier<? extends T> ... tasks) {
        return Promises.asPromises(Utils.iteratorOf((Object[])tasks));
    }

    @NotNull
    public static <T, A, R> Promise<R> reduce(@Nullable A accumulator, @NotNull BiConsumerEx<A, T> combiner, @NotNull FunctionEx<A, R> finisher, @NotNull Collection<Promise<T>> promises) {
        return Promises.reduce(accumulator, combiner, finisher, promises.iterator());
    }

    @NotNull
    public static <T, A, R> Promise<R> reduce(@Nullable A accumulator, @NotNull BiConsumerEx<A, T> combiner, @NotNull FunctionEx<A, R> finisher, @NotNull Stream<Promise<T>> promises) {
        return Promises.reduce(accumulator, combiner, finisher, promises.iterator());
    }

    @NotNull
    public static <T, A, R> Promise<R> reduce(@Nullable A accumulator, @NotNull BiConsumerEx<A, T> combiner, @NotNull FunctionEx<A, R> finisher, @NotNull Iterator<Promise<T>> promises) {
        AsyncAccumulator<A> asyncAccumulator = AsyncAccumulator.create(accumulator);
        while (promises.hasNext()) {
            asyncAccumulator.addPromise(promises.next(), combiner);
        }
        return asyncAccumulator.run().map(finisher);
    }

    @NotNull
    public static <T, A, R> Promise<R> reduce(@NotNull Collector<T, A, R> collector, int maxCalls, @NotNull Iterator<Promise<T>> promises) {
        return Promises.reduce(collector.supplier().get(), BiConsumerEx.of(collector.accumulator()), FunctionEx.of(collector.finisher()), maxCalls, promises);
    }

    @NotNull
    public static <T, A, R> Promise<R> reduce(@Nullable A accumulator, @NotNull BiConsumerEx<A, T> combiner, @NotNull FunctionEx<A, R> finisher, int maxCalls, @NotNull Iterator<Promise<T>> promises) {
        AsyncAccumulator<A> asyncAccumulator = AsyncAccumulator.create(accumulator);
        for (int i = 0; promises.hasNext() && i < maxCalls; ++i) {
            Promises.reduceImpl(asyncAccumulator, combiner, promises);
        }
        return asyncAccumulator.run().map(finisher);
    }

    private static <T, A> void reduceImpl(AsyncAccumulator<A> asyncAccumulator, BiConsumerEx<A, T> combiner, Iterator<Promise<T>> promises) {
        while (promises.hasNext()) {
            Promise<T> promise = promises.next();
            if (promise.isComplete()) {
                asyncAccumulator.addPromise(promise, combiner);
                continue;
            }
            asyncAccumulator.addPromise(promise.whenResult(() -> Promises.reduceImpl(asyncAccumulator, combiner, promises)), combiner);
            break;
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <T, A, R> AsyncFunction<T, R> coalesce(@NotNull Supplier<A> argumentAccumulatorSupplier, @NotNull BiConsumer<A, T> argumentAccumulatorFn, @NotNull AsyncFunction<A, R> fn) {
        AsyncBuffer buffer = new AsyncBuffer(fn, argumentAccumulatorSupplier);
        return v -> {
            Promise promise = buffer.add(argumentAccumulatorFn, v);
            if (!buffer.isActive()) {
                Promises.repeat(() -> buffer.flush().map($ -> buffer.isBuffered()));
            }
            return promise;
        };
    }

    private static final class PromiseAll<T>
    extends NextPromise<T, Void> {
        int countdown = 1;

        private PromiseAll() {
        }

        public void accept(@Nullable T result, @Nullable Exception e) {
            if (e == null) {
                Recyclers.recycle(result);
                if (--this.countdown == 0) {
                    this.complete(null);
                }
            } else {
                this.tryCompleteExceptionally(e);
            }
        }

        @Override
        protected String describe() {
            return "Promises.all()";
        }
    }

    private static final class PromiseAny<T>
    extends NextPromise<T, T> {
        private final BiPredicate<? super T, ? super Exception> predicate;
        int countdown = 1;

        private PromiseAny(BiPredicate<? super T, ? super Exception> predicate) {
            this.predicate = predicate;
        }

        public void accept(@Nullable T result, @Nullable Exception e) {
            if (this.predicate.test(result, e)) {
                if (!this.tryComplete(result, e)) {
                    Recyclers.recycle(result);
                }
            } else {
                Recyclers.recycle(result);
                if (--this.countdown == 0) {
                    this.completeExceptionally(new Exception("There are no promises to be complete"));
                }
            }
        }

        @Override
        protected String describe() {
            return "Promises.any()";
        }
    }

    private static final class PromisesToList<T>
    extends AbstractPromise<List<T>> {
        Object[] array;
        int countdown;
        int size;

        private PromisesToList(int initialSize) {
            this.array = new Object[initialSize];
        }

        private void addToList(int i, Promise<? extends T> promise) {
            this.ensureSize(i + 1);
            if (promise.isResult()) {
                if (!this.isComplete()) {
                    this.array[i] = promise.getResult();
                } else {
                    Recyclers.recycle((Object)this.result);
                }
            } else if (promise.isException()) {
                if (this.tryCompleteExceptionally(promise.getException())) {
                    Recyclers.recycle((Object)this.array);
                }
            } else {
                ++this.countdown;
                promise.run((result, e) -> {
                    if (e == null) {
                        if (!this.isComplete()) {
                            this.array[i] = result;
                            if (--this.countdown == 0) {
                                this.complete(this.getList());
                            }
                        } else {
                            Recyclers.recycle((Object)result);
                        }
                    } else if (this.tryCompleteExceptionally(e)) {
                        Recyclers.recycle((Object)this.array);
                    }
                });
            }
        }

        private void ensureSize(int size) {
            this.size = size;
            if (size >= this.array.length) {
                this.array = Arrays.copyOf(this.array, this.array.length * 2);
            }
        }

        private List<T> getList() {
            return Arrays.asList(this.size == this.array.length ? this.array : Arrays.copyOf(this.array, this.size));
        }

        @Override
        protected String describe() {
            return "Promises.toList()";
        }
    }
}

