/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.Callback;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.promise.AbstractPromise;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SettablePromise<T>
extends AbstractPromise<T>
implements Callback<T> {
    public void accept(T result, @Nullable Exception e) {
        if (e == null) {
            this.set(result);
        } else {
            this.setException(e);
        }
    }

    @Async.Execute
    public void set(T result) {
        this.complete(result);
    }

    @Async.Execute
    public void setException(@NotNull Exception e) {
        this.completeExceptionally(e);
    }

    @Async.Execute
    public boolean trySet(T result) {
        if (!this.isComplete()) {
            this.set(result);
            return true;
        }
        return false;
    }

    @Async.Execute
    public boolean trySetException(@NotNull Exception e) {
        if (!this.isComplete()) {
            this.setException(e);
            return true;
        }
        return false;
    }

    @Async.Execute
    public boolean trySet(T result, @Nullable Exception e) {
        if (!this.isComplete()) {
            if (e == null) {
                this.set(result);
            } else {
                this.setException(e);
            }
            return true;
        }
        return false;
    }

    public void post(T result) {
        Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext((Object)this, () -> this.set(result)));
    }

    public void postException(@NotNull Exception e) {
        Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext((Object)this, () -> this.setException(e)));
    }

    public void post(T result, @Nullable Exception e) {
        Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext((Object)this, () -> this.accept(result, e)));
    }

    public void tryPost(T result) {
        Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext((Object)this, () -> this.trySet(result)));
    }

    public void tryPostException(@NotNull Exception e) {
        Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext((Object)this, () -> this.trySetException(e)));
    }

    public void tryPost(T result, @Nullable Exception e) {
        Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext((Object)this, () -> this.trySet(result, e)));
    }

    @Override
    public String describe() {
        return "SettablePromise";
    }
}

