/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.jmx;

import io.activej.common.time.CurrentTimeProvider;
import io.activej.jmx.api.attribute.JmxAttribute;
import java.time.Duration;
import java.time.Instant;
import org.jetbrains.annotations.Nullable;

public final class RpcConnectStats {
    private final CurrentTimeProvider now;
    private long successfulConnects;
    private long failedConnects;
    private int reconnectAttempts;
    private long connectionLostAt;

    public RpcConnectStats(CurrentTimeProvider now) {
        this.now = now;
    }

    public void reset() {
        this.failedConnects = 0L;
        this.successfulConnects = 0L;
        this.reconnectAttempts = 0;
        this.connectionLostAt = -1L;
    }

    public void recordSuccessfulConnect() {
        ++this.successfulConnects;
        this.reconnectAttempts = 0;
        this.connectionLostAt = -1L;
    }

    public void recordFailedConnect() {
        ++this.failedConnects;
        if (this.connectionLostAt == -1L) {
            this.connectionLostAt = this.now.currentTimeMillis();
        } else {
            ++this.reconnectAttempts;
        }
    }

    @JmxAttribute
    public long getSuccessfulConnects() {
        return this.successfulConnects;
    }

    @JmxAttribute
    public long getFailedConnects() {
        return this.failedConnects;
    }

    @JmxAttribute
    public boolean isConnected() {
        return this.connectionLostAt == -1L;
    }

    @JmxAttribute
    @Nullable
    public Duration getConnectionLostFor() {
        if (this.connectionLostAt == -1L) {
            return null;
        }
        return Duration.ofMillis(this.now.currentTimeMillis() - this.connectionLostAt);
    }

    @JmxAttribute
    @Nullable
    public Instant getConnectionLostAt() {
        if (this.connectionLostAt == -1L) {
            return null;
        }
        return Instant.ofEpochMilli(this.connectionLostAt);
    }

    @JmxAttribute
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }
}

