/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.jmx;

import io.activej.common.initializer.WithInitializer;
import io.activej.jmx.api.JmxRefreshable;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.ExceptionStats;
import io.activej.jmx.stats.JmxHistogram;
import io.activej.jmx.stats.ValueStats;
import java.time.Duration;

public final class RpcRequestStats
implements JmxRefreshable,
WithInitializer<RpcRequestStats> {
    private final EventStats totalRequests;
    private final EventStats failedRequests;
    private final EventStats rejectedRequests;
    private final EventStats expiredRequests;
    private final ValueStats responseTime;
    private final ValueStats overdues;
    private final ExceptionStats serverExceptions;

    private RpcRequestStats(Duration smoothingWindow) {
        this.totalRequests = EventStats.create((Duration)smoothingWindow);
        this.failedRequests = EventStats.create((Duration)smoothingWindow);
        this.rejectedRequests = EventStats.create((Duration)smoothingWindow);
        this.expiredRequests = EventStats.create((Duration)smoothingWindow);
        this.responseTime = ValueStats.create((Duration)smoothingWindow).withHistogram(JmxHistogram.POWERS_OF_TWO).withUnit("milliseconds");
        this.overdues = ValueStats.create((Duration)smoothingWindow).withHistogram(JmxHistogram.POWERS_OF_TWO).withRate().withUnit("milliseconds");
        this.serverExceptions = ExceptionStats.create();
    }

    public static RpcRequestStats create(Duration smoothingWindow) {
        return new RpcRequestStats(smoothingWindow);
    }

    public void refresh(long timestamp) {
        this.totalRequests.refresh(timestamp);
        this.failedRequests.refresh(timestamp);
        this.rejectedRequests.refresh(timestamp);
        this.expiredRequests.refresh(timestamp);
        this.responseTime.refresh(timestamp);
        this.overdues.refresh(timestamp);
    }

    @JmxAttribute(extraSubAttributes={"totalCount"})
    public EventStats getTotalRequests() {
        return this.totalRequests;
    }

    @JmxAttribute(extraSubAttributes={"totalCount"})
    public EventStats getFailedRequests() {
        return this.failedRequests;
    }

    @JmxAttribute(extraSubAttributes={"totalCount"})
    public EventStats getRejectedRequests() {
        return this.rejectedRequests;
    }

    @JmxAttribute(extraSubAttributes={"totalCount"})
    public EventStats getExpiredRequests() {
        return this.expiredRequests;
    }

    @JmxAttribute(description="delay between successful or failed request/response (in milliseconds)", extraSubAttributes={"histogram"})
    public ValueStats getResponseTime() {
        return this.responseTime;
    }

    @JmxAttribute(description="difference between due time and actual time of passing response to callback for successful or failed requests", extraSubAttributes={"histogram"})
    public ValueStats getOverdues() {
        return this.overdues;
    }

    @JmxAttribute
    public ExceptionStats getServerExceptions() {
        return this.serverExceptions;
    }
}

