/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.async.callback.Callback;
import io.activej.rpc.client.sender.DiscoveryService;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CombinedDiscoveryService
implements DiscoveryService {
    private final Map<DiscoveryService, Map<Object, InetSocketAddress>> discovered = new IdentityHashMap<DiscoveryService, Map<Object, InetSocketAddress>>();
    private final int discoveryServicesSize;
    private final Set<Callback<Map<Object, InetSocketAddress>>> callbacks = new HashSet<Callback<Map<Object, InetSocketAddress>>>();
    private Map<Object, InetSocketAddress> totalDiscovered = new HashMap<Object, InetSocketAddress>();
    private Exception error;

    CombinedDiscoveryService(List<DiscoveryService> discoveryServices) {
        this.discoveryServicesSize = discoveryServices.size();
        for (DiscoveryService discoveryService : discoveryServices) {
            this.doDiscover(discoveryService);
        }
    }

    @Override
    public void discover(@Nullable Map<Object, InetSocketAddress> previous, Callback<Map<Object, InetSocketAddress>> cb) {
        if (this.error != null) {
            cb.accept(null, this.error);
        }
        if (this.discovered.size() == this.discoveryServicesSize && !this.totalDiscovered.equals(previous)) {
            cb.accept(this.totalDiscovered, null);
        }
        this.callbacks.add(cb);
    }

    private void doDiscover(DiscoveryService discoveryService) {
        discoveryService.discover(this.discovered.get(discoveryService), (Callback<Map<Object, InetSocketAddress>>)((Callback)(result, e) -> {
            if (this.error != null) {
                return;
            }
            if (e == null) {
                this.onDiscover(discoveryService, (Map<Object, InetSocketAddress>)result);
            } else {
                this.onError(e);
            }
        }));
    }

    private void onError(@NotNull Exception e) {
        this.error = e;
        this.completeCallbacks();
    }

    private void onDiscover(DiscoveryService discoveryService, Map<Object, InetSocketAddress> discovered) {
        Map<Object, InetSocketAddress> old = this.discovered.put(discoveryService, discovered);
        HashMap<Object, InetSocketAddress> newTotalDiscovered = new HashMap<Object, InetSocketAddress>(this.totalDiscovered);
        if (old != null) {
            newTotalDiscovered.keySet().removeAll(old.keySet());
        }
        newTotalDiscovered.putAll(discovered);
        this.totalDiscovered = Collections.unmodifiableMap(newTotalDiscovered);
        if (discovered.size() == this.discoveryServicesSize) {
            this.completeCallbacks();
        }
    }

    private void completeCallbacks() {
        HashSet<Callback<Map<Object, InetSocketAddress>>> callbacks = new HashSet<Callback<Map<Object, InetSocketAddress>>>(this.callbacks);
        this.callbacks.clear();
        if (this.error != null) {
            callbacks.forEach(cb -> cb.accept(null, this.error));
        } else {
            callbacks.forEach(cb -> cb.accept(this.totalDiscovered, this.error));
        }
    }
}

