/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.async.callback.Callback;
import io.activej.rpc.client.RpcClientConnectionPool;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcSender;
import io.activej.rpc.client.sender.RpcStrategy;
import io.activej.rpc.client.sender.RpcStrategyList;
import io.activej.rpc.client.sender.RpcStrategyListFinal;
import io.activej.rpc.client.sender.RpcStrategySingleServer;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class DiscoverableRpcStrategyList
implements RpcStrategyList {
    private final DiscoveryService discoveryService;
    private RpcStrategyListFinal list;
    private Map<Object, InetSocketAddress> previouslyDiscovered = new HashMap<Object, InetSocketAddress>();

    private DiscoverableRpcStrategyList(RpcStrategyListFinal list, DiscoveryService discoveryService) {
        this.list = list;
        this.discoveryService = discoveryService;
    }

    static DiscoverableRpcStrategyList create(DiscoveryService discoveryService) {
        RpcStrategyListFinal strategyList = new RpcStrategyListFinal(Collections.emptyList());
        DiscoverableRpcStrategyList list = new DiscoverableRpcStrategyList(strategyList, discoveryService);
        list.rediscover();
        return list;
    }

    private void rediscover() {
        this.discoveryService.discover(this.previouslyDiscovered, (Callback<Map<Object, InetSocketAddress>>)((Callback)(result, e) -> {
            if (e != null) {
                throw new RuntimeException("Failed to discover addresses", e);
            }
            this.previouslyDiscovered = result;
            this.list = DiscoverableRpcStrategyList.toStrategyList(result.values());
            this.rediscover();
        }));
    }

    @Override
    public List<RpcSender> listOfSenders(RpcClientConnectionPool pool) {
        return this.list.listOfSenders(pool);
    }

    @Override
    public List<RpcSender> listOfNullableSenders(RpcClientConnectionPool pool) {
        return this.list.listOfNullableSenders(pool);
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public RpcStrategy get(int index) {
        return this.list.get(index);
    }

    private static RpcStrategyListFinal toStrategyList(Collection<InetSocketAddress> addresses) {
        return new RpcStrategyListFinal(addresses.stream().map(RpcStrategySingleServer::create).collect(Collectors.toList()));
    }
}

