/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.async.callback.Callback;
import io.activej.common.Checks;
import io.activej.rpc.client.RpcClientConnectionPool;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcSender;
import io.activej.rpc.client.sender.RpcStrategy;
import io.activej.rpc.client.sender.RpcStrategyRendezvousHashing;
import io.activej.rpc.client.sender.RpcStrategySingleServer;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

final class DiscoverableRpcStrategyRendezvousHashing
implements RpcStrategy {
    private final DiscoveryService discoveryService;
    private final RpcStrategyRendezvousHashing rendezvousHashing;

    private DiscoverableRpcStrategyRendezvousHashing(RpcStrategyRendezvousHashing rendezvousHashing, DiscoveryService discoveryService) {
        this.rendezvousHashing = rendezvousHashing;
        this.discoveryService = discoveryService;
    }

    static DiscoverableRpcStrategyRendezvousHashing create(DiscoveryService discoveryService, RpcStrategyRendezvousHashing rendezvousHashing) {
        Checks.checkArgument((boolean)rendezvousHashing.getShards().isEmpty(), (Object)"Rendezvous hashing strategy should not contain any partition");
        DiscoverableRpcStrategyRendezvousHashing list = new DiscoverableRpcStrategyRendezvousHashing(rendezvousHashing, discoveryService);
        list.rediscover();
        return list;
    }

    private void rediscover() {
        Map<Object, InetSocketAddress> previouslyDiscovered = this.rendezvousHashing.getShards().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RpcStrategySingleServer)e.getValue()).getAddress()));
        this.discoveryService.discover(previouslyDiscovered, (Callback<Map<Object, InetSocketAddress>>)((Callback)(result, e) -> {
            if (e != null) {
                throw new RuntimeException("Failed to discover addresses", e);
            }
            Map<Object, RpcStrategy> newStrategies = result.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> RpcStrategySingleServer.create((InetSocketAddress)entry.getValue())));
            this.rendezvousHashing.setShards(newStrategies);
            this.rediscover();
        }));
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    @Override
    @Nullable
    public RpcSender createSender(RpcClientConnectionPool pool) {
        return this.rendezvousHashing.createSender(pool);
    }
}

