/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.common.Checks;
import io.activej.rpc.client.sender.DiscoverableRpcStrategyRendezvousHashing;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcStrategy;
import io.activej.rpc.client.sender.RpcStrategyFirstAvailable;
import io.activej.rpc.client.sender.RpcStrategyFirstValidResult;
import io.activej.rpc.client.sender.RpcStrategyList;
import io.activej.rpc.client.sender.RpcStrategyRandomSampling;
import io.activej.rpc.client.sender.RpcStrategyRendezvousHashing;
import io.activej.rpc.client.sender.RpcStrategyRoundRobin;
import io.activej.rpc.client.sender.RpcStrategySharding;
import io.activej.rpc.client.sender.RpcStrategySingleServer;
import io.activej.rpc.client.sender.RpcStrategyTypeDispatching;
import io.activej.rpc.hash.HashFunction;
import io.activej.rpc.hash.ShardingFunction;
import io.activej.rpc.protocol.RpcException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class RpcStrategies {
    static final RpcException NO_SENDER_AVAILABLE_EXCEPTION = new RpcException("No senders available");

    public static RpcStrategySingleServer server(@NotNull InetSocketAddress address) {
        return RpcStrategySingleServer.create(address);
    }

    public static RpcStrategyList servers(InetSocketAddress ... addresses) {
        return RpcStrategies.servers(Arrays.asList(addresses));
    }

    public static RpcStrategyList servers(List<InetSocketAddress> addresses) {
        return RpcStrategyList.ofAddresses(addresses);
    }

    public static RpcStrategyList servers(DiscoveryService discoveryService) {
        return RpcStrategyList.ofDiscoveryService(discoveryService);
    }

    public static RpcStrategyFirstAvailable firstAvailable(RpcStrategy ... senders) {
        return RpcStrategies.firstAvailable(Arrays.asList(senders));
    }

    public static RpcStrategyFirstAvailable firstAvailable(List<RpcStrategy> strategies) {
        return RpcStrategyFirstAvailable.create(RpcStrategyList.ofStrategies(strategies));
    }

    public static RpcStrategyFirstAvailable firstAvailable(RpcStrategyList list) {
        return RpcStrategyFirstAvailable.create(list);
    }

    public static RpcStrategyFirstValidResult firstValidResult(RpcStrategy ... senders) {
        return RpcStrategies.firstValidResult(Arrays.asList(senders));
    }

    public static RpcStrategyFirstValidResult firstValidResult(List<RpcStrategy> senders) {
        return RpcStrategyFirstValidResult.create(RpcStrategyList.ofStrategies(senders));
    }

    public static RpcStrategyFirstValidResult firstValidResult(RpcStrategyList list) {
        return RpcStrategyFirstValidResult.create(list);
    }

    public static RpcStrategyRoundRobin roundRobin(RpcStrategy ... senders) {
        return RpcStrategies.roundRobin(Arrays.asList(senders));
    }

    public static RpcStrategyRoundRobin roundRobin(List<RpcStrategy> senders) {
        return RpcStrategyRoundRobin.create(RpcStrategyList.ofStrategies(senders));
    }

    public static RpcStrategyRoundRobin roundRobin(RpcStrategyList list) {
        return RpcStrategyRoundRobin.create(list);
    }

    public static RpcStrategySharding sharding(ShardingFunction<?> hashFunction, RpcStrategy ... senders) {
        return RpcStrategies.sharding(hashFunction, Arrays.asList(senders));
    }

    public static RpcStrategySharding sharding(@NotNull ShardingFunction<?> hashFunction, @NotNull List<RpcStrategy> senders) {
        Checks.checkArgument((!senders.isEmpty() ? 1 : 0) != 0, (Object)"At least one sender must be present");
        return RpcStrategySharding.create(hashFunction, RpcStrategyList.ofStrategies(senders));
    }

    public static RpcStrategySharding sharding(@NotNull ShardingFunction<?> hashFunction, @NotNull RpcStrategyList list) {
        return RpcStrategySharding.create(hashFunction, list);
    }

    public static RpcStrategyRendezvousHashing rendezvousHashing(@NotNull HashFunction<?> hashFunction) {
        return RpcStrategyRendezvousHashing.create(hashFunction);
    }

    public static DiscoverableRpcStrategyRendezvousHashing rendezvousHashing(DiscoveryService discoveryService, RpcStrategyRendezvousHashing originalStrategy) {
        return DiscoverableRpcStrategyRendezvousHashing.create(discoveryService, originalStrategy);
    }

    public static RpcStrategyTypeDispatching typeDispatching() {
        return RpcStrategyTypeDispatching.create();
    }

    public static RpcStrategyRandomSampling randomSampling() {
        return RpcStrategyRandomSampling.create();
    }
}

