/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.async.callback.Callback;
import io.activej.rpc.client.RpcClientConnectionPool;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcSender;
import io.activej.rpc.client.sender.RpcStrategy;
import io.activej.rpc.client.sender.RpcStrategyList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RpcStrategyFirstValidResult
implements RpcStrategy {
    private static final ResultValidator<?> DEFAULT_RESULT_VALIDATOR = new DefaultResultValidator();
    private final RpcStrategyList list;
    private final ResultValidator<?> resultValidator;
    @Nullable
    private final Exception noValidResultException;

    private RpcStrategyFirstValidResult(RpcStrategyList list, ResultValidator<?> resultValidator, @Nullable Exception noValidResultException) {
        this.list = list;
        this.resultValidator = resultValidator;
        this.noValidResultException = noValidResultException;
    }

    public static RpcStrategyFirstValidResult create(RpcStrategyList list) {
        return new RpcStrategyFirstValidResult(list, DEFAULT_RESULT_VALIDATOR, null);
    }

    public RpcStrategyFirstValidResult withResultValidator(@NotNull ResultValidator<?> resultValidator) {
        return new RpcStrategyFirstValidResult(this.list, resultValidator, this.noValidResultException);
    }

    public RpcStrategyFirstValidResult withNoValidResultException(@NotNull Exception e) {
        return new RpcStrategyFirstValidResult(this.list, this.resultValidator, e);
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return this.list.getDiscoveryService();
    }

    @Override
    @Nullable
    public RpcSender createSender(RpcClientConnectionPool pool) {
        List<RpcSender> senders = this.list.listOfSenders(pool);
        if (senders.isEmpty()) {
            return null;
        }
        return new Sender(senders, this.resultValidator, this.noValidResultException);
    }

    @FunctionalInterface
    public static interface ResultValidator<T> {
        public boolean isValidResult(T var1);
    }

    static final class Sender
    implements RpcSender {
        private final RpcSender[] subSenders;
        private final ResultValidator<?> resultValidator;
        @Nullable
        private final Exception noValidResultException;

        Sender(@NotNull List<RpcSender> senders, @NotNull ResultValidator<?> resultValidator, @Nullable Exception noValidResultException) {
            assert (!senders.isEmpty());
            this.subSenders = senders.toArray(new RpcSender[0]);
            this.resultValidator = resultValidator;
            this.noValidResultException = noValidResultException;
        }

        @Override
        public <I, O> void sendRequest(I request, int timeout, @NotNull Callback<O> cb) {
            FirstResultCallback firstResultCallback = new FirstResultCallback(this.subSenders.length, this.resultValidator, cb, this.noValidResultException);
            for (RpcSender sender : this.subSenders) {
                sender.sendRequest(request, timeout, firstResultCallback);
            }
        }
    }

    private static final class DefaultResultValidator<T>
    implements ResultValidator<T> {
        private DefaultResultValidator() {
        }

        @Override
        public boolean isValidResult(T input) {
            return input != null;
        }
    }

    static final class FirstResultCallback<T>
    implements Callback<T> {
        private int expectedCalls;
        private final ResultValidator<T> resultValidator;
        private final Callback<T> resultCallback;
        private Exception lastException;
        @Nullable
        private final Exception noValidResultException;

        FirstResultCallback(int expectedCalls, @NotNull ResultValidator<T> resultValidator, @NotNull Callback<T> resultCallback, @Nullable Exception noValidResultException) {
            assert (expectedCalls > 0);
            this.expectedCalls = expectedCalls;
            this.resultCallback = resultCallback;
            this.resultValidator = resultValidator;
            this.noValidResultException = noValidResultException;
        }

        public void accept(T result, @Nullable Exception e) {
            if (e == null) {
                if (--this.expectedCalls >= 0) {
                    if (this.resultValidator.isValidResult(result)) {
                        this.expectedCalls = 0;
                        this.resultCallback.accept(result, null);
                    } else if (this.expectedCalls == 0) {
                        this.resultCallback.accept(null, this.lastException != null ? this.lastException : this.noValidResultException);
                    }
                }
            } else {
                this.lastException = e;
                if (--this.expectedCalls == 0) {
                    this.resultCallback.accept(null, this.lastException);
                }
            }
        }
    }
}

