/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.common.Checks;
import io.activej.rpc.client.RpcClientConnectionPool;
import io.activej.rpc.client.sender.DiscoverableRpcStrategyList;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcSender;
import io.activej.rpc.client.sender.RpcStrategy;
import io.activej.rpc.client.sender.RpcStrategyListFinal;
import io.activej.rpc.client.sender.RpcStrategySingleServer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface RpcStrategyList {
    public List<RpcSender> listOfSenders(RpcClientConnectionPool var1);

    public List<RpcSender> listOfNullableSenders(RpcClientConnectionPool var1);

    public DiscoveryService getDiscoveryService();

    public int size();

    public RpcStrategy get(int var1);

    public static RpcStrategyList ofDiscoveryService(DiscoveryService discoveryService) {
        return DiscoverableRpcStrategyList.create(discoveryService);
    }

    public static RpcStrategyList ofAddresses(@NotNull List<InetSocketAddress> addresses) {
        Checks.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"At least one address must be present");
        return new RpcStrategyListFinal(addresses.stream().map(RpcStrategySingleServer::create).collect(Collectors.toList()));
    }

    public static RpcStrategyList ofStrategies(List<? extends RpcStrategy> strategies) {
        return new RpcStrategyListFinal(new ArrayList<RpcStrategy>(strategies));
    }
}

