/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.rpc.client.RpcClientConnectionPool;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcSender;
import io.activej.rpc.client.sender.RpcStrategy;
import io.activej.rpc.client.sender.RpcStrategyList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class RpcStrategyListFinal
implements RpcStrategyList {
    private final List<? extends RpcStrategy> strategies;

    RpcStrategyListFinal(List<? extends RpcStrategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public List<RpcSender> listOfSenders(RpcClientConnectionPool pool) {
        return this.strategies.stream().map(strategy -> strategy.createSender(pool)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<RpcSender> listOfNullableSenders(RpcClientConnectionPool pool) {
        return this.strategies.stream().map(strategy -> strategy.createSender(pool)).collect(Collectors.toList());
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return DiscoveryService.combined(this.strategies.stream().map(RpcStrategy::getDiscoveryService).collect(Collectors.toList()));
    }

    @Override
    public int size() {
        return this.strategies.size();
    }

    @Override
    public RpcStrategy get(int index) {
        return this.strategies.get(index);
    }

    public List<RpcStrategy> getStrategies() {
        return Collections.unmodifiableList(this.strategies);
    }
}

