/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.async.callback.Callback;
import io.activej.common.Checks;
import io.activej.rpc.client.RpcClientConnectionPool;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcSender;
import io.activej.rpc.client.sender.RpcStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class RpcStrategyRandomSampling
implements RpcStrategy {
    private final Random random = new Random();
    private final Map<RpcStrategy, Integer> strategyToWeight = new HashMap<RpcStrategy, Integer>();

    private RpcStrategyRandomSampling() {
    }

    public static RpcStrategyRandomSampling create() {
        return new RpcStrategyRandomSampling();
    }

    public RpcStrategyRandomSampling add(int weight, RpcStrategy strategy) {
        Checks.checkArgument((weight >= 0 ? 1 : 0) != 0, (Object)"weight cannot be negative");
        Checks.checkArgument((!this.strategyToWeight.containsKey(strategy) ? 1 : 0) != 0, (Object)"withStrategy is already added");
        this.strategyToWeight.put(strategy, weight);
        return this;
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return DiscoveryService.combined(this.strategyToWeight.keySet().stream().map(RpcStrategy::getDiscoveryService).collect(Collectors.toList()));
    }

    @Override
    public RpcSender createSender(RpcClientConnectionPool pool) {
        HashMap<RpcSender, Integer> senderToWeight = new HashMap<RpcSender, Integer>();
        int totalWeight = 0;
        for (Map.Entry<RpcStrategy, Integer> entry : this.strategyToWeight.entrySet()) {
            RpcSender sender = entry.getKey().createSender(pool);
            if (sender == null) continue;
            int weight = entry.getValue();
            senderToWeight.put(sender, weight);
            totalWeight += weight;
        }
        if (totalWeight == 0) {
            return null;
        }
        long randomLong = this.random.nextLong();
        long seed = randomLong != 0L ? randomLong : 2347230858016798896L;
        return new RandomSamplingSender(senderToWeight, seed);
    }

    private static final class RandomSamplingSender
    implements RpcSender {
        private final List<RpcSender> senders;
        private final int[] cumulativeWeights;
        private final int totalWeight;
        private long lastRandomLong;

        RandomSamplingSender(Map<RpcSender, Integer> senderToWeight, long seed) {
            assert (!senderToWeight.containsKey(null));
            this.senders = new ArrayList<RpcSender>(senderToWeight.size());
            this.cumulativeWeights = new int[senderToWeight.size()];
            int currentCumulativeWeight = 0;
            int currentSender = 0;
            for (Map.Entry<RpcSender, Integer> entry : senderToWeight.entrySet()) {
                this.senders.add(entry.getKey());
                this.cumulativeWeights[currentSender++] = currentCumulativeWeight += entry.getValue().intValue();
            }
            this.totalWeight = currentCumulativeWeight;
            this.lastRandomLong = seed;
        }

        @Override
        public <I, O> void sendRequest(I request, int timeout, @NotNull Callback<O> cb) {
            this.lastRandomLong ^= this.lastRandomLong << 21;
            this.lastRandomLong ^= this.lastRandomLong >>> 35;
            this.lastRandomLong ^= this.lastRandomLong << 4;
            int currentRandomValue = (int)((this.lastRandomLong & Long.MAX_VALUE) % (long)this.totalWeight);
            int lowerIndex = 0;
            int upperIndex = this.cumulativeWeights.length;
            while (lowerIndex != upperIndex) {
                int middle = (lowerIndex + upperIndex) / 2;
                if (currentRandomValue >= this.cumulativeWeights[middle]) {
                    lowerIndex = middle + 1;
                    continue;
                }
                upperIndex = middle;
            }
            this.senders.get(lowerIndex).sendRequest(request, timeout, cb);
        }
    }
}

