/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.async.callback.Callback;
import io.activej.common.Checks;
import io.activej.common.HashUtils;
import io.activej.common.Utils;
import io.activej.rpc.client.RpcClientConnectionPool;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcSender;
import io.activej.rpc.client.sender.RpcStrategy;
import io.activej.rpc.client.sender.RpcStrategySingleServer;
import io.activej.rpc.hash.HashBucketFunction;
import io.activej.rpc.hash.HashFunction;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class RpcStrategyRendezvousHashing
implements RpcStrategy {
    private static final int MIN_SUB_STRATEGIES_FOR_CREATION_DEFAULT = 1;
    private static final int DEFAULT_BUCKET_CAPACITY = 2048;
    private static final HashBucketFunction DEFAULT_BUCKET_HASH_FUNCTION = new DefaultHashBucketFunction();
    private final Map<Object, RpcStrategy> shards;
    private final HashFunction<?> hashFunction;
    private final int minShards;
    private final HashBucketFunction hashBucketFunction;
    private final int buckets;

    private RpcStrategyRendezvousHashing(@NotNull HashFunction<?> hashFunction, int minShards, @NotNull HashBucketFunction hashBucketFunction, int buckets, Map<Object, RpcStrategy> shards) {
        this.hashFunction = hashFunction;
        this.minShards = minShards;
        this.hashBucketFunction = hashBucketFunction;
        this.buckets = buckets;
        this.shards = shards;
    }

    public static RpcStrategyRendezvousHashing create(HashFunction<?> hashFunction) {
        return new RpcStrategyRendezvousHashing(hashFunction, 1, DEFAULT_BUCKET_HASH_FUNCTION, 2048, new HashMap<Object, RpcStrategy>());
    }

    public RpcStrategyRendezvousHashing withMinActiveShards(int minShards) {
        Checks.checkArgument((minShards > 0 ? 1 : 0) != 0, (Object)"minSubStrategiesForCreation must be greater than 0");
        return new RpcStrategyRendezvousHashing(this.hashFunction, minShards, this.hashBucketFunction, this.buckets, this.shards);
    }

    public RpcStrategyRendezvousHashing withHashBucketFunction(HashBucketFunction hashBucketFunction) {
        return new RpcStrategyRendezvousHashing(this.hashFunction, this.minShards, hashBucketFunction, this.buckets, this.shards);
    }

    public RpcStrategyRendezvousHashing withHashBuckets(int buckets) {
        Checks.checkArgument(((buckets & buckets - 1) == 0 ? 1 : 0) != 0, (String)"Buckets number must be a power-of-two, got %d", (Object[])new Object[]{buckets});
        return new RpcStrategyRendezvousHashing(this.hashFunction, this.minShards, this.hashBucketFunction, buckets, this.shards);
    }

    public RpcStrategyRendezvousHashing withShard(Object shardId, @NotNull RpcStrategy strategy) {
        this.shards.put(shardId, strategy);
        return this;
    }

    public RpcStrategyRendezvousHashing withShards(InetSocketAddress ... addresses) {
        return this.withShards(Arrays.asList(addresses));
    }

    public RpcStrategyRendezvousHashing withShards(List<InetSocketAddress> addresses) {
        for (InetSocketAddress address : addresses) {
            this.shards.put(address, RpcStrategySingleServer.create(address));
        }
        return this;
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return DiscoveryService.combined(this.shards.values().stream().map(RpcStrategy::getDiscoveryService).collect(Collectors.toList()));
    }

    @Override
    @Nullable
    public RpcSender createSender(RpcClientConnectionPool pool) {
        HashMap<Object, RpcSender> shardsSenders = new HashMap<Object, RpcSender>();
        for (Map.Entry<Object, RpcStrategy> entry : this.shards.entrySet()) {
            Object shardId = entry.getKey();
            RpcStrategy strategy = entry.getValue();
            RpcSender sender = strategy.createSender(pool);
            if (sender == null) continue;
            shardsSenders.put(shardId, sender);
        }
        if (shardsSenders.size() < this.minShards) {
            return null;
        }
        if (shardsSenders.size() == 1) {
            return (RpcSender)Utils.first(shardsSenders.values());
        }
        RpcSender[] sendersBuckets = new RpcSender[this.buckets];
        for (int n = 0; n < sendersBuckets.length; ++n) {
            RpcSender chosenSender = null;
            int max = Integer.MIN_VALUE;
            for (Map.Entry entry : shardsSenders.entrySet()) {
                Object key = entry.getKey();
                RpcSender sender = (RpcSender)entry.getValue();
                int hash = this.hashBucketFunction.hash(key, n);
                if (hash < max) continue;
                chosenSender = sender;
                max = hash;
            }
            assert (chosenSender != null);
            sendersBuckets[n] = chosenSender;
        }
        return new Sender(this.hashFunction, sendersBuckets);
    }

    public Map<Object, RpcStrategy> getShards() {
        return Collections.unmodifiableMap(this.shards);
    }

    void setShards(Map<Object, RpcStrategy> shards) {
        this.shards.clear();
        this.shards.putAll(shards);
    }

    static final class Sender
    implements RpcSender {
        private final HashFunction<?> hashFunction;
        private final RpcSender[] hashBuckets;

        Sender(@NotNull HashFunction<?> hashFunction, RpcSender[] hashBuckets) {
            this.hashFunction = hashFunction;
            this.hashBuckets = hashBuckets;
        }

        @Override
        public <I, O> void sendRequest(I request, int timeout, @NotNull Callback<O> cb) {
            int hash = this.hashFunction.hashCode(request);
            RpcSender sender = this.hashBuckets[hash & this.hashBuckets.length - 1];
            sender.sendRequest(request, timeout, cb);
        }
    }

    @VisibleForTesting
    static final class DefaultHashBucketFunction
    implements HashBucketFunction {
        DefaultHashBucketFunction() {
        }

        @Override
        public int hash(Object shardId, int bucket) {
            return HashUtils.murmur3hash((int)shardId.hashCode(), (int)bucket);
        }
    }
}

