/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.async.callback.Callback;
import io.activej.rpc.client.RpcClientConnectionPool;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcSender;
import io.activej.rpc.client.sender.RpcStrategy;
import io.activej.rpc.client.sender.RpcStrategyList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RpcStrategyRoundRobin
implements RpcStrategy {
    private final RpcStrategyList list;
    private final int minActiveSubStrategies;

    private RpcStrategyRoundRobin(RpcStrategyList list, int minActiveSubStrategies) {
        this.list = list;
        this.minActiveSubStrategies = minActiveSubStrategies;
    }

    public static RpcStrategyRoundRobin create(RpcStrategyList list) {
        return new RpcStrategyRoundRobin(list, 0);
    }

    public RpcStrategyRoundRobin withMinActiveSubStrategies(int minActiveSubStrategies) {
        return new RpcStrategyRoundRobin(this.list, minActiveSubStrategies);
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return this.list.getDiscoveryService();
    }

    @Override
    @Nullable
    public RpcSender createSender(RpcClientConnectionPool pool) {
        List<RpcSender> subSenders = this.list.listOfSenders(pool);
        if (subSenders.size() < this.minActiveSubStrategies) {
            return null;
        }
        if (subSenders.isEmpty()) {
            return null;
        }
        if (subSenders.size() == 1) {
            return subSenders.get(0);
        }
        return new Sender(subSenders);
    }

    private static final class Sender
    implements RpcSender {
        private int nextSender;
        private final RpcSender[] subSenders;

        Sender(@NotNull List<RpcSender> senders) {
            assert (!senders.isEmpty());
            this.subSenders = senders.toArray(new RpcSender[0]);
            this.nextSender = 0;
        }

        @Override
        public <I, O> void sendRequest(I request, int timeout, @NotNull Callback<O> cb) {
            RpcSender sender = this.subSenders[this.nextSender];
            this.nextSender = (this.nextSender + 1) % this.subSenders.length;
            sender.sendRequest(request, timeout, cb);
        }
    }
}

