/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.async.callback.Callback;
import io.activej.rpc.client.RpcClientConnectionPool;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcSender;
import io.activej.rpc.client.sender.RpcStrategies;
import io.activej.rpc.client.sender.RpcStrategy;
import io.activej.rpc.client.sender.RpcStrategyList;
import io.activej.rpc.hash.ShardingFunction;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RpcStrategySharding
implements RpcStrategy {
    private final RpcStrategyList list;
    private final ShardingFunction<?> shardingFunction;
    private final int minActiveSubStrategies;

    private RpcStrategySharding(@NotNull ShardingFunction<?> shardingFunction, @NotNull RpcStrategyList list, int minActiveSubStrategies) {
        this.shardingFunction = shardingFunction;
        this.list = list;
        this.minActiveSubStrategies = minActiveSubStrategies;
    }

    public static RpcStrategySharding create(ShardingFunction<?> shardingFunction, RpcStrategyList list) {
        return new RpcStrategySharding(shardingFunction, list, 0);
    }

    public RpcStrategySharding withMinActiveSubStrategies(int minActiveSubStrategies) {
        return new RpcStrategySharding(this.shardingFunction, this.list, minActiveSubStrategies);
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return this.list.getDiscoveryService();
    }

    @Override
    @Nullable
    public RpcSender createSender(RpcClientConnectionPool pool) {
        List<RpcSender> subSenders = this.list.listOfNullableSenders(pool);
        int activeSenders = 0;
        for (RpcSender subSender : subSenders) {
            if (subSender == null) continue;
            ++activeSenders;
        }
        if (activeSenders < this.minActiveSubStrategies) {
            return null;
        }
        if (subSenders.isEmpty()) {
            return null;
        }
        if (subSenders.size() == 1) {
            return subSenders.get(0);
        }
        return new Sender(this.shardingFunction, subSenders);
    }

    private static final class Sender
    implements RpcSender {
        private final ShardingFunction<?> shardingFunction;
        private final RpcSender[] subSenders;

        Sender(@NotNull ShardingFunction<?> shardingFunction, @NotNull List<RpcSender> senders) {
            assert (!senders.isEmpty());
            this.shardingFunction = shardingFunction;
            this.subSenders = senders.toArray(new RpcSender[0]);
        }

        @Override
        public <I, O> void sendRequest(I request, int timeout, @NotNull Callback<O> cb) {
            int shardIndex = this.shardingFunction.getShard(request);
            RpcSender sender = this.subSenders[shardIndex];
            if (sender != null) {
                sender.sendRequest(request, timeout, cb);
            } else {
                cb.accept(null, (Exception)RpcStrategies.NO_SENDER_AVAILABLE_EXCEPTION);
            }
        }
    }
}

