/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.common.Utils;
import io.activej.rpc.client.RpcClientConnectionPool;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcSender;
import io.activej.rpc.client.sender.RpcStrategy;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;

public final class RpcStrategySingleServer
implements RpcStrategy {
    private final InetSocketAddress address;

    private RpcStrategySingleServer(@NotNull InetSocketAddress address) {
        this.address = address;
    }

    public static RpcStrategySingleServer create(InetSocketAddress address) {
        return new RpcStrategySingleServer(address);
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return DiscoveryService.constant(Utils.mapOf((Object)this.address, (Object)this.address));
    }

    @Override
    public RpcSender createSender(RpcClientConnectionPool pool) {
        return pool.get(this.address);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }
}

