/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.async.callback.Callback;
import io.activej.common.Checks;
import io.activej.rpc.client.RpcClientConnectionPool;
import io.activej.rpc.client.sender.DiscoveryService;
import io.activej.rpc.client.sender.RpcSender;
import io.activej.rpc.client.sender.RpcStrategies;
import io.activej.rpc.client.sender.RpcStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RpcStrategyTypeDispatching
implements RpcStrategy {
    private final Map<Class<?>, RpcStrategy> dataTypeToStrategy = new HashMap();
    private RpcStrategy defaultStrategy;

    private RpcStrategyTypeDispatching() {
    }

    public static RpcStrategyTypeDispatching create() {
        return new RpcStrategyTypeDispatching();
    }

    public RpcStrategyTypeDispatching on(@NotNull Class<?> dataType, @NotNull RpcStrategy strategy) {
        Checks.checkState((!this.dataTypeToStrategy.containsKey(dataType) ? 1 : 0) != 0, () -> "Strategy for type " + dataType + " is already set");
        this.dataTypeToStrategy.put(dataType, strategy);
        return this;
    }

    public RpcStrategyTypeDispatching onDefault(RpcStrategy strategy) {
        Checks.checkState((this.defaultStrategy == null ? 1 : 0) != 0, (Object)"Default Strategy is already set");
        this.defaultStrategy = strategy;
        return this;
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        ArrayList<DiscoveryService> discoveryServices = new ArrayList<DiscoveryService>();
        for (RpcStrategy value : this.dataTypeToStrategy.values()) {
            discoveryServices.add(value.getDiscoveryService());
        }
        discoveryServices.add(this.defaultStrategy.getDiscoveryService());
        return DiscoveryService.combined(discoveryServices);
    }

    @Override
    @Nullable
    public RpcSender createSender(RpcClientConnectionPool pool) {
        HashMap typeToSender = new HashMap();
        for (Map.Entry<Class<?>, RpcStrategy> entry : this.dataTypeToStrategy.entrySet()) {
            RpcSender sender = entry.getValue().createSender(pool);
            if (sender == null) {
                return null;
            }
            typeToSender.put(entry.getKey(), sender);
        }
        RpcSender defaultSender = null;
        if (this.defaultStrategy != null) {
            defaultSender = this.defaultStrategy.createSender(pool);
            if (typeToSender.isEmpty()) {
                return defaultSender;
            }
            if (defaultSender == null) {
                return null;
            }
        }
        return new Sender(typeToSender, defaultSender);
    }

    static final class Sender
    implements RpcSender {
        private final HashMap<Class<?>, RpcSender> typeToSender;
        @Nullable
        private final RpcSender defaultSender;

        Sender(@NotNull HashMap<Class<?>, RpcSender> typeToSender, @Nullable RpcSender defaultSender) {
            this.typeToSender = typeToSender;
            this.defaultSender = defaultSender;
        }

        @Override
        public <I, O> void sendRequest(I request, int timeout, @NotNull Callback<O> cb) {
            RpcSender sender = this.typeToSender.get(request.getClass());
            if (sender == null) {
                sender = this.defaultSender;
            }
            if (sender != null) {
                sender.sendRequest(request, timeout, cb);
            } else {
                cb.accept(null, (Exception)RpcStrategies.NO_SENDER_AVAILABLE_EXCEPTION);
            }
        }
    }
}

