/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.client.sender;

import io.activej.async.callback.Callback;
import io.activej.common.Checks;
import io.activej.eventloop.Eventloop;
import io.activej.rpc.client.sender.DiscoveryService;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class SettableDiscoveryService
implements DiscoveryService {
    private static final boolean CHECK = Checks.isEnabled(SettableDiscoveryService.class);
    private Map<Object, InetSocketAddress> addressMap;
    private final List<Callback<Map<Object, InetSocketAddress>>> callbacks = new ArrayList<Callback<Map<Object, InetSocketAddress>>>();

    private SettableDiscoveryService(Map<Object, InetSocketAddress> addressMap) {
        this.addressMap = Collections.unmodifiableMap(new HashMap<Object, InetSocketAddress>(addressMap));
    }

    public static SettableDiscoveryService create(Map<Object, InetSocketAddress> addressMap) {
        return new SettableDiscoveryService(addressMap);
    }

    @Override
    public void discover(@Nullable Map<Object, InetSocketAddress> previous, Callback<Map<Object, InetSocketAddress>> cb) {
        if (!this.addressMap.equals(previous)) {
            cb.accept(this.addressMap, null);
            return;
        }
        this.callbacks.add(cb);
    }

    public void setAddressMap(Map<Object, InetSocketAddress> addressMap) {
        if (CHECK) {
            Checks.checkState((boolean)Eventloop.getCurrentEventloop().inEventloopThread());
        }
        if (this.addressMap.equals(addressMap)) {
            return;
        }
        this.addressMap = Collections.unmodifiableMap(new HashMap<Object, InetSocketAddress>(addressMap));
        ArrayList<Callback<Map<Object, InetSocketAddress>>> callbacks = new ArrayList<Callback<Map<Object, InetSocketAddress>>>(this.callbacks);
        this.callbacks.clear();
        callbacks.forEach(cb -> cb.accept((Object)addressMap, null));
    }
}

