/*
 * Decompiled with CFR 0.152.
 */
package io.activej.rpc.protocol;

import io.activej.rpc.protocol.RpcException;
import io.activej.rpc.protocol.RpcMandatoryData;
import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import io.activej.serializer.annotations.SerializeNullable;
import org.jetbrains.annotations.Nullable;

public final class RpcRemoteException
extends RpcException
implements RpcMandatoryData {
    private static final long serialVersionUID = 769022174067373741L;
    @Nullable
    private final String causeMessage;
    @Nullable
    private final String causeClassName;

    public RpcRemoteException(Throwable cause) {
        super(cause.toString(), cause);
        this.causeClassName = cause.getClass().getName();
        this.causeMessage = cause.getMessage();
    }

    public RpcRemoteException(String message) {
        super(message);
        this.causeClassName = null;
        this.causeMessage = null;
    }

    public RpcRemoteException(@Deserialize(value="message") String message, @Deserialize(value="causeClassName") @Nullable String causeClassName, @Deserialize(value="causeMessage") @Nullable String causeMessage) {
        super(message);
        this.causeClassName = causeClassName;
        this.causeMessage = causeMessage;
    }

    @Serialize(order=1)
    @SerializeNullable
    @Nullable
    public String getCauseClassName() {
        return this.causeClassName;
    }

    @Serialize(order=2)
    @SerializeNullable
    @Nullable
    public String getCauseMessage() {
        return this.causeMessage;
    }

    @Override
    @Serialize(order=3)
    @SerializeNullable
    public String getMessage() {
        return super.getMessage();
    }
}

