/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.AbstractSerializerDef;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefClass;
import io.activej.serializer.impl.SerializerExpressions;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class SerializerDefReference
extends AbstractSerializerDef
implements SerializerDef {
    public static final ThreadLocal<IdentityHashMap<Object, Integer>> MAP_ENCODE = ThreadLocal.withInitial(IdentityHashMap::new);
    public static final ThreadLocal<HashMap<Integer, Object>> MAP_DECODE = ThreadLocal.withInitial(HashMap::new);
    private final SerializerDef serializer;

    public SerializerDefReference(@NotNull SerializerDef serializer) {
        this.serializer = serializer;
    }

    @Override
    public void accept(SerializerDef.Visitor visitor) {
        visitor.visit(this.serializer);
    }

    @Override
    public boolean isInline(int version, CompatibilityLevel compatibilityLevel) {
        return false;
    }

    @Override
    public Class<?> getEncodeType() {
        return this.serializer.getEncodeType();
    }

    @Override
    public Map<Object, Expression> getEncoderInitializer() {
        return SerializerDefReference.clearMap(SerializerDefReference.encodeMap());
    }

    @Override
    public Map<Object, Expression> getEncoderFinalizer() {
        return SerializerDefReference.clearMap(SerializerDefReference.encodeMap());
    }

    @Override
    public Map<Object, Expression> getDecoderInitializer() {
        return SerializerDefReference.clearMap(SerializerDefReference.decodeMap());
    }

    @Override
    public Map<Object, Expression> getDecoderFinalizer() {
        return SerializerDefReference.clearMap(SerializerDefReference.decodeMap());
    }

    @Override
    public Expression encoder(SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
        return Expressions.let((Expression)SerializerDefReference.encodeMap(), map -> Expressions.let((Expression)Expressions.call((Expression)map, (String)"get", (Expression[])new Expression[]{value}), index -> Expressions.ifThenElse((Expression)Expressions.isNull((Expression)index), (Expression)Expressions.sequence((Expression[])new Expression[]{Expressions.call((Expression)map, (String)"put", (Expression[])new Expression[]{value, Expressions.cast((Expression)Expressions.add((Expression)Expressions.call((Expression)map, (String)"size", (Expression[])new Expression[0]), (Expression)Expressions.value((Object)1)), Integer.class)}), SerializerExpressions.writeByte(buf, pos, Expressions.value((Object)0)), this.serializer.defineEncoder(staticEncoders, buf, pos, value, version, compatibilityLevel)}), (Expression)SerializerExpressions.writeVarInt(buf, pos, Expressions.cast((Expression)index, Integer.class)))));
    }

    @Override
    public Expression decoder(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel) {
        return Expressions.let((Expression)SerializerDefReference.decodeMap(), map -> Expressions.let((Expression)SerializerExpressions.readVarInt(in), index -> {
            UnaryOperator instanceInitializer = instance -> Expressions.call((Expression)map, (String)"put", (Expression[])new Expression[]{Expressions.cast((Expression)Expressions.add((Expression)Expressions.call((Expression)map, (String)"size", (Expression[])new Expression[0]), (Expression)Expressions.value((Object)1)), Integer.class), instance});
            return Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)index, (Expression)Expressions.value((Object)0)), (Expression)(this.serializer instanceof SerializerDefClass ? ((SerializerDefClass)this.serializer).decoder(staticDecoders, in, version, compatibilityLevel, instanceInitializer) : Expressions.let((Expression)this.serializer.decoder(staticDecoders, in, version, compatibilityLevel), item -> Expressions.sequence((Expression[])new Expression[]{(Expression)instanceInitializer.apply(item), item}))), (Expression)Expressions.cast((Expression)Expressions.call((Expression)map, (String)"get", (Expression[])new Expression[]{Expressions.cast((Expression)index, Integer.class)}), this.serializer.getDecodeType()));
        }));
    }

    private static Expression encodeMap() {
        return Expressions.cast((Expression)Expressions.call((Expression)Expressions.staticField(SerializerDefReference.class, (String)"MAP_ENCODE"), (String)"get", (Expression[])new Expression[0]), Map.class);
    }

    private static Expression decodeMap() {
        return Expressions.cast((Expression)Expressions.call((Expression)Expressions.staticField(SerializerDefReference.class, (String)"MAP_DECODE"), (String)"get", (Expression[])new Expression[0]), Map.class);
    }

    private static Map<Object, Expression> clearMap(Expression map) {
        return Collections.singletonMap(SerializerDefReference.class, Expressions.call((Expression)map, (String)"clear", (Expression[])new Expression[0]));
    }
}

